/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.domain.Bloqueto;
import br.com.elotech.tributos.domain.CancelamentoBoleto;
import br.com.elotech.tributos.domain.CancelamentoBoletoItem;
import br.com.elotech.tributos.domain.CancelamentoBoletoItemId;
import br.com.elotech.tributos.dto.FiltroBoletoDTO;
import br.com.elotech.tributos.repository.CancelamentoBoletoRepository;
import br.com.elotech.tributos.security.SecurityUtils;
import br.com.elotech.tributos.service.BloquetoService;
import br.com.elotech.tributos.service.integracaoboleto.IntegracaoBoletoRegistradoReceiver;
import java.time.LocalDate;
import java.util.List;
import lombok.Generated;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class CancelamentoBoletoService
extends CrudService<CancelamentoBoleto, Long> {
    private final BloquetoService bloquetoService;
    private final IntegracaoBoletoRegistradoReceiver integracaoBoletoRegistradoReceiver;
    private final CancelamentoBoletoRepository cancelamentoBoletoRepository;

    public CancelamentoBoleto cancelarBoletoId(List<Long> idBoletos) {
        return this.cancelarBoleto(this.bloquetoService.findByBloquetoIds(idBoletos));
    }

    public CancelamentoBoleto cancelarBoletoPorFiltro(FiltroBoletoDTO filtro) {
        return this.cancelarBoleto(this.bloquetoService.findAllByFiltro(filtro));
    }

    private CancelamentoBoleto cancelarBoleto(List<Bloqueto> boletos) {
        CancelamentoBoleto cancelamentoBoleto = new CancelamentoBoleto();
        cancelamentoBoleto.setDataCancelamento(LocalDate.now());
        cancelamentoBoleto.setUsuario(SecurityUtils.getUserAise());
        boletos.forEach(boleto -> {
            try {
                this.integracaoBoletoRegistradoReceiver.receiveCancelamento(boleto);
                CancelamentoBoletoService.createCancelamentoBoletoItem((Bloqueto)boleto, (CancelamentoBoleto)cancelamentoBoleto, (String)"Cancelamento do boleto realizado com sucesso!", (Boolean)Boolean.FALSE);
            }
            catch (Exception e) {
                CancelamentoBoletoService.createCancelamentoBoletoItem((Bloqueto)boleto, (CancelamentoBoleto)cancelamentoBoleto, (String)("Erro ao cancelar o boleto: " + e.getMessage()), (Boolean)Boolean.TRUE);
            }
        });
        return (CancelamentoBoleto)this.cancelamentoBoletoRepository.save((Object)cancelamentoBoleto);
    }

    private static void createCancelamentoBoletoItem(Bloqueto boleto, CancelamentoBoleto cancelamentoBoleto, String mensagem, Boolean comErro) {
        CancelamentoBoletoItem cancelamentoBoletoItem = new CancelamentoBoletoItem();
        cancelamentoBoletoItem.setId(new CancelamentoBoletoItemId(cancelamentoBoleto, boleto));
        cancelamentoBoletoItem.setMensagem(mensagem);
        cancelamentoBoletoItem.setComErro(comErro);
        cancelamentoBoleto.getBoleto().add(cancelamentoBoletoItem);
    }

    @Generated
    public CancelamentoBoletoService(BloquetoService bloquetoService, IntegracaoBoletoRegistradoReceiver integracaoBoletoRegistradoReceiver, CancelamentoBoletoRepository cancelamentoBoletoRepository) {
        this.bloquetoService = bloquetoService;
        this.integracaoBoletoRegistradoReceiver = integracaoBoletoRegistradoReceiver;
        this.cancelamentoBoletoRepository = cancelamentoBoletoRepository;
    }
}

