/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.security;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.multitenant.filter.TenantContextHolder;
import br.com.elotech.tributos.dto.UserSecurityDTO;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.keycloak.KeycloakSecurityContext;
import org.keycloak.adapters.springsecurity.token.KeycloakAuthenticationToken;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.IDToken;
import org.keycloak.representations.JsonWebToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class SecurityUtils {
    private static final Logger LOG = LoggerFactory.getLogger(SecurityUtils.class);
    public static final String USUARIO_CLAIM = "usuario_aise";
    public static final String USUARIO_INTEGRACAO_GEO_CLAIM = "integracao-geo";
    public static final String INTEGRACAO_GEO_TENANT_CLAIM = "integracao-geo-tenant";
    public static final String INTEGRACAO_REQUERIMENTO = "integracao-requerimento";
    public static final String INTEGRACAO_REQUERIMENTO_TENANT = "integracao-requerimento-tenant";
    public static final String INTEGRACAO_GEO_TIPOS_CADASTROS = "integracao-geo-tipos-cadastros";

    public static UUID getUserId() {
        return SecurityUtils.getSecurityContext().map(KeycloakSecurityContext::getToken).map(JsonWebToken::getSubject).map(UUID::fromString).orElse(null);
    }

    public static String getPreferredUsername() {
        return SecurityUtils.getSecurityContext().map(KeycloakSecurityContext::getToken).map(IDToken::getPreferredUsername).orElse(null);
    }

    public static String getUserName() {
        return SecurityUtils.getSecurityContext().map(KeycloakSecurityContext::getToken).map(IDToken::getName).orElse("");
    }

    public static String getUserAise() {
        if (TenantContextHolder.hasTenant()) {
            return SecurityUtils.getToken().map(IDToken::getPreferredUsername).filter(userName -> userName.matches("^(\\d+)$")).or(() -> Optional.ofNullable(SecurityUtils.getUserAiseOfToken())).orElse(null);
        }
        return SecurityUtils.getUserAiseOfToken();
    }

    private static String getUserAiseOfToken() {
        return SecurityUtils.getSecurityContext().map(KeycloakSecurityContext::getToken).map(JsonWebToken::getOtherClaims).map(claims -> claims.get("usuario_aise")).map(Object::toString).orElse(null);
    }

    public static Boolean isUsuarioIntegracaoRequerimento() {
        return SecurityUtils.getSecurityContext().map(KeycloakSecurityContext::getToken).map(JsonWebToken::getOtherClaims).map(claims -> claims.get("integracao-requerimento")).map(Object::toString).map(Boolean::parseBoolean).orElse(Boolean.FALSE);
    }

    public static Optional<String> getTenantIntegracaoRequerimento() {
        return SecurityUtils.getSecurityContext().map(KeycloakSecurityContext::getToken).map(JsonWebToken::getOtherClaims).map(claims -> claims.get("integracao-requerimento-tenant")).map(Object::toString);
    }

    public static Boolean isUsuarioIntegracaoGeo() {
        return SecurityUtils.getSecurityContext().map(KeycloakSecurityContext::getToken).map(JsonWebToken::getOtherClaims).map(claims -> claims.get("integracao-geo")).map(Object::toString).map(Boolean::parseBoolean).orElse(Boolean.FALSE);
    }

    public static Optional<String> getTenantIntegracaoGeo() {
        return SecurityUtils.getSecurityContext().map(KeycloakSecurityContext::getToken).map(JsonWebToken::getOtherClaims).map(claims -> claims.get("integracao-geo-tenant")).map(Object::toString);
    }

    public static Optional<AccessToken> getToken() {
        return SecurityUtils.getSecurityContext().map(KeycloakSecurityContext::getToken);
    }

    public static AccessToken getAccessToken() {
        return SecurityUtils.getSecurityContext().map(KeycloakSecurityContext::getToken).orElseThrow(() -> new EloValidationException("N\u00e3o foi poss\u00edvel obter o access token do usu\u00e1rio na requisi\u00e7\u00e3o"));
    }

    private static String getRequestIP(RequestAttributes attributes) {
        if (Objects.isNull(attributes)) {
            return "";
        }
        ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes)attributes;
        String remoteAddr = servletRequestAttributes.getRequest().getHeader("X-FORWARDED-FOR");
        if (StringUtils.isBlank((CharSequence)remoteAddr)) {
            return servletRequestAttributes.getRequest().getRemoteAddr();
        }
        return "";
    }

    public static String getRequestIP() {
        return SecurityUtils.getRequestIP((RequestAttributes)RequestContextHolder.getRequestAttributes());
    }

    public static KeycloakAuthenticationToken getAuthentication() {
        return (KeycloakAuthenticationToken)SecurityContextHolder.getContext().getAuthentication();
    }

    public static Optional<KeycloakSecurityContext> getSecurityContext() {
        Optional<KeycloakSecurityContext> requestSecurityContext = Optional.ofNullable(RequestContextHolder.getRequestAttributes()).map(requestAttributes -> (KeycloakSecurityContext)requestAttributes.getAttribute(KeycloakSecurityContext.class.getName(), 0));
        if (requestSecurityContext.isPresent()) {
            return requestSecurityContext;
        }
        return Optional.ofNullable(SecurityUtils.getAuthentication()).map(token -> token.getAccount().getKeycloakSecurityContext());
    }

    public static UserSecurityDTO getUserSecurityDTO() {
        return new UserSecurityDTO(SecurityUtils.getUserId(), SecurityUtils.getUserAise());
    }

    public static String getPermissaoCadastrosGeo() {
        return SecurityUtils.getSecurityContext().map(KeycloakSecurityContext::getToken).map(JsonWebToken::getOtherClaims).map(claims -> claims.get("integracao-geo-tipos-cadastros")).map(Object::toString).orElse("");
    }

    public static Boolean getPermissaoByString(String permissoes, String permissaoAProcurar) {
        String[] listCadastrosPermitidos;
        for (String cadastro : listCadastrosPermitidos = permissoes.split(";")) {
            if (!cadastro.contentEquals(permissaoAProcurar)) continue;
            return true;
        }
        return false;
    }
}

