/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource.integracaoelogeo;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.dto.integracaoelogeo.BairroElogeoDTO;
import br.com.elotech.tributos.service.BairroService;
import io.swagger.v3.oas.annotations.Operation;
import org.springdoc.api.annotations.ParameterObject;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/elogeo/bairro"})
public class BairroElogeoResource {
    private final BairroService bairroService;

    public BairroElogeoResource(BairroService bairroService) {
        this.bairroService = bairroService;
    }

    @Operation(summary="Retorna uma lista de bairros")
    @GetMapping
    public ResponseEntity<Page<BairroElogeoDTO>> findAllByCidadeEntidadePrincipal(@ParameterObject Pageable page) {
        Page bairros = this.bairroService.findAllByCidadeEntidadePrincipal(page).map(BairroElogeoDTO::from);
        return ResponseEntity.ok((Object)bairros);
    }

    @Operation(summary="Retorna um bairro em espec\u00edfico")
    @GetMapping(value={"/{codigo}"})
    public ResponseEntity<BairroElogeoDTO> findByBairroAndCidadeEntidadePrincipal(@PathVariable Long codigo) {
        BairroElogeoDTO bairroDTO = this.bairroService.findByBairroAndCidadeEntidadePrincipal(codigo).map(BairroElogeoDTO::from).orElseThrow(() -> new EloValidationException(String.format("N\u00e3o foi poss\u00edvel encontrar o Bairro com o c\u00f3digo '%d'.", codigo)));
        return ResponseEntity.ok((Object)bairroDTO);
    }
}

