/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource;

import br.com.elotech.core.resource.support.CrudResource;
import br.com.elotech.tributos.domain.parcelamento.ParamParcelamento;
import br.com.elotech.tributos.dto.ParamParcelamentoDTO;
import br.com.elotech.tributos.dto.parcelamento.FiltroDebitoAbertoDTO;
import br.com.elotech.tributos.params.FiltroDebitoParams;
import br.com.elotech.tributos.service.ParamParcelamentoService;
import java.util.List;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/paramparcelamento"})
public class ParamParcelamentoResource
extends CrudResource<ParamParcelamento, Long> {
    private final ParamParcelamentoService paramParcelamentoService;

    public ParamParcelamentoResource(ParamParcelamentoService paramParcelamentoService) {
        this.paramParcelamentoService = paramParcelamentoService;
    }

    @PostMapping(value={"/teste-filtro-debito"})
    public ResponseEntity<List<FiltroDebitoAbertoDTO>> testeFiltroDebito(@RequestBody FiltroDebitoParams params) {
        return ResponseEntity.ok((Object)this.paramParcelamentoService.testeScriptFiltroDebito(params));
    }

    @GetMapping(value={"/permissao-usuario"})
    public ResponseEntity<Page<ParamParcelamento>> findAllByPermissaoUsuario(Pageable pageable) {
        return ResponseEntity.ok((Object)this.paramParcelamentoService.findParametrosByPermissaoUsuario(pageable));
    }

    @PutMapping(value={"/{id}/cidadao"})
    public ResponseEntity<ParamParcelamentoDTO> updateParametroParcelamentoCidadao(@RequestBody ParamParcelamentoDTO paramParcelamentoDTO) {
        return ResponseEntity.ok((Object)this.paramParcelamentoService.salvarParametroParcelamentoCidadao(paramParcelamentoDTO));
    }

    @GetMapping(value={"/disponivel-cidadao"})
    public ResponseEntity<List<ParamParcelamento>> findByDisponivelCidadao() {
        return ResponseEntity.ok((Object)this.paramParcelamentoService.findByDisponivelCidadao());
    }
}

