/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.CancelamentoBoleto;
import br.com.elotech.tributos.dto.FiltroBoletoDTO;
import br.com.elotech.tributos.dto.cancelamentoboleto.CancelamentoBoletoResponseDTO;
import br.com.elotech.tributos.service.CancelamentoBoletoService;
import java.io.Serializable;
import java.util.List;
import lombok.Generated;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/cancelamento-boleto"})
public class CancelamentoBoletoResource {
    private final CancelamentoBoletoService cancelamentoBloquetoService;

    @PostMapping
    public ResponseEntity<CancelamentoBoleto> cancelamentoBoleto(@RequestBody List<Long> idBoletos) {
        return ResponseEntity.ok((Object)this.cancelamentoBloquetoService.cancelarBoletoId(idBoletos));
    }

    @PostMapping(value={"/filtro"})
    public ResponseEntity<CancelamentoBoleto> cancelamentoBoletoPorFiltro(@RequestBody FiltroBoletoDTO filtro) {
        return ResponseEntity.ok((Object)this.cancelamentoBloquetoService.cancelarBoletoPorFiltro(filtro));
    }

    @GetMapping
    public ResponseEntity<Page<CancelamentoBoletoResponseDTO>> findAll(@RequestParam(value="search", required=false) String search, Pageable pageable) {
        Page cancelamentoBoleto = this.cancelamentoBloquetoService.findByRsql(search, pageable);
        return ResponseEntity.ok((Object)cancelamentoBoleto.map(CancelamentoBoletoResponseDTO::fromEntity));
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<CancelamentoBoletoResponseDTO> findById(@PathVariable(value="id") Long id) {
        CancelamentoBoleto cancelamentoBoleto = (CancelamentoBoleto)this.cancelamentoBloquetoService.findById((Serializable)id).orElseThrow(() -> new EloValidationException(String.format("Cancelamento de boleto com id %s n\u00e3o encontrado", id)));
        return ResponseEntity.ok((Object)CancelamentoBoletoResponseDTO.fromEntityWithBoletos((CancelamentoBoleto)cancelamentoBoleto));
    }

    @Generated
    public CancelamentoBoletoResource(CancelamentoBoletoService cancelamentoBloquetoService) {
        this.cancelamentoBloquetoService = cancelamentoBloquetoService;
    }
}

