/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource;

import br.com.elotech.audit.domain.ChangeWithRevision;
import br.com.elotech.core.exception.RestException;
import br.com.elotech.core.resource.support.ReadOnlyResource;
import br.com.elotech.tributos.audit.AuditService;
import br.com.elotech.tributos.domain.TipoCadastro;
import br.com.elotech.tributos.domain.mobiliario.CadastroMobiliario;
import br.com.elotech.tributos.domain.relatorio.RelatorioSistema;
import br.com.elotech.tributos.dto.AdvancedSearchItemDTO;
import br.com.elotech.tributos.dto.CadastroGeralSearchParamsDTO;
import br.com.elotech.tributos.dto.CadastroMobiliarioAlteracaoCadastralDTO;
import br.com.elotech.tributos.dto.CadastroMobiliarioDTO;
import br.com.elotech.tributos.dto.CadastroMobiliarioRowDTO;
import br.com.elotech.tributos.dto.CadastroMobiliarioSituacaoDTO;
import br.com.elotech.tributos.dto.CadastroSearchDTO;
import br.com.elotech.tributos.dto.ContratoSocialDTO;
import br.com.elotech.tributos.dto.ContratoSocialPessoaDTO;
import br.com.elotech.tributos.dto.ImprimirRelatorioDTO;
import br.com.elotech.tributos.dto.mobile.CadastroMobiliarioMobileDTO;
import br.com.elotech.tributos.resource.RelatorioResource;
import br.com.elotech.tributos.service.CadastroMobiliarioService;
import br.com.elotech.tributos.service.ContratoSocialPessoaService;
import br.com.elotech.tributos.service.ImpressaoEspelhoCadastrosService;
import br.com.elotech.tributos.util.DateUtils;
import java.io.IOException;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/cadastro-mobiliario"})
public class CadastroMobiliarioResource
extends ReadOnlyResource<CadastroMobiliario, Long> {
    private final CadastroMobiliarioService cadastroMobiliarioService;
    private final ContratoSocialPessoaService contratoSocialPessoaService;
    private final RelatorioResource relatorioResource;
    private final ImpressaoEspelhoCadastrosService impressaoEspelhoCadastrosService;
    private final AuditService auditService;

    public CadastroMobiliarioResource(CadastroMobiliarioService cadastroMobiliarioService, ContratoSocialPessoaService contratoSocialPessoaService, RelatorioResource relatorioResource, ImpressaoEspelhoCadastrosService impressaoEspelhoCadastrosService, AuditService auditService) {
        this.cadastroMobiliarioService = cadastroMobiliarioService;
        this.contratoSocialPessoaService = contratoSocialPessoaService;
        this.relatorioResource = relatorioResource;
        this.impressaoEspelhoCadastrosService = impressaoEspelhoCadastrosService;
        this.auditService = auditService;
    }

    @PostMapping(value={"/alteracao-cadastral"})
    public ResponseEntity<CadastroMobiliarioAlteracaoCadastralDTO> alterarCadastroMobiliario(@RequestBody CadastroMobiliarioAlteracaoCadastralDTO cadastroMobiliarioAlteracaoCadastralDTO) {
        CadastroMobiliario cadastroMobiliario = this.cadastroMobiliarioService.alteracaoCadastral(cadastroMobiliarioAlteracaoCadastralDTO);
        return ResponseEntity.ok().body((Object)CadastroMobiliarioAlteracaoCadastralDTO.from((CadastroMobiliario)cadastroMobiliario));
    }

    @GetMapping(value={"/{cadastroGeral}/contrato-social/participantes"})
    public ResponseEntity<List<ContratoSocialPessoaDTO>> findParticipantesUltimoContrato(@PathVariable(value="cadastroGeral") Long cadastroGeral) {
        return ResponseEntity.ok((Object)this.contratoSocialPessoaService.findParticipantesUltimoContrato(cadastroGeral));
    }

    @GetMapping(path={"/imprimir-espelho"}, params={"cadastroGeral"})
    public void imprimirEspelho(@RequestParam(value="cadastroGeral") Long cadastroGeral, HttpServletResponse response) throws IOException {
        ImprimirRelatorioDTO imprimirRelatorioDTO = this.impressaoEspelhoCadastrosService.buildImpressaoEspelhoDTO(RelatorioSistema.CADASTRO_MOBILIARIO_COMPLETO.getId(), TipoCadastro.MOBILIARIO, cadastroGeral);
        this.relatorioResource.imprimirRelatorioGenerico(imprimirRelatorioDTO, response);
    }

    @GetMapping(value={"/search"})
    public ResponseEntity<Page<CadastroMobiliarioMobileDTO>> searchCadastrosAtivosByNomeAndGrupoAtividade(@RequestParam(value="nome", required=false) String nome, @RequestParam(value="grupoAtividade", required=false) String grupoAtividade, Pageable pageable) {
        return ResponseEntity.ok((Object)this.cadastroMobiliarioService.searchCadastrosAtivosByNomeAndGrupoAtividade(nome, grupoAtividade, pageable));
    }

    @PostMapping(value={"/search"})
    public ResponseEntity<CadastroSearchDTO> searchCadastrosMobiliarios(@RequestBody CadastroGeralSearchParamsDTO searchParams, Pageable pageable) {
        return ResponseEntity.ok((Object)this.cadastroMobiliarioService.searchCadastrosMobiliarios(searchParams, pageable));
    }

    @PostMapping(value={"/advanced-search"})
    public ResponseEntity<CadastroSearchDTO> advancedSearchCadastrosMobiliarios(@RequestBody List<AdvancedSearchItemDTO> searchParams, Pageable pageable) {
        return ResponseEntity.ok((Object)this.cadastroMobiliarioService.advancedSearchCadastrosMobiliarios(searchParams, pageable));
    }

    @PostMapping
    public ResponseEntity<CadastroMobiliarioDTO> save(@Valid @RequestBody CadastroMobiliarioDTO cadastroMobiliarioDTO) {
        return ResponseEntity.ok((Object)this.cadastroMobiliarioService.save(cadastroMobiliarioDTO));
    }

    @PutMapping(value={"/{id}"})
    public ResponseEntity<CadastroMobiliarioDTO> update(@PathVariable Long id, @Valid @RequestBody CadastroMobiliarioDTO cadastroMobiliarioDTO) {
        return ResponseEntity.ok((Object)this.cadastroMobiliarioService.update(id, cadastroMobiliarioDTO));
    }

    @GetMapping(value={"/find/{id}"})
    public ResponseEntity<CadastroMobiliarioDTO> findCadastroMobiliarioById(@PathVariable Long id) {
        return ResponseEntity.ok((Object)this.cadastroMobiliarioService.findCadastroMobiliarioDTO(id));
    }

    @GetMapping(value={"/{id}/por-data"})
    public ResponseEntity<CadastroMobiliarioDTO> findByIdAtDate(@PathVariable Long id, @RequestParam(value="referenceDate") @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME) LocalDateTime date) {
        CadastroMobiliario found = (CadastroMobiliario)this.auditService.getRecordAtDate(CadastroMobiliario.class, (Serializable)id, date);
        if (Objects.isNull(found)) {
            throw RestException.notFound((String)String.format("N\u00e3o foi poss\u00edvel encontrar dados para o cadastro mobili\u00e1rio %d na data %s.", id, DateUtils.localDateTimeToStringFormatoBrasileiro((LocalDateTime)date)));
        }
        return ResponseEntity.ok((Object)CadastroMobiliarioDTO.fromComRespostaAgrupada((CadastroMobiliario)found));
    }

    @GetMapping(value={"/{id}/historico"})
    public ResponseEntity<Page<ChangeWithRevision>> getLog(@PathVariable(value="id") Long id, @RequestParam(value="search", required=false) String search, Pageable pageable) {
        return ResponseEntity.ok((Object)this.auditService.getRevisionForEntity(CadastroMobiliario.class, (Serializable)id, search, pageable));
    }

    @GetMapping(value={"/{id}/resumo"})
    public ResponseEntity<CadastroMobiliarioRowDTO> getResumo(@PathVariable(value="id") Long id) {
        return ResponseEntity.ok((Object)this.cadastroMobiliarioService.findById((Serializable)id).map(CadastroMobiliarioRowDTO::from).orElseThrow(() -> RestException.notFound((String)String.format("N\u00e3o foi poss\u00edvel encontrar o cadastro mobili\u00e1rio com id %d.", id))));
    }

    @GetMapping(value={"/{id}/situacoes"})
    public ResponseEntity<List<CadastroMobiliarioSituacaoDTO>> getSituacoes(@PathVariable Long id) {
        return ResponseEntity.ok((Object)this.cadastroMobiliarioService.getSituacoes(id));
    }

    @PostMapping(value={"/{id}/situacoes"})
    public ResponseEntity<List<CadastroMobiliarioSituacaoDTO>> createSituacao(@PathVariable Long id, @RequestBody @Valid CadastroMobiliarioSituacaoDTO newSituacaoDTO) {
        return ResponseEntity.ok((Object)this.cadastroMobiliarioService.createSituacao(id, newSituacaoDTO));
    }

    @GetMapping(value={"/{id}/contrato-social"})
    public ResponseEntity<List<ContratoSocialDTO>> getContratosSociais(@PathVariable Long id) {
        return ResponseEntity.ok((Object)this.cadastroMobiliarioService.getContratosSociais(id));
    }

    @GetMapping(value={"/{id}/contrato-social/por-data"})
    public ResponseEntity<List<ContratoSocialDTO>> getContratosSociaisPorData(@PathVariable Long id, @RequestParam(value="referenceDate") @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME) LocalDateTime date) {
        CadastroMobiliario cadastro = (CadastroMobiliario)this.auditService.getRecordAtDate(CadastroMobiliario.class, (Serializable)id, date);
        if (Objects.isNull(cadastro)) {
            throw RestException.notFound((String)String.format("N\u00e3o foi poss\u00edvel encontrar dados para o cadastro mobili\u00e1rio %d na data %s.", id, DateUtils.localDateTimeToStringFormatoBrasileiro((LocalDateTime)date)));
        }
        List contratos = cadastro.getContratosSocial().stream().map(ContratoSocialDTO::from).sorted(Comparator.comparing(ContratoSocialDTO::getSequencia).reversed()).collect(Collectors.toList());
        return ResponseEntity.ok(contratos);
    }

    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<Void> deleteById(@PathVariable Long id) {
        this.cadastroMobiliarioService.deleteById(id);
        return ResponseEntity.noContent().build();
    }

    @GetMapping(value={"/exists-cadastro-by-pessoa"}, params={"pessoa"})
    public ResponseEntity<Boolean> existsCadastroMobiliarioByPessoa(@RequestParam(value="pessoa") Long pessoa) {
        return ResponseEntity.ok((Object)this.cadastroMobiliarioService.existsCadastroMobiliarioByPessoa(pessoa));
    }
}

