/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource;

import br.com.elotech.tributos.domain.TipoDocumentoEnum;
import br.com.elotech.tributos.dto.DocumentoDTO;
import br.com.elotech.tributos.dto.DocumentoGenericoDTO;
import br.com.elotech.tributos.dto.DocumentoSearchInitialValuesDTO;
import br.com.elotech.tributos.dto.ImpressaoDTO;
import br.com.elotech.tributos.service.DocumentoService;
import java.io.IOException;
import javax.validation.Valid;
import lombok.Generated;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/alvara-licenca-sanitaria"})
public class AlvaraLicencaSanitariaResource {
    private final DocumentoService documentoService;

    @PostMapping(value={"/valores-iniciais"})
    public ResponseEntity<DocumentoGenericoDTO> getInitialValues(@RequestBody DocumentoSearchInitialValuesDTO documentoSearchInitialValuesDTO) {
        return ResponseEntity.ok((Object)this.documentoService.getInitialValues(documentoSearchInitialValuesDTO, TipoDocumentoEnum.ALVARA_LICENCA_SANITARIA));
    }

    @PostMapping
    public ResponseEntity<ImpressaoDTO> gerar(@RequestBody @Valid DocumentoGenericoDTO documentoGenericoDTO) throws IOException {
        DocumentoDTO dto = this.documentoService.gerar(documentoGenericoDTO, TipoDocumentoEnum.ALVARA_LICENCA_SANITARIA);
        return ResponseEntity.ok((Object)this.documentoService.imprimirDocumento(dto.getId(), documentoGenericoDTO.getRelatorioImpressao()));
    }

    @Generated
    public AlvaraLicencaSanitariaResource(DocumentoService documentoService) {
        this.documentoService = documentoService;
    }
}

