/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.repository.supersimples;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.tributos.domain.supersimples.SuperSimplesSolicitacaoCnpj;
import br.com.elotech.tributos.dto.supersimples.SuperSimplesSolicitacaoCadastroDTO;
import br.com.elotech.tributos.dto.supersimples.SuperSimplesSolicitacaoOcorrenciaDTO;
import br.com.elotech.tributos.exception.PaginationException;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.sql.DataSource;
import org.springframework.batch.support.DatabaseType;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.jdbc.support.MetaDataAccessException;
import org.springframework.stereotype.Repository;

@Repository
public class ConsultaSuperSimplesCNPJVarreduraAnualRepository {
    private static final String LOAD_CADASTROS_MOBILIARIO = "br/com/elotech/tributos/repository/supersimples/load-cadastros-mobiliario-super-simples.sql";
    private static final String LOAD_CADASTROS = "br/com/elotech/tributos/repository/supersimples/load-cadastros-super-simples.sql";
    private static final String LOAD_OCORRENCIA = "br/com/elotech/tributos/repository/supersimples/load-ocorrencia-super-simples.sql";
    private final NamedParameterJdbcTemplate namedParameterJdbcTemplate;

    public ConsultaSuperSimplesCNPJVarreduraAnualRepository(NamedParameterJdbcTemplate namedParameterJdbcTemplate) {
        this.namedParameterJdbcTemplate = namedParameterJdbcTemplate;
    }

    public List<SuperSimplesSolicitacaoCadastroDTO> loadCadastros(SuperSimplesSolicitacaoCnpj superSimplesSolicitacaoCnpj, Boolean isValidaTodosCadastros) {
        String sql = FileUtils.readResourceAsString((String)(Boolean.TRUE.equals(isValidaTodosCadastros) ? LOAD_CADASTROS : LOAD_CADASTROS_MOBILIARIO));
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("cnpj", (Object)superSimplesSolicitacaoCnpj.getCnpj(), 12);
        return this.namedParameterJdbcTemplate.query(sql, (SqlParameterSource)parameters, (RowMapper)new ElotechBeanPropertyRowMapper(SuperSimplesSolicitacaoCadastroDTO.class));
    }

    public String loadOcorrencia(Long entidade, Long tipoCadastro, Long cadastroGeral, LocalDate dataVencimento, Boolean isValidaTodosCadastros) {
        String sqlTemplate = FileUtils.readResourceAsString((String)LOAD_OCORRENCIA);
        String condition = Boolean.TRUE.equals(isValidaTodosCadastros) ? "" : "and guia.supersimples = 'S' ";
        String sql = String.format(sqlTemplate, condition);
        sql = String.format(this.getSelectOcorrenciaByDbType(), sql);
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("entidade", (Object)entidade);
        parameters.addValue("tipoCadastro", (Object)tipoCadastro);
        parameters.addValue("cadastroGeral", (Object)cadastroGeral);
        parameters.addValue("dataVencimento", (Object)dataVencimento);
        List ocorrencias = this.namedParameterJdbcTemplate.query(sql, (SqlParameterSource)parameters, (RowMapper)new ElotechBeanPropertyRowMapper(SuperSimplesSolicitacaoOcorrenciaDTO.class));
        return ocorrencias.stream().findFirst().map(SuperSimplesSolicitacaoOcorrenciaDTO::getOcorrencia).orElse("");
    }

    private String getSelectOcorrenciaByDbType() {
        if (DatabaseType.POSTGRES.equals((Object)this.getDatabaseType())) {
            return " SELECT string_agg(distinct resultado, ' - ') AS ocorrencia FROM (%s) resultado";
        }
        return " SELECT listagg(distinct resultado, ' - ') AS ocorrencia FROM (%s) resultado";
    }

    private DatabaseType getDatabaseType() {
        DatabaseType databaseType;
        try {
            databaseType = DatabaseType.fromMetaData((DataSource)Objects.requireNonNull(this.namedParameterJdbcTemplate.getJdbcTemplate().getDataSource()));
        }
        catch (MetaDataAccessException e) {
            throw new PaginationException("Erro ao extrair os metadados do banco", (Throwable)e);
        }
        if (!Arrays.asList(DatabaseType.ORACLE, DatabaseType.POSTGRES, DatabaseType.H2).contains(databaseType)) {
            throw new EloValidationException("Gera\u00e7\u00e3o do arquivo super simples n\u00e3o implementado para este tipo de banco de dados.");
        }
        return databaseType;
    }
}

