/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.repository;

import br.com.elotech.core.repository.support.CrudRepository;
import br.com.elotech.tributos.domain.DebitoParcela;
import br.com.elotech.tributos.domain.DebitoParcelaId;
import java.util.List;
import java.util.Optional;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

public interface DebitoParcelaRepository
extends CrudRepository<DebitoParcela, DebitoParcelaId> {
    @Query(value=" select dp from DebitoParcela dp  where dp.id.entidade = :entidade  and dp.id.exercicio = :exercicio  and dp.id.tipoCadastro = :tipoCadastro  and dp.id.cadastroGeral = :cadastroGeral  and dp.id.divida = :divida  and dp.id.subDivida = :subDivida  and dp.id.parcela = :parcela ")
    public Optional<DebitoParcela> findByDebitoParcela(@Param(value="entidade") Long var1, @Param(value="exercicio") Long var2, @Param(value="tipoCadastro") Long var3, @Param(value="cadastroGeral") Long var4, @Param(value="divida") Long var5, @Param(value="subDivida") Long var6, @Param(value="parcela") Long var7);

    public DebitoParcela findParcelasByDebitoIdAndIdParcela(Long var1, Long var2);

    public List<DebitoParcela> findParcelasByDebitoIdAndIdParcelaBetween(Long var1, Long var2, Long var3);

    @Query(value=" select dp from DebitoParcela dp  where dp.id.entidade = :entidade  and dp.id.exercicio = :exercicio  and dp.id.tipoCadastro = :tipoCadastro  and dp.id.cadastroGeral = :cadastroGeral  and dp.id.divida = :divida  and dp.id.subDivida = :subDivida  and dp.situacaoDebito.tipoSituacaoParcela = br.com.elotech.tributos.domain.TipoSituacaoParcela.ABERTO  order by dp.id.parcela ")
    public List<DebitoParcela> findByDebitoAndAberto(@Param(value="entidade") Long var1, @Param(value="exercicio") Long var2, @Param(value="tipoCadastro") Long var3, @Param(value="cadastroGeral") Long var4, @Param(value="divida") Long var5, @Param(value="subDivida") Long var6);

    @Query(value=" select dp FROM Parcelamento parcelamento inner join parcelamento.debitos debito inner join debito.parcelas dp WHERE dp.id.entidade = :entidade and dp.id.tipoCadastro = :tipoCadastro and dp.id.cadastroGeral = :cadastroGeral and dp.id.parcela in (:parcelas) and dp.situacaoDebito.tipoSituacaoParcela = br.com.elotech.tributos.domain.TipoSituacaoParcela.ABERTO and parcelamento.id in (:parcelamentos)")
    public List<DebitoParcela> findByCadastroParcelaAndAberto(@Param(value="entidade") Long var1, @Param(value="tipoCadastro") Long var2, @Param(value="cadastroGeral") Long var3, @Param(value="parcelas") List<Long> var4, @Param(value="parcelamentos") List<Long> var5);

    public List<DebitoParcela> findByIdIn(List<DebitoParcelaId> var1);

    public List<DebitoParcela> findByIdDebitoParcelaIn(List<Long> var1);

    @Query(value="select parcela                                                 from Documento                           peticao       inner join peticao.certidoesDividaAtivaPeticao cda           inner join cda.documentoItemDividaAtivas       itemCda       inner join itemCda.debito                      deb           inner join deb.parcelas                        parcela            where peticao.id = :idPeticao")
    public List<DebitoParcela> findByIdPeticao(@Param(value="idPeticao") Long var1);

    public List<DebitoParcela> findByIdProtesto(Long var1);
}

