/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.repository;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.tributos.dto.CarneRowDTO;
import br.com.elotech.tributos.dto.FiltroConsultaCarneDTO;
import br.com.elotech.tributos.util.SqlUtils;
import java.util.List;
import java.util.Optional;
import javax.sql.DataSource;
import lombok.Generated;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class ConsultaCarneRepository {
    private static final String CONSULTA_CARNE = "br/com/elotech/tributos/repository/find-carnes.sql";
    private final NamedParameterJdbcTemplate jdbcTemplate;

    public Page<CarneRowDTO> consultaCarne(FiltroConsultaCarneDTO dto, Pageable pageable) {
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("entidade", (Object)dto.getEntidade(), 2);
        String finalSort = SqlUtils.getFinalSort((Pageable)pageable);
        String sql = String.format(FileUtils.readResourceAsString((String)CONSULTA_CARNE), dto.buildFiltro());
        String sqlContagem = String.format("select count(*) as total from (%s) count_query", sql);
        Long numeroTotal = (Long)this.jdbcTemplate.queryForObject(sqlContagem, (SqlParameterSource)parameters, (rs, rowNum) -> rs.getLong("total"));
        String sqlComPaginacao = SqlUtils.withPagination((String)sql.concat(finalSort), (Pageable)pageable, (DataSource)this.jdbcTemplate.getJdbcTemplate().getDataSource());
        List pagedRows = this.jdbcTemplate.query(sqlComPaginacao, (SqlParameterSource)parameters, (RowMapper)new ElotechBeanPropertyRowMapper(CarneRowDTO.class));
        return new PageImpl(pagedRows, pageable, Optional.ofNullable(numeroTotal).orElse(0L).longValue());
    }

    @Generated
    public ConsultaCarneRepository(NamedParameterJdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }
}

