/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto.integracaoelogeo;

import br.com.elotech.tributos.domain.SituacaoSegmentoImob;
import br.com.elotech.tributos.domain.TipoCadastro;
import br.com.elotech.tributos.domain.TipoSegmento;
import br.com.elotech.tributos.domain.imobiliario.CadastroImobiliarioSegmento;
import br.com.elotech.tributos.dto.integracaoelogeo.BoletimElogeoDTO;
import br.com.elotech.tributos.dto.integracaoelogeo.CadastroImobiliarioSegmentoElogeoDTO;
import br.com.elotech.tributos.dto.integracaoelogeo.SituacaoSegmentoImobElogeoDTO;
import br.com.elotech.tributos.dto.integracaoelogeo.TipoSegmentoElogeoDTO;
import br.com.elotech.tributos.util.BooleanToStringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import lombok.Generated;

/*
 * Exception performing whole class analysis ignored.
 */
public class CadastroImobiliarioSegmentoElogeoDTO {
    private Long id;
    @NotNull
    private Long sequencia;
    private String principal;
    @NotNull
    private BigDecimal area;
    @NotNull
    @Valid
    private TipoSegmentoElogeoDTO tipo;
    @Valid
    private SituacaoSegmentoImobElogeoDTO situacao;
    @Valid
    private List<BoletimElogeoDTO> caracteristicas = new ArrayList();

    public static Builder builder() {
        return new Builder();
    }

    public static CadastroImobiliarioSegmentoElogeoDTO from(CadastroImobiliarioSegmento entity) {
        return CadastroImobiliarioSegmentoElogeoDTO.builder().id(entity.getId()).sequencia(entity.getSequencia()).principal(entity.getPrincipal().booleanValue()).area(entity.getAreaConstruida()).tipo(TipoSegmentoElogeoDTO.from((TipoSegmento)entity.getTipoSegmento())).situacao((SituacaoSegmentoImobElogeoDTO)Optional.ofNullable(entity).map(CadastroImobiliarioSegmento::getSituacaoSegmento).map(SituacaoSegmentoImobElogeoDTO::from).orElse(null)).build();
    }

    public CadastroImobiliarioSegmento toEntity(Long cadastroGeral, TipoSegmento tipoSegmento, SituacaoSegmentoImob situacaoSegmentoImob) {
        CadastroImobiliarioSegmento entity = new CadastroImobiliarioSegmento();
        entity.setId(this.getId());
        entity.setTipoCadastro(TipoCadastro.IMOBILIARIO);
        entity.setCadastroGeral(cadastroGeral);
        entity.setSequencia(this.getSequencia());
        Optional.ofNullable(this.getPrincipal()).ifPresent(principal -> entity.setPrincipal(BooleanToStringUtils.getStringAsBoolean((String)principal)));
        entity.setAreaConstruida(this.getArea());
        entity.setTipoSegmento(tipoSegmento);
        entity.setIdTipoSegmento(tipoSegmento.getId());
        entity.setSituacaoSegmento(situacaoSegmentoImob);
        return entity;
    }

    public CadastroImobiliarioSegmento toEntity(Long cadastroGeral, TipoSegmento tipoSegmento) {
        CadastroImobiliarioSegmento entity = new CadastroImobiliarioSegmento();
        entity.setId(this.getId());
        entity.setTipoCadastro(TipoCadastro.IMOBILIARIO);
        entity.setCadastroGeral(cadastroGeral);
        entity.setSequencia(this.getSequencia());
        Optional.ofNullable(this.getPrincipal()).ifPresent(principal -> entity.setPrincipal(BooleanToStringUtils.getStringAsBoolean((String)principal)));
        entity.setAreaConstruida(this.getArea());
        entity.setTipoSegmento(tipoSegmento);
        entity.setIdTipoSegmento(tipoSegmento.getId());
        return entity;
    }

    @Generated
    public CadastroImobiliarioSegmentoElogeoDTO() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public Long getSequencia() {
        return this.sequencia;
    }

    @Generated
    public String getPrincipal() {
        return this.principal;
    }

    @Generated
    public BigDecimal getArea() {
        return this.area;
    }

    @Generated
    public TipoSegmentoElogeoDTO getTipo() {
        return this.tipo;
    }

    @Generated
    public SituacaoSegmentoImobElogeoDTO getSituacao() {
        return this.situacao;
    }

    @Generated
    public List<BoletimElogeoDTO> getCaracteristicas() {
        return this.caracteristicas;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setSequencia(Long sequencia) {
        this.sequencia = sequencia;
    }

    @Generated
    public void setPrincipal(String principal) {
        this.principal = principal;
    }

    @Generated
    public void setArea(BigDecimal area) {
        this.area = area;
    }

    @Generated
    public void setTipo(TipoSegmentoElogeoDTO tipo) {
        this.tipo = tipo;
    }

    @Generated
    public void setSituacao(SituacaoSegmentoImobElogeoDTO situacao) {
        this.situacao = situacao;
    }

    @Generated
    public void setCaracteristicas(List<BoletimElogeoDTO> caracteristicas) {
        this.caracteristicas = caracteristicas;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CadastroImobiliarioSegmentoElogeoDTO)) {
            return false;
        }
        CadastroImobiliarioSegmentoElogeoDTO other = (CadastroImobiliarioSegmentoElogeoDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Long this$sequencia = this.getSequencia();
        Long other$sequencia = other.getSequencia();
        if (this$sequencia == null ? other$sequencia != null : !((Object)this$sequencia).equals(other$sequencia)) {
            return false;
        }
        String this$principal = this.getPrincipal();
        String other$principal = other.getPrincipal();
        if (this$principal == null ? other$principal != null : !this$principal.equals(other$principal)) {
            return false;
        }
        BigDecimal this$area = this.getArea();
        BigDecimal other$area = other.getArea();
        if (this$area == null ? other$area != null : !((Object)this$area).equals(other$area)) {
            return false;
        }
        TipoSegmentoElogeoDTO this$tipo = this.getTipo();
        TipoSegmentoElogeoDTO other$tipo = other.getTipo();
        if (this$tipo == null ? other$tipo != null : !this$tipo.equals(other$tipo)) {
            return false;
        }
        SituacaoSegmentoImobElogeoDTO this$situacao = this.getSituacao();
        SituacaoSegmentoImobElogeoDTO other$situacao = other.getSituacao();
        if (this$situacao == null ? other$situacao != null : !this$situacao.equals(other$situacao)) {
            return false;
        }
        List this$caracteristicas = this.getCaracteristicas();
        List other$caracteristicas = other.getCaracteristicas();
        return !(this$caracteristicas == null ? other$caracteristicas != null : !((Object)this$caracteristicas).equals(other$caracteristicas));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CadastroImobiliarioSegmentoElogeoDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Long $sequencia = this.getSequencia();
        result = result * 59 + ($sequencia == null ? 43 : ((Object)$sequencia).hashCode());
        String $principal = this.getPrincipal();
        result = result * 59 + ($principal == null ? 43 : $principal.hashCode());
        BigDecimal $area = this.getArea();
        result = result * 59 + ($area == null ? 43 : ((Object)$area).hashCode());
        TipoSegmentoElogeoDTO $tipo = this.getTipo();
        result = result * 59 + ($tipo == null ? 43 : $tipo.hashCode());
        SituacaoSegmentoImobElogeoDTO $situacao = this.getSituacao();
        result = result * 59 + ($situacao == null ? 43 : $situacao.hashCode());
        List $caracteristicas = this.getCaracteristicas();
        result = result * 59 + ($caracteristicas == null ? 43 : ((Object)$caracteristicas).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "CadastroImobiliarioSegmentoElogeoDTO(id=" + this.getId() + ", sequencia=" + this.getSequencia() + ", principal=" + this.getPrincipal() + ", area=" + this.getArea() + ", tipo=" + this.getTipo() + ", situacao=" + this.getSituacao() + ", caracteristicas=" + this.getCaracteristicas() + ")";
    }
}

