/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto.integracaocontabil;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.ContaBancaria;
import br.com.elotech.tributos.domain.Convenio;
import br.com.elotech.tributos.domain.pagamento.TipoPagamentoLote;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import java.util.Optional;
import javax.validation.constraints.NotNull;
import lombok.Generated;

public class FiltroArrecadacaoPorLoteDTO {
    @NotNull(message="\u00c9 obrigat\u00f3rio o preenchimento da Data In\u00edcio.")
    private @NotNull(message="\u00c9 obrigat\u00f3rio o preenchimento da Data In\u00edcio.") LocalDate dataInicio;
    @NotNull(message="\u00c9 obrigat\u00f3rio o preenchimento da Data Fim.")
    private @NotNull(message="\u00c9 obrigat\u00f3rio o preenchimento da Data Fim.") LocalDate dataFim;
    private ContaBancaria contaBancaria;
    private Long exercicio;
    private Long lote;
    private Convenio convenio;
    private TipoPagamentoLote tipoLote;

    public String getSearch() {
        Object search = "dataInicio: " + this.dataInicio.format(DateTimeFormatter.ofPattern("dd/MM/yyyy")) + " dataFim: " + this.dataFim.format(DateTimeFormatter.ofPattern("dd/MM/yyyy")) + " contaBancaria: " + (String)Optional.ofNullable(this.contaBancaria).map(ContaBancaria::getDescricao).orElse(null) + " lote: " + this.lote + " convenio: " + (String)Optional.ofNullable(this.convenio).map(Convenio::getDescricao).orElse(null) + " Ano: " + this.exercicio;
        search = ((String)search).replace("null", "");
        return search;
    }

    public String buildFiltro() {
        StringBuilder filtro = new StringBuilder();
        if (Objects.nonNull(this.contaBancaria)) {
            filtro.append(String.format(" and contabancaria.id = %d", this.contaBancaria.getId()));
        }
        if (Objects.nonNull(this.convenio)) {
            filtro.append(String.format(" and convenio.id = %d", this.convenio.getId()));
        }
        if (Objects.nonNull(this.exercicio)) {
            filtro.append(String.format(" and lote.exercicio = %d", this.exercicio));
        }
        if (Objects.nonNull(this.lote)) {
            filtro.append(String.format(" and lote.lote = %d", this.lote));
        }
        if (Objects.nonNull(this.tipoLote)) {
            if (TipoPagamentoLote.SANEPAR.equals((Object)this.tipoLote)) {
                filtro.append(" and sanepar.idbaixa is not null");
            } else {
                filtro.append(String.format(" and lote.tipo = '%s'", this.tipoLote.getValue()));
            }
        }
        return filtro.toString();
    }

    public void validaDatas() {
        if (this.dataInicio.isAfter(this.dataFim)) {
            throw new EloValidationException("Intervalo de datas inv\u00e1lido, favor corrija para prosseguir.");
        }
    }

    public String getTipoLoteValue() {
        return Optional.ofNullable(this.tipoLote).map(TipoPagamentoLote::getValue).orElse(null);
    }

    @Generated
    public FiltroArrecadacaoPorLoteDTO() {
    }

    @Generated
    public LocalDate getDataInicio() {
        return this.dataInicio;
    }

    @Generated
    public LocalDate getDataFim() {
        return this.dataFim;
    }

    @Generated
    public ContaBancaria getContaBancaria() {
        return this.contaBancaria;
    }

    @Generated
    public Long getExercicio() {
        return this.exercicio;
    }

    @Generated
    public Long getLote() {
        return this.lote;
    }

    @Generated
    public Convenio getConvenio() {
        return this.convenio;
    }

    @Generated
    public TipoPagamentoLote getTipoLote() {
        return this.tipoLote;
    }

    @Generated
    public void setDataInicio(LocalDate dataInicio) {
        this.dataInicio = dataInicio;
    }

    @Generated
    public void setDataFim(LocalDate dataFim) {
        this.dataFim = dataFim;
    }

    @Generated
    public void setContaBancaria(ContaBancaria contaBancaria) {
        this.contaBancaria = contaBancaria;
    }

    @Generated
    public void setExercicio(Long exercicio) {
        this.exercicio = exercicio;
    }

    @Generated
    public void setLote(Long lote) {
        this.lote = lote;
    }

    @Generated
    public void setConvenio(Convenio convenio) {
        this.convenio = convenio;
    }

    @Generated
    public void setTipoLote(TipoPagamentoLote tipoLote) {
        this.tipoLote = tipoLote;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FiltroArrecadacaoPorLoteDTO)) {
            return false;
        }
        FiltroArrecadacaoPorLoteDTO other = (FiltroArrecadacaoPorLoteDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$exercicio = this.getExercicio();
        Long other$exercicio = other.getExercicio();
        if (this$exercicio == null ? other$exercicio != null : !((Object)this$exercicio).equals(other$exercicio)) {
            return false;
        }
        Long this$lote = this.getLote();
        Long other$lote = other.getLote();
        if (this$lote == null ? other$lote != null : !((Object)this$lote).equals(other$lote)) {
            return false;
        }
        LocalDate this$dataInicio = this.getDataInicio();
        LocalDate other$dataInicio = other.getDataInicio();
        if (this$dataInicio == null ? other$dataInicio != null : !((Object)this$dataInicio).equals(other$dataInicio)) {
            return false;
        }
        LocalDate this$dataFim = this.getDataFim();
        LocalDate other$dataFim = other.getDataFim();
        if (this$dataFim == null ? other$dataFim != null : !((Object)this$dataFim).equals(other$dataFim)) {
            return false;
        }
        ContaBancaria this$contaBancaria = this.getContaBancaria();
        ContaBancaria other$contaBancaria = other.getContaBancaria();
        if (this$contaBancaria == null ? other$contaBancaria != null : !this$contaBancaria.equals(other$contaBancaria)) {
            return false;
        }
        Convenio this$convenio = this.getConvenio();
        Convenio other$convenio = other.getConvenio();
        if (this$convenio == null ? other$convenio != null : !this$convenio.equals(other$convenio)) {
            return false;
        }
        TipoPagamentoLote this$tipoLote = this.getTipoLote();
        TipoPagamentoLote other$tipoLote = other.getTipoLote();
        return !(this$tipoLote == null ? other$tipoLote != null : !this$tipoLote.equals(other$tipoLote));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof FiltroArrecadacaoPorLoteDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $exercicio = this.getExercicio();
        result = result * 59 + ($exercicio == null ? 43 : ((Object)$exercicio).hashCode());
        Long $lote = this.getLote();
        result = result * 59 + ($lote == null ? 43 : ((Object)$lote).hashCode());
        LocalDate $dataInicio = this.getDataInicio();
        result = result * 59 + ($dataInicio == null ? 43 : ((Object)$dataInicio).hashCode());
        LocalDate $dataFim = this.getDataFim();
        result = result * 59 + ($dataFim == null ? 43 : ((Object)$dataFim).hashCode());
        ContaBancaria $contaBancaria = this.getContaBancaria();
        result = result * 59 + ($contaBancaria == null ? 43 : $contaBancaria.hashCode());
        Convenio $convenio = this.getConvenio();
        result = result * 59 + ($convenio == null ? 43 : $convenio.hashCode());
        TipoPagamentoLote $tipoLote = this.getTipoLote();
        result = result * 59 + ($tipoLote == null ? 43 : $tipoLote.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "FiltroArrecadacaoPorLoteDTO(dataInicio=" + this.getDataInicio() + ", dataFim=" + this.getDataFim() + ", contaBancaria=" + this.getContaBancaria() + ", exercicio=" + this.getExercicio() + ", lote=" + this.getLote() + ", convenio=" + this.getConvenio() + ", tipoLote=" + this.getTipoLote() + ")";
    }
}

