/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto.contencioso;

import br.com.elotech.tributos.domain.Ato;
import br.com.elotech.tributos.domain.CadastroGeral;
import br.com.elotech.tributos.domain.Contencioso;
import br.com.elotech.tributos.domain.ContenciosoAto;
import br.com.elotech.tributos.domain.ContenciosoDebito;
import br.com.elotech.tributos.domain.ContenciosoSituacaoEnum;
import br.com.elotech.tributos.domain.MotivoDeducao;
import br.com.elotech.tributos.domain.SituacaoContenciosoDebito;
import br.com.elotech.tributos.domain.TipoContencioso;
import br.com.elotech.tributos.domain.contencioso.Parecerista;
import br.com.elotech.tributos.dto.contencioso.ContenciosoProcessoProtocoloDTO;
import br.com.elotech.tributos.dto.contencioso.TipoContenciosoResponseDTO;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;

public class ContenciosoDebitosResponseDTO
implements Serializable {
    private Long id;
    private Long contenciosoId;
    private Long entidade;
    private Long exercicio;
    private LocalDate data;
    private Long instancia;
    private CadastroGeral cadastroGeral;
    private String situacao;
    private String situacaoDetalhada;
    private Parecerista parecerista;
    private String observacao;
    private String situacaoContencioso;
    private ContenciosoProcessoProtocoloDTO processo;
    private List<ContenciosoDebito> debitos;
    private TipoContenciosoResponseDTO tipoContencioso;
    private String usuario;
    private SituacaoContenciosoDebito parecer;
    private LocalDate dataCancelamento;
    private MotivoDeducao motivoDeducao;
    private List<Ato> contenciosoAtos = new ArrayList();

    public static ContenciosoDebitosResponseDTO of(Contencioso contencioso) {
        ContenciosoDebitosResponseDTO dto = new ContenciosoDebitosResponseDTO();
        dto.setId(contencioso.getId());
        dto.setContenciosoId(contencioso.getContenciosoId());
        dto.setEntidade(contencioso.getEntidade());
        dto.setExercicio(contencioso.getExercicio());
        dto.setInstancia(contencioso.getInstancia());
        dto.setObservacao(contencioso.getObservacao());
        dto.setTipoContencioso(TipoContenciosoResponseDTO.of((TipoContencioso)contencioso.getTipoContencioso()));
        dto.setParecerista(contencioso.getParecerista());
        dto.setCadastroGeral(contencioso.getCadastroGeral());
        Optional.ofNullable(contencioso.getSituacao()).ifPresent(situacao -> dto.setSituacao(situacao.getValue()));
        Optional.ofNullable(contencioso.getSituacaoContencioso()).ifPresent(situacaoContencioso -> dto.setSituacaoContencioso(situacaoContencioso.getValue()));
        dto.setDebitos(contencioso.getDebitos());
        dto.setContenciosoAtos(contencioso.getContenciosoAtos().stream().map(ContenciosoAto::getFundamentoLegal).collect(Collectors.toList()));
        return dto;
    }

    public String getSituacaoDetalhada() {
        return Optional.ofNullable(ContenciosoSituacaoEnum.fromValue((String)this.situacao)).map(ContenciosoSituacaoEnum::getDescricao).orElse("");
    }

    @Generated
    public ContenciosoDebitosResponseDTO() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public Long getContenciosoId() {
        return this.contenciosoId;
    }

    @Generated
    public Long getEntidade() {
        return this.entidade;
    }

    @Generated
    public Long getExercicio() {
        return this.exercicio;
    }

    @Generated
    public LocalDate getData() {
        return this.data;
    }

    @Generated
    public Long getInstancia() {
        return this.instancia;
    }

    @Generated
    public CadastroGeral getCadastroGeral() {
        return this.cadastroGeral;
    }

    @Generated
    public String getSituacao() {
        return this.situacao;
    }

    @Generated
    public Parecerista getParecerista() {
        return this.parecerista;
    }

    @Generated
    public String getObservacao() {
        return this.observacao;
    }

    @Generated
    public String getSituacaoContencioso() {
        return this.situacaoContencioso;
    }

    @Generated
    public ContenciosoProcessoProtocoloDTO getProcesso() {
        return this.processo;
    }

    @Generated
    public List<ContenciosoDebito> getDebitos() {
        return this.debitos;
    }

    @Generated
    public TipoContenciosoResponseDTO getTipoContencioso() {
        return this.tipoContencioso;
    }

    @Generated
    public String getUsuario() {
        return this.usuario;
    }

    @Generated
    public SituacaoContenciosoDebito getParecer() {
        return this.parecer;
    }

    @Generated
    public LocalDate getDataCancelamento() {
        return this.dataCancelamento;
    }

    @Generated
    public MotivoDeducao getMotivoDeducao() {
        return this.motivoDeducao;
    }

    @Generated
    public List<Ato> getContenciosoAtos() {
        return this.contenciosoAtos;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setContenciosoId(Long contenciosoId) {
        this.contenciosoId = contenciosoId;
    }

    @Generated
    public void setEntidade(Long entidade) {
        this.entidade = entidade;
    }

    @Generated
    public void setExercicio(Long exercicio) {
        this.exercicio = exercicio;
    }

    @Generated
    public void setData(LocalDate data) {
        this.data = data;
    }

    @Generated
    public void setInstancia(Long instancia) {
        this.instancia = instancia;
    }

    @Generated
    public void setCadastroGeral(CadastroGeral cadastroGeral) {
        this.cadastroGeral = cadastroGeral;
    }

    @Generated
    public void setSituacao(String situacao) {
        this.situacao = situacao;
    }

    @Generated
    public void setSituacaoDetalhada(String situacaoDetalhada) {
        this.situacaoDetalhada = situacaoDetalhada;
    }

    @Generated
    public void setParecerista(Parecerista parecerista) {
        this.parecerista = parecerista;
    }

    @Generated
    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    @Generated
    public void setSituacaoContencioso(String situacaoContencioso) {
        this.situacaoContencioso = situacaoContencioso;
    }

    @Generated
    public void setProcesso(ContenciosoProcessoProtocoloDTO processo) {
        this.processo = processo;
    }

    @Generated
    public void setDebitos(List<ContenciosoDebito> debitos) {
        this.debitos = debitos;
    }

    @Generated
    public void setTipoContencioso(TipoContenciosoResponseDTO tipoContencioso) {
        this.tipoContencioso = tipoContencioso;
    }

    @Generated
    public void setUsuario(String usuario) {
        this.usuario = usuario;
    }

    @Generated
    public void setParecer(SituacaoContenciosoDebito parecer) {
        this.parecer = parecer;
    }

    @Generated
    public void setDataCancelamento(LocalDate dataCancelamento) {
        this.dataCancelamento = dataCancelamento;
    }

    @Generated
    public void setMotivoDeducao(MotivoDeducao motivoDeducao) {
        this.motivoDeducao = motivoDeducao;
    }

    @Generated
    public void setContenciosoAtos(List<Ato> contenciosoAtos) {
        this.contenciosoAtos = contenciosoAtos;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ContenciosoDebitosResponseDTO)) {
            return false;
        }
        ContenciosoDebitosResponseDTO other = (ContenciosoDebitosResponseDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Long this$contenciosoId = this.getContenciosoId();
        Long other$contenciosoId = other.getContenciosoId();
        if (this$contenciosoId == null ? other$contenciosoId != null : !((Object)this$contenciosoId).equals(other$contenciosoId)) {
            return false;
        }
        Long this$entidade = this.getEntidade();
        Long other$entidade = other.getEntidade();
        if (this$entidade == null ? other$entidade != null : !((Object)this$entidade).equals(other$entidade)) {
            return false;
        }
        Long this$exercicio = this.getExercicio();
        Long other$exercicio = other.getExercicio();
        if (this$exercicio == null ? other$exercicio != null : !((Object)this$exercicio).equals(other$exercicio)) {
            return false;
        }
        Long this$instancia = this.getInstancia();
        Long other$instancia = other.getInstancia();
        if (this$instancia == null ? other$instancia != null : !((Object)this$instancia).equals(other$instancia)) {
            return false;
        }
        LocalDate this$data = this.getData();
        LocalDate other$data = other.getData();
        if (this$data == null ? other$data != null : !((Object)this$data).equals(other$data)) {
            return false;
        }
        CadastroGeral this$cadastroGeral = this.getCadastroGeral();
        CadastroGeral other$cadastroGeral = other.getCadastroGeral();
        if (this$cadastroGeral == null ? other$cadastroGeral != null : !this$cadastroGeral.equals(other$cadastroGeral)) {
            return false;
        }
        String this$situacao = this.getSituacao();
        String other$situacao = other.getSituacao();
        if (this$situacao == null ? other$situacao != null : !this$situacao.equals(other$situacao)) {
            return false;
        }
        String this$situacaoDetalhada = this.getSituacaoDetalhada();
        String other$situacaoDetalhada = other.getSituacaoDetalhada();
        if (this$situacaoDetalhada == null ? other$situacaoDetalhada != null : !this$situacaoDetalhada.equals(other$situacaoDetalhada)) {
            return false;
        }
        Parecerista this$parecerista = this.getParecerista();
        Parecerista other$parecerista = other.getParecerista();
        if (this$parecerista == null ? other$parecerista != null : !this$parecerista.equals(other$parecerista)) {
            return false;
        }
        String this$observacao = this.getObservacao();
        String other$observacao = other.getObservacao();
        if (this$observacao == null ? other$observacao != null : !this$observacao.equals(other$observacao)) {
            return false;
        }
        String this$situacaoContencioso = this.getSituacaoContencioso();
        String other$situacaoContencioso = other.getSituacaoContencioso();
        if (this$situacaoContencioso == null ? other$situacaoContencioso != null : !this$situacaoContencioso.equals(other$situacaoContencioso)) {
            return false;
        }
        ContenciosoProcessoProtocoloDTO this$processo = this.getProcesso();
        ContenciosoProcessoProtocoloDTO other$processo = other.getProcesso();
        if (this$processo == null ? other$processo != null : !this$processo.equals(other$processo)) {
            return false;
        }
        List this$debitos = this.getDebitos();
        List other$debitos = other.getDebitos();
        if (this$debitos == null ? other$debitos != null : !((Object)this$debitos).equals(other$debitos)) {
            return false;
        }
        TipoContenciosoResponseDTO this$tipoContencioso = this.getTipoContencioso();
        TipoContenciosoResponseDTO other$tipoContencioso = other.getTipoContencioso();
        if (this$tipoContencioso == null ? other$tipoContencioso != null : !this$tipoContencioso.equals(other$tipoContencioso)) {
            return false;
        }
        String this$usuario = this.getUsuario();
        String other$usuario = other.getUsuario();
        if (this$usuario == null ? other$usuario != null : !this$usuario.equals(other$usuario)) {
            return false;
        }
        SituacaoContenciosoDebito this$parecer = this.getParecer();
        SituacaoContenciosoDebito other$parecer = other.getParecer();
        if (this$parecer == null ? other$parecer != null : !this$parecer.equals(other$parecer)) {
            return false;
        }
        LocalDate this$dataCancelamento = this.getDataCancelamento();
        LocalDate other$dataCancelamento = other.getDataCancelamento();
        if (this$dataCancelamento == null ? other$dataCancelamento != null : !((Object)this$dataCancelamento).equals(other$dataCancelamento)) {
            return false;
        }
        MotivoDeducao this$motivoDeducao = this.getMotivoDeducao();
        MotivoDeducao other$motivoDeducao = other.getMotivoDeducao();
        if (this$motivoDeducao == null ? other$motivoDeducao != null : !this$motivoDeducao.equals(other$motivoDeducao)) {
            return false;
        }
        List this$contenciosoAtos = this.getContenciosoAtos();
        List other$contenciosoAtos = other.getContenciosoAtos();
        return !(this$contenciosoAtos == null ? other$contenciosoAtos != null : !((Object)this$contenciosoAtos).equals(other$contenciosoAtos));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ContenciosoDebitosResponseDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Long $contenciosoId = this.getContenciosoId();
        result = result * 59 + ($contenciosoId == null ? 43 : ((Object)$contenciosoId).hashCode());
        Long $entidade = this.getEntidade();
        result = result * 59 + ($entidade == null ? 43 : ((Object)$entidade).hashCode());
        Long $exercicio = this.getExercicio();
        result = result * 59 + ($exercicio == null ? 43 : ((Object)$exercicio).hashCode());
        Long $instancia = this.getInstancia();
        result = result * 59 + ($instancia == null ? 43 : ((Object)$instancia).hashCode());
        LocalDate $data = this.getData();
        result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
        CadastroGeral $cadastroGeral = this.getCadastroGeral();
        result = result * 59 + ($cadastroGeral == null ? 43 : $cadastroGeral.hashCode());
        String $situacao = this.getSituacao();
        result = result * 59 + ($situacao == null ? 43 : $situacao.hashCode());
        String $situacaoDetalhada = this.getSituacaoDetalhada();
        result = result * 59 + ($situacaoDetalhada == null ? 43 : $situacaoDetalhada.hashCode());
        Parecerista $parecerista = this.getParecerista();
        result = result * 59 + ($parecerista == null ? 43 : $parecerista.hashCode());
        String $observacao = this.getObservacao();
        result = result * 59 + ($observacao == null ? 43 : $observacao.hashCode());
        String $situacaoContencioso = this.getSituacaoContencioso();
        result = result * 59 + ($situacaoContencioso == null ? 43 : $situacaoContencioso.hashCode());
        ContenciosoProcessoProtocoloDTO $processo = this.getProcesso();
        result = result * 59 + ($processo == null ? 43 : $processo.hashCode());
        List $debitos = this.getDebitos();
        result = result * 59 + ($debitos == null ? 43 : ((Object)$debitos).hashCode());
        TipoContenciosoResponseDTO $tipoContencioso = this.getTipoContencioso();
        result = result * 59 + ($tipoContencioso == null ? 43 : $tipoContencioso.hashCode());
        String $usuario = this.getUsuario();
        result = result * 59 + ($usuario == null ? 43 : $usuario.hashCode());
        SituacaoContenciosoDebito $parecer = this.getParecer();
        result = result * 59 + ($parecer == null ? 43 : $parecer.hashCode());
        LocalDate $dataCancelamento = this.getDataCancelamento();
        result = result * 59 + ($dataCancelamento == null ? 43 : ((Object)$dataCancelamento).hashCode());
        MotivoDeducao $motivoDeducao = this.getMotivoDeducao();
        result = result * 59 + ($motivoDeducao == null ? 43 : $motivoDeducao.hashCode());
        List $contenciosoAtos = this.getContenciosoAtos();
        result = result * 59 + ($contenciosoAtos == null ? 43 : ((Object)$contenciosoAtos).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ContenciosoDebitosResponseDTO(id=" + this.getId() + ", contenciosoId=" + this.getContenciosoId() + ", entidade=" + this.getEntidade() + ", exercicio=" + this.getExercicio() + ", data=" + this.getData() + ", instancia=" + this.getInstancia() + ", cadastroGeral=" + this.getCadastroGeral() + ", situacao=" + this.getSituacao() + ", situacaoDetalhada=" + this.getSituacaoDetalhada() + ", parecerista=" + this.getParecerista() + ", observacao=" + this.getObservacao() + ", situacaoContencioso=" + this.getSituacaoContencioso() + ", processo=" + this.getProcesso() + ", debitos=" + this.getDebitos() + ", tipoContencioso=" + this.getTipoContencioso() + ", usuario=" + this.getUsuario() + ", parecer=" + this.getParecer() + ", dataCancelamento=" + this.getDataCancelamento() + ", motivoDeducao=" + this.getMotivoDeducao() + ", contenciosoAtos=" + this.getContenciosoAtos() + ")";
    }
}

