/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto.boleto;

import br.com.elotech.tributos.domain.TipoCadastro;
import br.com.elotech.tributos.domain.protocolo.Processo;
import br.com.elotech.tributos.dto.CadastroGeralResumidoDTO;
import br.com.elotech.tributos.dto.DebitoEmAbertoDTO;
import br.com.elotech.tributos.dto.boleto.BoletoEspecialDebitoDTO;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.hibernate.validator.constraints.Length;

public class BoletoEspecialDTO {
    private Processo processo;
    @NotNull
    private LocalDate dataVencimento;
    @NotNull
    private Long motivoDeducao;
    @NotNull
    @Length(max=4000)
    private @NotNull @Length(max=4000) String observacao;
    private Long codigoModeloBloquetoSemRegistro = 0L;
    List<BoletoEspecialDebitoDTO> debitos = new ArrayList();

    public static BoletoEspecialDTO from(List<DebitoEmAbertoDTO> debitos) {
        BoletoEspecialDTO boletoEspecialDTO = new BoletoEspecialDTO();
        boletoEspecialDTO.debitos = debitos.stream().map(BoletoEspecialDebitoDTO::from).collect(Collectors.toList());
        return boletoEspecialDTO;
    }

    public BigDecimal getTotalPrincipal() {
        return this.debitos.stream().map(BoletoEspecialDebitoDTO::getValorPrincipal).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    public BigDecimal getTotalJuros() {
        return this.debitos.stream().map(BoletoEspecialDebitoDTO::getValorJuros).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    public BigDecimal getTotalMulta() {
        return this.debitos.stream().map(BoletoEspecialDebitoDTO::getValorMulta).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    public BigDecimal getTotalCorrecao() {
        return this.debitos.stream().map(BoletoEspecialDebitoDTO::getValorCorrecao).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    public BigDecimal getTotalDesconto() {
        return this.debitos.stream().map(BoletoEspecialDebitoDTO::getValorDescontos).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    public BigDecimal getValorTotal() {
        return this.debitos.stream().map(BoletoEspecialDebitoDTO::getValorTotal).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    @JsonIgnore
    public CadastroGeralResumidoDTO getCadastroGeral() {
        if (this.debitos.isEmpty()) {
            return null;
        }
        BoletoEspecialDebitoDTO firstDebito = (BoletoEspecialDebitoDTO)this.debitos.get(0);
        return CadastroGeralResumidoDTO.from((TipoCadastro)firstDebito.getTipoCadastro(), (Long)firstDebito.getCadastroGeral());
    }

    public Boolean hasDebitoWithCadastroDiferente() {
        if (Objects.isNull(this.debitos) || this.debitos.size() < 2) {
            return Boolean.FALSE;
        }
        BoletoEspecialDebitoDTO firstDebito = (BoletoEspecialDebitoDTO)this.debitos.get(0);
        return this.debitos.stream().anyMatch(boletoEspecialDebitoDTO -> firstDebito.sameCadastroGeral(boletoEspecialDebitoDTO) == false);
    }

    @Generated
    public BoletoEspecialDTO() {
    }

    @Generated
    public Processo getProcesso() {
        return this.processo;
    }

    @Generated
    public LocalDate getDataVencimento() {
        return this.dataVencimento;
    }

    @Generated
    public Long getMotivoDeducao() {
        return this.motivoDeducao;
    }

    @Generated
    public String getObservacao() {
        return this.observacao;
    }

    @Generated
    public Long getCodigoModeloBloquetoSemRegistro() {
        return this.codigoModeloBloquetoSemRegistro;
    }

    @Generated
    public List<BoletoEspecialDebitoDTO> getDebitos() {
        return this.debitos;
    }

    @Generated
    public void setProcesso(Processo processo) {
        this.processo = processo;
    }

    @Generated
    public void setDataVencimento(LocalDate dataVencimento) {
        this.dataVencimento = dataVencimento;
    }

    @Generated
    public void setMotivoDeducao(Long motivoDeducao) {
        this.motivoDeducao = motivoDeducao;
    }

    @Generated
    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    @Generated
    public void setCodigoModeloBloquetoSemRegistro(Long codigoModeloBloquetoSemRegistro) {
        this.codigoModeloBloquetoSemRegistro = codigoModeloBloquetoSemRegistro;
    }

    @Generated
    public void setDebitos(List<BoletoEspecialDebitoDTO> debitos) {
        this.debitos = debitos;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BoletoEspecialDTO)) {
            return false;
        }
        BoletoEspecialDTO other = (BoletoEspecialDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$motivoDeducao = this.getMotivoDeducao();
        Long other$motivoDeducao = other.getMotivoDeducao();
        if (this$motivoDeducao == null ? other$motivoDeducao != null : !((Object)this$motivoDeducao).equals(other$motivoDeducao)) {
            return false;
        }
        Long this$codigoModeloBloquetoSemRegistro = this.getCodigoModeloBloquetoSemRegistro();
        Long other$codigoModeloBloquetoSemRegistro = other.getCodigoModeloBloquetoSemRegistro();
        if (this$codigoModeloBloquetoSemRegistro == null ? other$codigoModeloBloquetoSemRegistro != null : !((Object)this$codigoModeloBloquetoSemRegistro).equals(other$codigoModeloBloquetoSemRegistro)) {
            return false;
        }
        Processo this$processo = this.getProcesso();
        Processo other$processo = other.getProcesso();
        if (this$processo == null ? other$processo != null : !this$processo.equals(other$processo)) {
            return false;
        }
        LocalDate this$dataVencimento = this.getDataVencimento();
        LocalDate other$dataVencimento = other.getDataVencimento();
        if (this$dataVencimento == null ? other$dataVencimento != null : !((Object)this$dataVencimento).equals(other$dataVencimento)) {
            return false;
        }
        String this$observacao = this.getObservacao();
        String other$observacao = other.getObservacao();
        if (this$observacao == null ? other$observacao != null : !this$observacao.equals(other$observacao)) {
            return false;
        }
        List this$debitos = this.getDebitos();
        List other$debitos = other.getDebitos();
        return !(this$debitos == null ? other$debitos != null : !((Object)this$debitos).equals(other$debitos));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof BoletoEspecialDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $motivoDeducao = this.getMotivoDeducao();
        result = result * 59 + ($motivoDeducao == null ? 43 : ((Object)$motivoDeducao).hashCode());
        Long $codigoModeloBloquetoSemRegistro = this.getCodigoModeloBloquetoSemRegistro();
        result = result * 59 + ($codigoModeloBloquetoSemRegistro == null ? 43 : ((Object)$codigoModeloBloquetoSemRegistro).hashCode());
        Processo $processo = this.getProcesso();
        result = result * 59 + ($processo == null ? 43 : $processo.hashCode());
        LocalDate $dataVencimento = this.getDataVencimento();
        result = result * 59 + ($dataVencimento == null ? 43 : ((Object)$dataVencimento).hashCode());
        String $observacao = this.getObservacao();
        result = result * 59 + ($observacao == null ? 43 : $observacao.hashCode());
        List $debitos = this.getDebitos();
        result = result * 59 + ($debitos == null ? 43 : ((Object)$debitos).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "BoletoEspecialDTO(processo=" + this.getProcesso() + ", dataVencimento=" + this.getDataVencimento() + ", motivoDeducao=" + this.getMotivoDeducao() + ", observacao=" + this.getObservacao() + ", codigoModeloBloquetoSemRegistro=" + this.getCodigoModeloBloquetoSemRegistro() + ", debitos=" + this.getDebitos() + ")";
    }
}

