/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain.calculo;

import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.tributos.calculo.dto.CalculoBuildDTO;
import br.com.elotech.tributos.calculo.dto.CalculoResultadoDTO;
import br.com.elotech.tributos.calculo.dto.InconsistenciaCalculoDTO;
import br.com.elotech.tributos.domain.Divida;
import br.com.elotech.tributos.domain.TipoCadastro;
import br.com.elotech.tributos.domain.TipoDivida;
import br.com.elotech.tributos.domain.Tributo;
import br.com.elotech.tributos.domain.calculo.CalculoConfigBase;
import br.com.elotech.tributos.domain.calculo.CalculoTributoScript;
import br.com.elotech.tributos.domain.calculo.TipoCalculoConfig;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.validation.constraints.NotNull;
import lombok.Generated;

@Table(name="calculotributo")
@Entity
public class CalculoTributo
implements EloEntity<Long>,
Serializable,
CalculoConfigBase {
    @Id
    @EloSequence(sequenceName="SEQ_CALCULOTRIBUTO")
    private Long id;
    @NotNull
    private Long entidade;
    @NotNull
    @Column(updatable=false)
    private Long exercicio;
    @NotNull
    @ManyToOne
    @JoinColumn(name="iddivida", updatable=false)
    @JsonIgnoreProperties(value={"tributos", "formasPagamento", "gruposVencimento", "formaCorrecao", "paramReparcelamento", "relBoletoCarne", "relBoletoCarneAnual", "tabelaValor"})
    private Divida divida;
    @NotNull
    @ManyToOne
    @JoinColumn(name="idtributo", updatable=false)
    private Tributo tributo;
    @NotNull
    @Enumerated(value=EnumType.STRING)
    private TipoCalculoConfig tipo;
    private String identificadorResultado;
    private String identificadorBaseCalculo;
    private String identificadorCondicao;
    private String identificadorReducao;
    private String identificadorAliquota;
    @Column(name="identValorVenalTerritorial")
    private String identificadorValorVenalTerritorial;
    @Column(name="identValorVenalPredial")
    private String identificadorValorVenalPredial;
    private Boolean salvaAliquotaCalculo = Boolean.FALSE;
    @OrderBy(value="id")
    @OneToMany(mappedBy="calculoTributo", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<CalculoTributoScript> script = new ArrayList();
    @Transient
    @JsonIgnore
    private CalculoBuildDTO calculoBuildDTO;

    public TipoDivida getTipoDivida() {
        return this.divida.getTipoDivida();
    }

    public TipoCadastro getTipoCadastro() {
        return this.divida.getTipoCadastro();
    }

    public String getIdentificadorLog() {
        return String.format("do tributo %s", this.tributo.getTributo());
    }

    public InconsistenciaCalculoDTO buildInconsistencia(String mensagem) {
        InconsistenciaCalculoDTO inconsistenciaCalculoDTO = new InconsistenciaCalculoDTO();
        inconsistenciaCalculoDTO.setTributo(this.tributo.getTributo());
        inconsistenciaCalculoDTO.setIdDivida(this.divida.getId());
        inconsistenciaCalculoDTO.setMessage(mensagem);
        return inconsistenciaCalculoDTO;
    }

    public void setIdentificadoresResultado(CalculoResultadoDTO resultadoDTO) {
        resultadoDTO.setIdentificadorValor(this.getIdentificadorResultado());
        resultadoDTO.setIdentificadorAliquota(this.getIdentificadorAliquota());
        resultadoDTO.setIdentificadorValorBase(this.getIdentificadorBaseCalculo());
        resultadoDTO.setIdentificadorCondicao(this.getIdentificadorCondicao());
        resultadoDTO.setIdentificadorValorVenalPredial(this.getIdentificadorValorVenalPredial());
        resultadoDTO.setIdentificadorValorVenalTerritorial(this.getIdentificadorValorVenalTerritorial());
    }

    @Generated
    public CalculoTributo() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public Long getEntidade() {
        return this.entidade;
    }

    @Generated
    public Long getExercicio() {
        return this.exercicio;
    }

    @Generated
    public Divida getDivida() {
        return this.divida;
    }

    @Generated
    public Tributo getTributo() {
        return this.tributo;
    }

    @Generated
    public TipoCalculoConfig getTipo() {
        return this.tipo;
    }

    @Generated
    public String getIdentificadorResultado() {
        return this.identificadorResultado;
    }

    @Generated
    public String getIdentificadorBaseCalculo() {
        return this.identificadorBaseCalculo;
    }

    @Generated
    public String getIdentificadorCondicao() {
        return this.identificadorCondicao;
    }

    @Generated
    public String getIdentificadorReducao() {
        return this.identificadorReducao;
    }

    @Generated
    public String getIdentificadorAliquota() {
        return this.identificadorAliquota;
    }

    @Generated
    public String getIdentificadorValorVenalTerritorial() {
        return this.identificadorValorVenalTerritorial;
    }

    @Generated
    public String getIdentificadorValorVenalPredial() {
        return this.identificadorValorVenalPredial;
    }

    @Generated
    public Boolean getSalvaAliquotaCalculo() {
        return this.salvaAliquotaCalculo;
    }

    @Generated
    public List<CalculoTributoScript> getScript() {
        return this.script;
    }

    @Generated
    public CalculoBuildDTO getCalculoBuildDTO() {
        return this.calculoBuildDTO;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setEntidade(Long entidade) {
        this.entidade = entidade;
    }

    @Generated
    public void setExercicio(Long exercicio) {
        this.exercicio = exercicio;
    }

    @JsonIgnoreProperties(value={"tributos", "formasPagamento", "gruposVencimento", "formaCorrecao", "paramReparcelamento", "relBoletoCarne", "relBoletoCarneAnual", "tabelaValor"})
    @Generated
    public void setDivida(Divida divida) {
        this.divida = divida;
    }

    @Generated
    public void setTributo(Tributo tributo) {
        this.tributo = tributo;
    }

    @Generated
    public void setTipo(TipoCalculoConfig tipo) {
        this.tipo = tipo;
    }

    @Generated
    public void setIdentificadorResultado(String identificadorResultado) {
        this.identificadorResultado = identificadorResultado;
    }

    @Generated
    public void setIdentificadorBaseCalculo(String identificadorBaseCalculo) {
        this.identificadorBaseCalculo = identificadorBaseCalculo;
    }

    @Generated
    public void setIdentificadorCondicao(String identificadorCondicao) {
        this.identificadorCondicao = identificadorCondicao;
    }

    @Generated
    public void setIdentificadorReducao(String identificadorReducao) {
        this.identificadorReducao = identificadorReducao;
    }

    @Generated
    public void setIdentificadorAliquota(String identificadorAliquota) {
        this.identificadorAliquota = identificadorAliquota;
    }

    @Generated
    public void setIdentificadorValorVenalTerritorial(String identificadorValorVenalTerritorial) {
        this.identificadorValorVenalTerritorial = identificadorValorVenalTerritorial;
    }

    @Generated
    public void setIdentificadorValorVenalPredial(String identificadorValorVenalPredial) {
        this.identificadorValorVenalPredial = identificadorValorVenalPredial;
    }

    @Generated
    public void setSalvaAliquotaCalculo(Boolean salvaAliquotaCalculo) {
        this.salvaAliquotaCalculo = salvaAliquotaCalculo;
    }

    @Generated
    public void setScript(List<CalculoTributoScript> script) {
        this.script = script;
    }

    @JsonIgnore
    @Generated
    public void setCalculoBuildDTO(CalculoBuildDTO calculoBuildDTO) {
        this.calculoBuildDTO = calculoBuildDTO;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CalculoTributo)) {
            return false;
        }
        CalculoTributo other = (CalculoTributo)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CalculoTributo;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "CalculoTributo(id=" + this.getId() + ", entidade=" + this.getEntidade() + ", exercicio=" + this.getExercicio() + ", divida=" + this.getDivida() + ", tributo=" + this.getTributo() + ", tipo=" + this.getTipo() + ", script=" + this.getScript() + ")";
    }
}

