/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.metamodel.annotation.MetaModelIgnore;
import br.com.elotech.tributos.domain.ContenciosoDebitoID;
import br.com.elotech.tributos.domain.ContenciosoDebitoParcela;
import br.com.elotech.tributos.domain.Debito;
import br.com.elotech.tributos.domain.DebitoTributo;
import br.com.elotech.tributos.domain.Divida;
import br.com.elotech.tributos.domain.SituacaoContenciosoDebito;
import br.com.elotech.tributos.domain.SituacaoContenciosoDebitoConverter;
import br.com.elotech.tributos.dto.contencioso.ContenciosoDebitoDTO;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.persistence.CascadeType;
import javax.persistence.Convert;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.MapsId;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import lombok.Generated;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="tribcontenciosodebito")
public class ContenciosoDebito
implements Serializable,
EloEntity<ContenciosoDebitoID> {
    @EmbeddedId
    private ContenciosoDebitoID id;
    @MapsId(value="entidade,exercicio,divida,tipocadastro,cadastrogeral,subdivida")
    @MetaModelIgnore
    @JsonIgnore
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumns(value={@JoinColumn(name="entidade", referencedColumnName="entidade"), @JoinColumn(name="exercicio", referencedColumnName="exercicio"), @JoinColumn(name="tipocadastro", referencedColumnName="tipoCadastro"), @JoinColumn(name="cadastroGeral", referencedColumnName="cadastroGeral"), @JoinColumn(name="guiarecolhimento", referencedColumnName="guiarecolhimento"), @JoinColumn(name="subdivida", referencedColumnName="subdivida")})
    private Debito debito;
    @Convert(converter=SituacaoContenciosoDebitoConverter.class)
    private SituacaoContenciosoDebito situacao;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true)
    @JoinColumns(value={@JoinColumn(name="idcontencioso", referencedColumnName="idcontencioso", updatable=false), @JoinColumn(name="entidade", referencedColumnName="entidade", updatable=false), @JoinColumn(name="exercicio", referencedColumnName="exercicio", updatable=false), @JoinColumn(name="tipocadastro", referencedColumnName="tipocadastro", updatable=false), @JoinColumn(name="cadastroGeral", referencedColumnName="cadastrogeral", updatable=false), @JoinColumn(name="guiarecolhimento", referencedColumnName="guiarecolhimento", updatable=false), @JoinColumn(name="subdivida", referencedColumnName="subdivida", updatable=false)})
    private List<ContenciosoDebitoParcela> parcelas = new ArrayList();
    @Transient
    private Boolean selecionado = false;
    @Length(max=2000)
    private @Length(max=2000) String motivoParecer;

    public Long getIdDebito() {
        return Optional.ofNullable(this.debito).map(Debito::getId).orElse(0L);
    }

    public String getSituacaoDetalhada() {
        return Optional.ofNullable(this.situacao).map(SituacaoContenciosoDebito::getDescricao).orElse("");
    }

    public BigDecimal getValorTotal() {
        return Optional.ofNullable(this.debito).map(Debito::getValorTotalDebito).orElse(BigDecimal.ZERO);
    }

    public List<DebitoTributo> getTributos() {
        return Optional.ofNullable(this.debito).map(Debito::getTributos).orElse(new ArrayList());
    }

    public String getDividaDetalhada() {
        return Optional.ofNullable(this.debito).map(Debito::getDivida).map(Divida::getDescricao).orElse("");
    }

    public Boolean isSelected() {
        return this.selecionado;
    }

    public boolean equalsToDto(ContenciosoDebitoDTO dto) {
        return Objects.equals(this.getId().getIdContencioso(), dto.getId().getIdContencioso()) && Objects.equals(this.getId().getEntidade(), dto.getId().getEntidade()) && Objects.equals(this.getId().getExercicio(), dto.getId().getExercicio()) && Objects.equals(this.getId().getTipoCadastro().getValue(), dto.getId().getTipoCadastro()) && Objects.equals(this.getId().getCadastroGeral(), dto.getId().getCadastroGeral()) && Objects.equals(this.getId().getDivida(), dto.getId().getDivida()) && Objects.equals(this.getId().getSubDivida(), dto.getId().getSubDivida());
    }

    @Generated
    public ContenciosoDebito() {
    }

    @Generated
    public ContenciosoDebitoID getId() {
        return this.id;
    }

    @Generated
    public Debito getDebito() {
        return this.debito;
    }

    @Generated
    public SituacaoContenciosoDebito getSituacao() {
        return this.situacao;
    }

    @Generated
    public List<ContenciosoDebitoParcela> getParcelas() {
        return this.parcelas;
    }

    @Generated
    public Boolean getSelecionado() {
        return this.selecionado;
    }

    @Generated
    public String getMotivoParecer() {
        return this.motivoParecer;
    }

    @Generated
    public void setId(ContenciosoDebitoID id) {
        this.id = id;
    }

    @JsonIgnore
    @Generated
    public void setDebito(Debito debito) {
        this.debito = debito;
    }

    @Generated
    public void setSituacao(SituacaoContenciosoDebito situacao) {
        this.situacao = situacao;
    }

    @Generated
    public void setParcelas(List<ContenciosoDebitoParcela> parcelas) {
        this.parcelas = parcelas;
    }

    @Generated
    public void setSelecionado(Boolean selecionado) {
        this.selecionado = selecionado;
    }

    @Generated
    public void setMotivoParecer(String motivoParecer) {
        this.motivoParecer = motivoParecer;
    }

    @Generated
    public String toString() {
        return "ContenciosoDebito(id=" + this.getId() + ", debito=" + this.getDebito() + ", situacao=" + this.getSituacao() + ", parcelas=" + this.getParcelas() + ", selecionado=" + this.getSelecionado() + ", motivoParecer=" + this.getMotivoParecer() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ContenciosoDebito)) {
            return false;
        }
        ContenciosoDebito other = (ContenciosoDebito)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        ContenciosoDebitoID this$id = this.getId();
        ContenciosoDebitoID other$id = other.getId();
        return !(this$id == null ? other$id != null : !this$id.equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ContenciosoDebito;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ContenciosoDebitoID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        return result;
    }
}

