/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain;

import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.converter.BooleanToStringConverter;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.metamodel.annotation.Caption;
import br.com.elotech.tributos.domain.Ato;
import br.com.elotech.tributos.domain.Entidade;
import br.com.elotech.tributos.domain.TipoCaucao;
import java.time.LocalDate;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="TRIBCAUCAO")
public class Caucao
implements EloEntity<Long> {
    @Id
    @Column(name="idkey")
    @EloSequence(sequenceName="S_TRIBCAUCAO_ID")
    private Long id;
    @ManyToOne
    @NotNull
    private Entidade entidade;
    private Long caucao;
    @Length(max=60)
    @Caption(value="N\u00famero Alvar\u00e1")
    private @Length(max=60) String numeroAlvara;
    @Length(max=1000)
    @Caption(value="Motivo")
    private @Length(max=1000) String motivo;
    private LocalDate dataInclusao;
    @Caption(value="Usu\u00e1rio")
    @Length(max=250)
    private @Length(max=250) String usuario;
    @ManyToOne
    @JoinColumn(name="idato", referencedColumnName="idkey")
    private Ato ato;
    @Convert(converter=BooleanToStringConverter.class)
    @Caption(value="Doa\u00e7\u00e3o")
    private Boolean doacao = Boolean.FALSE;
    @ManyToOne
    @JoinTable(name="tribcaucaotipo", joinColumns={@JoinColumn(name="tribcaucao_idkey", referencedColumnName="idkey")})
    private TipoCaucao tipoCaucao;

    @Generated
    public Caucao() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public Entidade getEntidade() {
        return this.entidade;
    }

    @Generated
    public Long getCaucao() {
        return this.caucao;
    }

    @Generated
    public String getNumeroAlvara() {
        return this.numeroAlvara;
    }

    @Generated
    public String getMotivo() {
        return this.motivo;
    }

    @Generated
    public LocalDate getDataInclusao() {
        return this.dataInclusao;
    }

    @Generated
    public String getUsuario() {
        return this.usuario;
    }

    @Generated
    public Ato getAto() {
        return this.ato;
    }

    @Generated
    public Boolean getDoacao() {
        return this.doacao;
    }

    @Generated
    public TipoCaucao getTipoCaucao() {
        return this.tipoCaucao;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setEntidade(Entidade entidade) {
        this.entidade = entidade;
    }

    @Generated
    public void setCaucao(Long caucao) {
        this.caucao = caucao;
    }

    @Generated
    public void setNumeroAlvara(String numeroAlvara) {
        this.numeroAlvara = numeroAlvara;
    }

    @Generated
    public void setMotivo(String motivo) {
        this.motivo = motivo;
    }

    @Generated
    public void setDataInclusao(LocalDate dataInclusao) {
        this.dataInclusao = dataInclusao;
    }

    @Generated
    public void setUsuario(String usuario) {
        this.usuario = usuario;
    }

    @Generated
    public void setAto(Ato ato) {
        this.ato = ato;
    }

    @Generated
    public void setDoacao(Boolean doacao) {
        this.doacao = doacao;
    }

    @Generated
    public void setTipoCaucao(TipoCaucao tipoCaucao) {
        this.tipoCaucao = tipoCaucao;
    }

    @Generated
    public String toString() {
        return "Caucao(id=" + this.getId() + ", entidade=" + this.getEntidade() + ", caucao=" + this.getCaucao() + ", numeroAlvara=" + this.getNumeroAlvara() + ", motivo=" + this.getMotivo() + ", dataInclusao=" + this.getDataInclusao() + ", usuario=" + this.getUsuario() + ", ato=" + this.getAto() + ", doacao=" + this.getDoacao() + ", tipoCaucao=" + this.getTipoCaucao() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Caucao)) {
            return false;
        }
        Caucao other = (Caucao)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Caucao;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }
}

