/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.calculo.repository;

import br.com.elotech.core.repository.support.CrudRepository;
import br.com.elotech.tributos.calculo.domain.Calculo;
import br.com.elotech.tributos.calculo.domain.CalculoCadastro;
import java.math.BigDecimal;
import java.util.List;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

public interface CalculoCadastroRepository
extends CrudRepository<CalculoCadastro, Long> {
    @Query(value="select calculoCadastro from CalculoCadastro calculoCadastro where calculoCadastro.calculo.id = :idCalculo and exists (select 1 from calculoCadastro.inconsistencias)")
    public List<CalculoCadastro> findInconsistentesByCalculo(@Param(value="idCalculo") Long var1);

    @Query(value="select coalesce(sum(cr.valor), 0) from CalculoCadastro cc inner join cc.resultados cr where cc.calculo.id = :idCalculo")
    public BigDecimal getTotalCalculadoByCalculo(@Param(value="idCalculo") Long var1);

    @Query(value="select coalesce(sum(crd.valor), 0) from CalculoCadastro cc inner join cc.resultados cr inner join cr.deducoes crd where cc.calculo.id = :idCalculo")
    public BigDecimal getTotalIsencoesByCalculo(@Param(value="idCalculo") Long var1);

    public List<CalculoCadastro> findByCalculo(Calculo var1);

    @Query(value="select calculoCadastro from CalculoLoteImpressaoItem calculoLoteImpressaoItem inner join calculoLoteImpressaoItem.calculoLoteImpressao calculoLoteImpressao inner join calculoLoteImpressaoItem.calculoCadastro calculoCadastro where calculoLoteImpressao.id = :idCalculoLoteImpressao ")
    public List<CalculoCadastro> findByLoteImpressao(@Param(value="idCalculoLoteImpressao") Long var1);
}

