/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.simam.inscricaodividaativa;

import br.com.elotech.lib.painel.dto.NotificationStatus;
import br.com.elotech.tributos.service.NotificacaoService;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.listener.JobExecutionListenerSupport;
import org.springframework.stereotype.Component;

@Component
public class InscricaoDividaAtivaImplantacaoSaldoJobListener
extends JobExecutionListenerSupport {
    private static final String EXERCICIO = "exercicio";
    private static final String ID_NOTIFICACAO = "idNotificacao";
    private final NotificacaoService notificacaoService;

    public void beforeJob(JobExecution jobExecution) {
        super.beforeJob(jobExecution);
        Long exercicio = Objects.requireNonNull(jobExecution.getJobParameters().getLong(EXERCICIO));
        Optional notificacaoId = this.notificacaoService.send("SIM-AM - Inscri\u00e7\u00e3o de d\u00edvida ativa (Implanta\u00e7\u00e3o de saldo) iniciado", String.format("Iniciada a gera\u00e7\u00e3o de dados de Inscri\u00e7\u00e3o de d\u00edvida ativa (Implanta\u00e7\u00e3o de saldo) do exerc\u00edcio %d.", exercicio), jobExecution, Optional.empty(), NotificationStatus.STARTED);
        jobExecution.getExecutionContext().put(ID_NOTIFICACAO, notificacaoId.map(UUID::toString).orElse(null));
    }

    public void afterJob(JobExecution jobExecution) {
        super.afterJob(jobExecution);
        Long exercicio = Objects.requireNonNull(jobExecution.getJobParameters().getLong(EXERCICIO));
        UUID notificacaoId = UUID.fromString(jobExecution.getExecutionContext().getString(ID_NOTIFICACAO));
        if (BatchStatus.COMPLETED.equals((Object)jobExecution.getStatus())) {
            this.notificacaoService.send("SIM-AM - Inscri\u00e7\u00e3o de D\u00edvida Ativa (Implanta\u00e7\u00e3o de saldo) finalizado com sucesso", String.format("Os dados referentes \u00e0 Inscri\u00e7\u00e3o de D\u00edvida Ativa (Implanta\u00e7\u00e3o de saldo) do exerc\u00edcio %d foram gerados com sucesso.", exercicio), jobExecution, Optional.of(notificacaoId), NotificationStatus.COMPLETED);
        }
        if (BatchStatus.FAILED.equals((Object)jobExecution.getStatus())) {
            this.notificacaoService.send("Erro na gera\u00e7\u00e3o de dados do SIM-AM - Inscri\u00e7\u00e3o de D\u00edvida Ativa", "N\u00e3o foi poss\u00edvel gerar os dados.", jobExecution, Optional.of(notificacaoId), NotificationStatus.FAILED);
        }
    }

    @Generated
    public InscricaoDividaAtivaImplantacaoSaldoJobListener(NotificacaoService notificacaoService) {
        this.notificacaoService = notificacaoService;
    }
}

