/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.protesto;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.protesto.Protesto;
import br.com.elotech.tributos.dto.GerarProtestoRemessaDTO;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collections;
import java.util.Map;
import javax.persistence.EntityManagerFactory;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.item.database.JpaPagingItemReader;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
@StepScope
public class GerarProtestoRemessaBatchReader
extends JpaPagingItemReader<Protesto> {
    private static final String GERAR_PROTESTO_REMESSA_DTO = "gerarProtestoRemessaDTO";

    public GerarProtestoRemessaBatchReader(@Value(value="#{jobParameters}") Map<String, Object> jobParameters, EntityManagerFactory entityManagerFactory, ObjectMapper objectMapper) {
        GerarProtestoRemessaDTO gerarProtestoRemessaDTO = this.getGerarProtestoRemessaDTO(jobParameters, objectMapper);
        this.setPageSize(100);
        this.setName("gerarProtestoRemessaId");
        this.setEntityManagerFactory(entityManagerFactory);
        this.setQueryString("select p from Protesto p where p.id in (:idsProtesto)");
        this.setParameterValues(Collections.singletonMap("idsProtesto", gerarProtestoRemessaDTO.getIdsProtesto()));
    }

    private GerarProtestoRemessaDTO getGerarProtestoRemessaDTO(Map<String, Object> jobParameters, ObjectMapper objectMapper) {
        try {
            return (GerarProtestoRemessaDTO)objectMapper.readValue((String)jobParameters.get(GERAR_PROTESTO_REMESSA_DTO), GerarProtestoRemessaDTO.class);
        }
        catch (JsonProcessingException jpe) {
            throw new EloValidationException("Erro ao converter JSON. " + jpe.getMessage());
        }
    }
}

