/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.comunicado.manual;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.tributos.dto.BooleanSimNao;
import br.com.elotech.tributos.dto.ComunicadoDebitoConsultaDTO;
import br.com.elotech.tributos.enums.comunicado.TipoComunicadoGeracaoManual;
import br.com.elotech.tributos.service.comunicado.GerarComunicadoManualService;
import java.time.LocalDate;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.item.database.JdbcCursorItemReader;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Component;

@Component
@StepScope
public class ComunicadoManualBatchReader
extends JdbcCursorItemReader<ComunicadoDebitoConsultaDTO> {
    private final String ANDVALIDACAODUPLICADO = " and not exists (                            select t.cadastrogeral  from tribcomunicadocadastro t  join tribcomunicado tc on t.exercicio = tc.exercicio and t.entidade = tc.entidade and t.idcomunicado = tc.idcomunicado  where t.tipocadastro = TRIBCADASTROGERAL.tipocadastro  and t.cadastrogeral = TRIBCADASTROGERAL.cadastrogeral  and tc.datavalidade >= :dataReferencia ) ";

    public ComunicadoManualBatchReader(@Value(value="#{jobParameters}") Map<String, Object> jobParameters, DataSource dataSource, GerarComunicadoManualService gerarComunicadoManualService) {
        this.setFetchSize(1000);
        this.setName("comunicadoManualId");
        this.setDataSource(dataSource);
        this.setVerifyCursorPosition(false);
        this.setRowMapper((RowMapper)new ElotechBeanPropertyRowMapper(ComunicadoDebitoConsultaDTO.class));
        this.setSql(this.getSqlFinal(jobParameters, gerarComunicadoManualService));
    }

    private String getSqlFinal(Map<String, Object> jobParameters, GerarComunicadoManualService gerarComunicadoManualService) {
        String tipoComunicado = (String)jobParameters.get("tipoComunicado");
        String filtos = (String)jobParameters.get("filtroUtilizado");
        BooleanSimNao validacaoComunicadoDuplicado = BooleanSimNao.fromValue((String)((String)jobParameters.get("VALIDACOMUNICADODUPLICADO")));
        String sql = this.getSqlCadastros(tipoComunicado, gerarComunicadoManualService);
        StringBuilder sqlComFiltro = new StringBuilder(String.format(sql, filtos));
        if (BooleanSimNao.SIM.equals((Object)validacaoComunicadoDuplicado)) {
            sqlComFiltro.append(" and not exists (                            select t.cadastrogeral  from tribcomunicadocadastro t  join tribcomunicado tc on t.exercicio = tc.exercicio and t.entidade = tc.entidade and t.idcomunicado = tc.idcomunicado  where t.tipocadastro = TRIBCADASTROGERAL.tipocadastro  and t.cadastrogeral = TRIBCADASTROGERAL.cadastrogeral  and tc.datavalidade >= :dataReferencia ) ".replace(":dataReferencia", StringUtils.wrap((String)LocalDate.now().toString(), (String)"'")));
        }
        return sqlComFiltro.toString();
    }

    private String getSqlCadastros(String tipoComunicado, GerarComunicadoManualService gerarComunicadoManualService) {
        String path = gerarComunicadoManualService.getSqlString(TipoComunicadoGeracaoManual.valueOf((String)tipoComunicado));
        return FileUtils.readResourceAsString((String)path);
    }
}

