/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.calculoloteimpressaogeracaocarne;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.lib.painel.dto.NotificationStatus;
import br.com.elotech.tributos.calculo.domain.Calculo;
import br.com.elotech.tributos.calculo.domain.SituacaoCalculo;
import br.com.elotech.tributos.calculo.service.CalculoService;
import br.com.elotech.tributos.domain.batch.BatchJobExecution;
import br.com.elotech.tributos.enums.SituacaoGeracaoCarne;
import br.com.elotech.tributos.service.NotificacaoService;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.listener.JobExecutionListenerSupport;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional
public class CalculoGeracaoCarneJobListener
extends JobExecutionListenerSupport {
    private static final String ID = "idCalculo";
    private static final String ID_NOTIFICACAO = "idNotificacao";
    private final NotificacaoService notificacaoService;
    private final CalculoService calculoService;

    public void beforeJob(JobExecution jobExecution) {
        super.beforeJob(jobExecution);
        Long idCalculo = jobExecution.getJobParameters().getLong(ID);
        Optional notificacaoId = this.notificacaoService.send("Gera\u00e7\u00e3o dos carn\u00eas iniciada.", String.format("Foi iniciada a gera\u00e7\u00e3o dos carn\u00eas dos lotes de impress\u00e3o do c\u00e1lculo %d.", idCalculo), jobExecution, Optional.empty(), NotificationStatus.STARTED);
        jobExecution.getExecutionContext().put(ID_NOTIFICACAO, notificacaoId.map(UUID::toString).orElse(null));
        Calculo calculo = this.calculoService.findCalculoById(idCalculo);
        calculo.setBatchJobExecutionCarne(BatchJobExecution.of((JobExecution)jobExecution));
        calculo.setSituacao(SituacaoCalculo.GERANDO_CARNE);
        this.calculoService.save((EloEntity)calculo, null);
    }

    public void afterJob(JobExecution jobExecution) {
        super.afterJob(jobExecution);
        Long idCalculo = jobExecution.getJobParameters().getLong(ID);
        UUID notificacaoId = UUID.fromString(jobExecution.getExecutionContext().getString(ID_NOTIFICACAO));
        Calculo calculo = this.calculoService.findCalculoById(idCalculo);
        boolean algumCarneFalhou = calculo.getCadastros().stream().anyMatch(c -> SituacaoGeracaoCarne.ERRO.equals((Object)c.getSituacaoCarne()));
        if (BatchStatus.COMPLETED.equals((Object)jobExecution.getStatus()) && !algumCarneFalhou) {
            calculo.setSituacao(SituacaoCalculo.CARNE_GERADO);
            this.calculoService.save((EloEntity)calculo, null);
            this.notificacaoService.send("Gera\u00e7\u00e3o dos carn\u00eas finalizada com sucesso.", String.format("A gera\u00e7\u00e3o dos carn\u00eas dos lotes de impress\u00e3o do c\u00e1lculo %d foi finalizada com sucesso.", idCalculo), jobExecution, Optional.of(notificacaoId), NotificationStatus.COMPLETED);
        }
        if (BatchStatus.FAILED.equals((Object)jobExecution.getStatus()) || algumCarneFalhou) {
            calculo.setSituacao(SituacaoCalculo.ERRO_GERACAO_CARNE);
            this.calculoService.save((EloEntity)calculo, null);
            this.notificacaoService.send("Erro na gera\u00e7\u00e3o dos carn\u00eas.", String.format("N\u00e3o foi poss\u00edvel realizar a gera\u00e7\u00e3o dos carn\u00eas dos lotes de impress\u00e3o do c\u00e1lculo %d.", idCalculo), jobExecution, Optional.of(notificacaoId), NotificationStatus.FAILED);
        }
    }

    @Generated
    public CalculoGeracaoCarneJobListener(NotificacaoService notificacaoService, CalculoService calculoService) {
        this.notificacaoService = notificacaoService;
        this.calculoService = calculoService;
    }
}

