/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.alteracaocadastroemmassa;

import br.com.elotech.tributos.dto.EdicaoEmMassaFiltroDTO;
import br.com.elotech.tributos.repository.EdicaoEmMassaRepository;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Map;
import javax.sql.DataSource;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.item.database.JdbcCursorItemReader;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
@StepScope
public class EdicaoEmMassaBatchReader
extends JdbcCursorItemReader<Long> {
    private final ObjectMapper objectMapper;

    public EdicaoEmMassaBatchReader(@Value(value="#{jobParameters}") Map<String, Object> jobParameters, DataSource dataSource, EdicaoEmMassaRepository edicaoEmMassaRepository, @Qualifier(value="objectMapper") ObjectMapper objectMapper) throws JsonProcessingException {
        this.objectMapper = objectMapper;
        this.setFetchSize(1000);
        this.setName("edicaoEmMassaId");
        this.setDataSource(dataSource);
        this.setVerifyCursorPosition(false);
        this.setRowMapper((rs, rowNum) -> rs.getLong("idCadastro"));
        this.setSql(this.getSql(jobParameters, edicaoEmMassaRepository));
    }

    private String getSql(Map<String, Object> jobParameters, EdicaoEmMassaRepository edicaoEmMassaRepository) throws JsonProcessingException {
        EdicaoEmMassaFiltroDTO filtro = (EdicaoEmMassaFiltroDTO)this.objectMapper.readValue((String)jobParameters.get("filtro"), EdicaoEmMassaFiltroDTO.class);
        return edicaoEmMassaRepository.generateSql(filtro);
    }
}

