with nrsDuplicados as (select nrarrecadacao, nranoarrecadacao, count(1) as quantidade 
						from tcearrecadacaotipocredito group by 1,2),
arrecadacaoDuplicados as (select nrarrecadacao, nranoarrecadacao, idtipoorigemreceita, nrCredito, nranocredito, nrdivida, nranodivida, idtipoarrecadacao, nrmes, nrano, count(1) as quantidades
							from tcearrecadacaotipocredito
							where nranoarrecadacao = extract(year from :dataFinal::date)
							group by 1,2,3,4,5,6,7,8,9, 10)
select arrecadacao.idtcearrtipocredito,
       arrecadacao.nrarrecadacao,
       arrecadacao.nranoarrecadacao,
       arrecadacao.vlarrecadacao,
       arrecadacao.nrcredito,
       arrecadacao.nranocredito,
       arrecadacao.nrdivida,
       arrecadacao.nranodivida,
       arrecadacao.nrmes,
       arrecadacao.nrano,
       arrecadacao.idtipoorigemreceita,
       arrecadacao.idtipoarrecadacao,
       tlc.nrcredito as lancamentoNrCredito,
       tlc.nranocredito as lancamentoNrAnoCredito,
       tida.nrdivida as inscricaoNrDivida,
       tida.nranodivida as inscricaoNrAnoDivida,
       nrdup.quantidade as qtRegistros,
       arrdup.quantidades as qtArrecadacao,
       coalesce(lag(arrecadacao.nrarrecadacao , 1) over (order by idtcearrtipocredito), 0) as nrArrecadacaoAnterior
from tcearrecadacaotipocredito arrecadacao
		left join tcelanccredito tlc on tlc.nrcredito = arrecadacao.nrcredito and tlc.nranocredito = arrecadacao.nranocredito 
		left join tceinsccreditoda tida on tida.nranodivida = arrecadacao.nranodivida and tida.nrdivida = arrecadacao.nrdivida 
        inner join nrsDuplicados nrdup on arrecadacao.nrarrecadacao = nrdup.nrarrecadacao and arrecadacao.nranoarrecadacao = nrdup.nranoarrecadacao
        inner join arrecadacaoDuplicados arrdup on arrdup.nrarrecadacao = arrecadacao.nrarrecadacao
where arrecadacao.nrmes  = extract(month from :dataFinal::date) and arrecadacao.nrano= extract(year from :dataFinal::date);