select
	pg.datalancamento as dataSituacao,
	p.cnpj_cpf  as cpfCnpj,
	p.nome as contribuinte,
	r.descricao as especie,
	md.descricao as justificativa,
	t1.valordesconto as valor
from
	tribpagamento pg
join tribpagamentobloqueto pb
    on pb.entidade = pg.entidade
	and pb.exerciciopagamento  = pg.exerciciopagamento
	and pb.pagamento = pg.pagamento
join tribmotivodesconto md
    on md.motivodesconto = pb.motivodesconto
join tribpagamentodebito t1
    on t1.idpagamentobloqueto = pb.idpagamentobloqueto
join tribdebitoparcelareceita dpr
    on dpr.iddebitoparcelareceita = t1.iddebitoparcelareceita
join tribcadastrogeral cg
    on cg.tipocadastro = dpr.tipocadastro
	and cg.cadastrogeral = dpr.cadastrogeral
join pessoa p
    on p.pessoa = cg.pessoa
join tribreceita r
    on r.entidade = dpr.entidade
	and r.exercicio = dpr.exercicio
	and r.receita = dpr.receita
left join tribreceitatipo rectipo
    on rectipo.tiporeceita = r.tiporeceita
left join tribclassificacaoreceitatipo classtipo
    on classtipo.classificacaoreceitatipo = rectipo.classificacaoreceitatipo
where
	pg.datalancamento between :dataInicial and :dataFinal
	and md.tipodeducao = :tipoMovimento
	and t1.valordesconto > 0
%s