select tp.entidade,
       tep.datareabilitacao    as datamovimentacao,
       tr.receita              as tributo,
       tr.descricao            as descricaotributo,
       tr.tiporeceita          as tipoTributo,
       desconto.classificacaotributo,
       case
         when tdp.situacaolegal <> 0 and ( tdp.datadividaativa is null or tdp.datadividaativa <= tep.datareabilitacao )
         then tdp.situacaolegal
         else 0
       end                     situacaolegal,
       ttot.codigotce          as tipooperacaodeducao,
       'DESCONTO_PARCELAMENTO' as tipomovimento,
       td.iddebito,
       p.idunico as idunicopessoa,
       desconto.iddebitoparcelareceita,
       desconto.valor     as valor
from   tribestornoparcelamento tep
       left outer join tribparcelamento tp
                    on tp.idparcelamento = tep.idparcelamento
       left outer join tribparamparcelamento tpp
                    on tp.idparametroparcelamento = tpp.idparametroparcelamento
       left outer join tribmotivodesconto tmd
                    on tpp.motivodesconto = tmd.motivodesconto
       left outer join tribtipooperacaotce ttot
                    on tmd.idtipooperacaotce = ttot.idtipooperacaotce
       left outer join (select
                           x.idparcelamento,
                           'P'            as classificacaotributo,
                            case
                          when x.parcela = x.max_parcela then
                                  x.valordescontoprincipal  -
                                  coalesce((select sum(y.rateio_desconto_principal)
                                            from vw_desc_parcelamento_prox_sub y
                                            where y.idparcelamento = x.idparcelamento
                                              and y.iddebito = x.iddebito
                                              and y.receitaorigem = x.receitaorigem
                                              and y.parcela <> x.max_parcela), 0)
                          else x.rateio_desconto_principal end as valor,
                           x.iddebitoparcelareceita,
                           x.iddebito,
                           x.receita,
                           x.guiarecolhimento,
                           x.parcela,
                           x.situacaolegal
                      	from vw_desc_parcelamento_prox_sub x
                      	where x.rateio_desconto_principal > 0
                        union
						select
                           x.idparcelamento,
                           'J'            as classificacaotributo,
                           case
                          when x.parcela = x.max_parcela then
                                  x.valordescontojuros  -
                                  coalesce((select sum(y.rateio_desconto_juros)
                                            from vw_desc_parcelamento_prox_sub y
                                            where y.idparcelamento = x.idparcelamento
                                              and y.iddebito = x.iddebito
                                              and y.receitaorigem = x.receitaorigem
                                              and y.parcela <> x.max_parcela), 0)
                          else x.rateio_desconto_juros end as valor,
                           x.iddebitoparcelareceita,
                           x.iddebito,
                           x.receita,
                           x.guiarecolhimento,
                           x.parcela,
                           x.situacaolegal
                      	from vw_desc_parcelamento_prox_sub x
                      	where x.rateio_desconto_juros > 0
                        union
						select
                           x.idparcelamento,
                           'M'            as classificacaotributo,
                            case
                          when x.parcela = x.max_parcela then
                                  x.valordescontomulta  -
                                  coalesce((select sum(y.rateio_desconto_multa)
                                            from vw_desc_parcelamento_prox_sub y
                                            where y.idparcelamento = x.idparcelamento
                                              and y.iddebito = x.iddebito
                                              and y.receitaorigem = x.receitaorigem
                                              and y.parcela <> x.max_parcela), 0)
                          else x.rateio_desconto_multa end as valor,
                           x.iddebitoparcelareceita,
                           x.iddebito,
                           x.receita,
                           x.guiarecolhimento,
                           x.parcela,
                           x.situacaolegal
                      	from vw_desc_parcelamento_prox_sub x
                      	where x.rateio_desconto_multa > 0
                        union
   						select
                           x.idparcelamento,
                           'C'            as classificacaotributo,
                           case
                          when x.parcela = x.max_parcela then
                                  x.valordescontocorrecao  -
                                  coalesce((select sum(y.rateio_desconto_correcao)
                                            from vw_desc_parcelamento_prox_sub y
                                            where y.idparcelamento = x.idparcelamento
                                              and y.iddebito = x.iddebito
                                              and y.receitaorigem = x.receitaorigem
                                              and y.parcela <> x.max_parcela), 0)
                          else x.rateio_desconto_correcao end as valor,
                           x.iddebitoparcelareceita,
                           x.iddebito,
                           x.receita,
                           x.guiarecolhimento,
                           x.parcela,
                           x.situacaolegal
                      	from vw_desc_parcelamento_prox_sub x
                      	where x.rateio_desconto_correcao > 0) desconto
                    on desconto.idparcelamento = tep.idparcelamento
       left outer join tribdebito td
                    on td.iddebito = desconto.iddebito
                  join tribcadastrogeral tcg
                    on td.tipocadastro = tcg.tipocadastro
                   and td.cadastrogeral = tcg.cadastrogeral
                  join pessoa p
                    on tcg.pessoa = p.pessoa
       left outer join tribdebitoparcela tdp
                    on td.entidade = tdp.entidade
                   and td.exercicio = tdp.exercicio
                   and td.tipocadastro = tdp.tipocadastro
                   and td.cadastrogeral = tdp.cadastrogeral
                   and td.guiarecolhimento = tdp.guiarecolhimento
                   and td.subdivida = tdp.subdivida
                   and tdp.parcela = desconto.parcela
       left outer join tribreceita tr
                    on td.entidade = tr.entidade
                   and :exercicio = tr.exercicio
                   and desconto.receita = tr.receita
where  td.constituido = 'S'
  and  tep.datareabilitacao in (:datasMovimento)
  and  exists(select 1 from tribestornoparcelamentodebito tepd
                      where tepd.idestornoparcelamento = tep.idestornoparcelamento
                        and tepd.iddebitoorigem < tepd.iddebitodestino)
  and tep.dataestorno <> tep.datareabilitacao