/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.simam.validacaoregrasimportacao;

import br.com.elotech.tributos.domain.simam.validacoes.ErrosImportacaoSIMAM;
import br.com.elotech.tributos.dto.simam.validacaoimportacao.AtualizacaoMonetariaDAValidacaoDTO;
import br.com.elotech.tributos.enums.TipoRegistroSimAm;
import br.com.elotech.tributos.util.DateUtils;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.Month;
import java.time.Year;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.batch.core.StepExecution;
import org.springframework.stereotype.Service;

@Service
public class AtualizacaoMonetariaDAValidacaoAMService {
    private static final Long CODIGO_ESCOPO_LEI = 22L;

    public List<ErrosImportacaoSIMAM> validateAtualizacaoMonetariaDA(AtualizacaoMonetariaDAValidacaoDTO atualizacaoMonetariaDAValidacaoDTO, StepExecution stepExecution) {
        ArrayList<Optional> erros = new ArrayList<Optional>();
        erros.add(this.validateRegistroDuplicado(atualizacaoMonetariaDAValidacaoDTO));
        erros.add(this.validateSequenciaNrAtualizacao(atualizacaoMonetariaDAValidacaoDTO));
        erros.add(this.validateDividaExistente(atualizacaoMonetariaDAValidacaoDTO));
        erros.add(this.validateIdTipoCredito(atualizacaoMonetariaDAValidacaoDTO));
        erros.add(this.validateCdControleLeiAto(atualizacaoMonetariaDAValidacaoDTO));
        erros.add(this.validateDataAtualizacao(atualizacaoMonetariaDAValidacaoDTO, stepExecution));
        erros.add(this.validateVlAtualizacao(atualizacaoMonetariaDAValidacaoDTO));
        erros.add(this.validateRegistroDuplicadoNrRegistro(atualizacaoMonetariaDAValidacaoDTO));
        erros.add(this.validateNrAnoDivida(atualizacaoMonetariaDAValidacaoDTO));
        return erros.stream().filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    private Optional<ErrosImportacaoSIMAM> validateRegistroDuplicado(AtualizacaoMonetariaDAValidacaoDTO atualizacaoMonetariaDAValidacaoDTO) {
        if (atualizacaoMonetariaDAValidacaoDTO.getNrRegistrosAtualizacao() > 1L) {
            return Optional.of(ErrosImportacaoSIMAM.from((Long)atualizacaoMonetariaDAValidacaoDTO.getIdTceAtualizaMoneCredDA(), (String)"O conjunto(nrAtualizacao e nrAnoAtualizacao) declarado da tabela (AtualizacaoDividaAtiva) apresenta-se com registro duplicado.", (Long)1375L, (TipoRegistroSimAm)TipoRegistroSimAm.ATUALIZACAO_MONETARIA_CREDITO_DIVIDA_ATIVA));
        }
        return Optional.empty();
    }

    private Optional<ErrosImportacaoSIMAM> validateSequenciaNrAtualizacao(AtualizacaoMonetariaDAValidacaoDTO atualizacaoMonetariaDAValidacaoDTO) {
        if (atualizacaoMonetariaDAValidacaoDTO.isNrAtualizacaoOuNrAtualizacaoAnteriorNull().booleanValue() || atualizacaoMonetariaDAValidacaoDTO.isNrAtualizacaoQuebrandoSequencia().booleanValue()) {
            return Optional.of(ErrosImportacaoSIMAM.from((Long)atualizacaoMonetariaDAValidacaoDTO.getIdTceAtualizaMoneCredDA(), (String)"O N\u00famero e Ano do Cr\u00e9dito (nrAtualizacao e nrAnoAtualizacao) da tabela (AtualizacaoDividaAtiva) apresenta-se quebra da ordem num\u00e9rica no ano de trabalho com ou cronol\u00f3gica associada a num\u00e9rica", (Long)1376L, (TipoRegistroSimAm)TipoRegistroSimAm.ATUALIZACAO_MONETARIA_CREDITO_DIVIDA_ATIVA));
        }
        return Optional.empty();
    }

    private Optional<ErrosImportacaoSIMAM> validateDividaExistente(AtualizacaoMonetariaDAValidacaoDTO atualizacaoMonetariaDAValidacaoDTO) {
        if (atualizacaoMonetariaDAValidacaoDTO.getNrRegistrosDivida() < 1L) {
            return Optional.of(ErrosImportacaoSIMAM.from((Long)atualizacaoMonetariaDAValidacaoDTO.getIdTceAtualizaMoneCredDA(), (String)"O conjunto(nrDivida e nrAnoDivida) declarado da tabela (AtualizacaoDividaAtiva)  n\u00e3o existe na tabela (InscricaoDividaAtiva).", (Long)1377L, (TipoRegistroSimAm)TipoRegistroSimAm.ATUALIZACAO_MONETARIA_CREDITO_DIVIDA_ATIVA));
        }
        return Optional.empty();
    }

    private Optional<ErrosImportacaoSIMAM> validateIdTipoCredito(AtualizacaoMonetariaDAValidacaoDTO atualizacaoMonetariaDAValidacaoDTO) {
        if (Objects.isNull(atualizacaoMonetariaDAValidacaoDTO.getIdTipoCredito())) {
            return Optional.of(ErrosImportacaoSIMAM.from((Long)atualizacaoMonetariaDAValidacaoDTO.getIdTceAtualizaMoneCredDA(), (String)"O Tipo de Opera\u00e7\u00e3o do Cr\u00e9dito (idTipoOperacaoCredito) da tabela (AtualizacaoDividaAtiva) n\u00e3o existe na tabela (TipoOperacaoCredito).", (Long)1378L, (TipoRegistroSimAm)TipoRegistroSimAm.ATUALIZACAO_MONETARIA_CREDITO_DIVIDA_ATIVA));
        }
        return Optional.empty();
    }

    private Optional<ErrosImportacaoSIMAM> validateCdControleLeiAto(AtualizacaoMonetariaDAValidacaoDTO atualizacaoMonetariaDAValidacaoDTO) {
        if (Objects.isNull(atualizacaoMonetariaDAValidacaoDTO.getCdControleLeiAto()) || !CODIGO_ESCOPO_LEI.equals(atualizacaoMonetariaDAValidacaoDTO.getEscopoLei())) {
            return Optional.of(ErrosImportacaoSIMAM.from((Long)atualizacaoMonetariaDAValidacaoDTO.getIdTceAtualizaMoneCredDA(), (String)"O C\u00f3digo de Controle da Lei ou Ato (cdControleLeiAto) da tabela (AtualizacaoDividaAtiva) n\u00e3o existe na tabela (LeiAto) com (idEscopo) = 22.", (Long)1379L, (TipoRegistroSimAm)TipoRegistroSimAm.ATUALIZACAO_MONETARIA_CREDITO_DIVIDA_ATIVA));
        }
        return Optional.empty();
    }

    private Optional<ErrosImportacaoSIMAM> validateDataAtualizacao(AtualizacaoMonetariaDAValidacaoDTO atualizacaoMonetariaDAValidacaoDTO, StepExecution stepExecution) {
        LocalDate mesValidacao = DateUtils.dateToLocalDate((Date)Objects.requireNonNull(stepExecution.getJobExecution().getJobParameters().getDate("dataFinal")));
        Month mesLancamento = atualizacaoMonetariaDAValidacaoDTO.getDtAtualizacao().getMonth();
        Year anoLancamento = Year.of(atualizacaoMonetariaDAValidacaoDTO.getDtAtualizacao().getYear());
        if (!mesLancamento.equals(mesValidacao.getMonth()) || !anoLancamento.equals(Year.of(mesValidacao.getYear()))) {
            return Optional.of(ErrosImportacaoSIMAM.from((Long)atualizacaoMonetariaDAValidacaoDTO.getIdTceAtualizaMoneCredDA(), (String)"A data da atualiza\u00e7\u00e3o da d\u00edvida ativa (dtAtualizacao) da tabela (AtualizacaoDividaAtiva) n\u00e3o pode ser diferente do m\u00eas de refer\u00eancia do arquivo.", (Long)1380L, (TipoRegistroSimAm)TipoRegistroSimAm.ATUALIZACAO_MONETARIA_CREDITO_DIVIDA_ATIVA));
        }
        return Optional.empty();
    }

    private Optional<ErrosImportacaoSIMAM> validateVlAtualizacao(AtualizacaoMonetariaDAValidacaoDTO atualizacaoMonetariaDAValidacaoDTO) {
        if (Objects.isNull(atualizacaoMonetariaDAValidacaoDTO.getVlAtualizacao()) || atualizacaoMonetariaDAValidacaoDTO.getVlAtualizacao().compareTo(BigDecimal.ZERO) < 0) {
            return Optional.of(ErrosImportacaoSIMAM.from((Long)atualizacaoMonetariaDAValidacaoDTO.getIdTceAtualizaMoneCredDA(), (String)"O valor da atualiza\u00e7\u00e3o da d\u00edvida ativa (vlAtualizacao) da tabela (AtualizacaoDividaAtiva) n\u00e3o pode ser menor que 0.", (Long)1381L, (TipoRegistroSimAm)TipoRegistroSimAm.ATUALIZACAO_MONETARIA_CREDITO_DIVIDA_ATIVA));
        }
        return Optional.empty();
    }

    private Optional<ErrosImportacaoSIMAM> validateRegistroDuplicadoNrRegistro(AtualizacaoMonetariaDAValidacaoDTO atualizacaoMonetariaDAValidacaoDTO) {
        if (atualizacaoMonetariaDAValidacaoDTO.getNrRegistro() > 1L) {
            return Optional.of(ErrosImportacaoSIMAM.from((Long)atualizacaoMonetariaDAValidacaoDTO.getIdTceAtualizaMoneCredDA(), (String)"O conjunto(nrAnoAtualizacao, nrDivida, nrAnoDivida, idTipoAtualizacaoCredito, cdControleLeiAto e dtAtualizacao) declarado da tabela (AtualizacaoDividaAtiva) apresenta-se com registro duplicado.", (Long)2118L, (TipoRegistroSimAm)TipoRegistroSimAm.ATUALIZACAO_MONETARIA_CREDITO_DIVIDA_ATIVA));
        }
        return Optional.empty();
    }

    private Optional<ErrosImportacaoSIMAM> validateNrAnoDivida(AtualizacaoMonetariaDAValidacaoDTO atualizacaoMonetariaDAValidacaoDTO) {
        if (Objects.isNull(atualizacaoMonetariaDAValidacaoDTO.getNrAnoDivida())) {
            return Optional.empty();
        }
        if (atualizacaoMonetariaDAValidacaoDTO.getNrAnoDivida() < 2023L) {
            return Optional.of(ErrosImportacaoSIMAM.from((Long)atualizacaoMonetariaDAValidacaoDTO.getIdTceAtualizaMoneCredDA(), (String)"O registro da tabela (AtualizacaoDividaAtiva) n\u00e3o pode estar vinculado com ano de d\u00edvida (nrAnoDivida) menor que o exerc\u00edcio financeiro de 2023.", (Long)2249L, (TipoRegistroSimAm)TipoRegistroSimAm.ATUALIZACAO_MONETARIA_CREDITO_DIVIDA_ATIVA));
        }
        return Optional.empty();
    }
}

