/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.integracaoelogeo;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.service.support.ReadOnlyService;
import br.com.elotech.tributos.domain.camposdinamicos.Campo;
import br.com.elotech.tributos.dto.integracaoelogeo.ModeloCampoElogeoDTO;
import br.com.elotech.tributos.dto.integracaoelogeo.ModeloRespostaElogeoDTO;
import br.com.elotech.tributos.repository.camposdinamicos.CustomRespostaRepository;
import br.com.elotech.tributos.service.integracaoelogeo.CampoElogeoService;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.context.annotation.Profile;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Profile(value={"!onpremise"})
@Service
public class OxyCampoElogeoService
extends ReadOnlyService<Campo, Long>
implements CampoElogeoService {
    private final CustomRespostaRepository respostaRepository;

    public Page<ModeloCampoElogeoDTO> findAllCampo(Pageable page) {
        return super.findAll(page).map(ModeloCampoElogeoDTO::from);
    }

    public ModeloCampoElogeoDTO findCampoById(Long id) {
        return super.findById((Serializable)id).map(ModeloCampoElogeoDTO::from).orElseThrow(() -> new EloValidationException(String.format("N\u00e3o foi poss\u00edvel encontrar o ModeloCampo com o id '%d'.", id)));
    }

    public List<ModeloRespostaElogeoDTO> findRespostaByIdCampo(Long id) {
        Campo campo = (Campo)super.findById((Serializable)id).orElseThrow(() -> new EloValidationException(String.format("N\u00e3o foi poss\u00edvel encontrar o Campo com o id '%d'.", id)));
        return this.respostaRepository.findRespostaByIdCampo(campo.getId()).stream().map(ModeloRespostaElogeoDTO::from).collect(Collectors.toList());
    }

    @Generated
    public OxyCampoElogeoService(CustomRespostaRepository respostaRepository) {
        this.respostaRepository = respostaRepository;
    }
}

