/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.integracaocontabil;

import br.com.elotech.core.exception.RestException;
import br.com.elotech.fluent.ReportDatasource;
import br.com.elotech.fluent.dataset.loader.DatasetLoader;
import br.com.elotech.fluent.dataset.loader.DatasetLoaders;
import br.com.elotech.fluent.dataset.loader.ReportDataLoader;
import br.com.elotech.fluent.param.Param;
import br.com.elotech.fluent.param.ParamLoader;
import br.com.elotech.report.EloReportFactory;
import br.com.elotech.report.file.ReportFileResolverFactory;
import br.com.elotech.tributos.domain.ArquivoJasper;
import br.com.elotech.tributos.dto.ArrecadacaoPorDadosCadastraisFiltros;
import br.com.elotech.tributos.dto.integracaocontabil.ArrecadacaoPorDadosCadastraisResumoDTO;
import br.com.elotech.tributos.dto.integracaocontabil.ArrecadacaoPorDadosCadastraisRowDTO;
import br.com.elotech.tributos.dto.integracaocontabil.ArrecadacaoPorDadosCadastraisTotaisDTO;
import br.com.elotech.tributos.dto.integracaocontabil.ArrecadacaoPorTributoValoresDTO;
import br.com.elotech.tributos.enums.TipoArquivoJasper;
import br.com.elotech.tributos.report.loader.ExtratoDebitoParamLoader;
import br.com.elotech.tributos.repository.integracaocontabil.ArrecadacaoPorDadosCadastraisRepository;
import br.com.elotech.tributos.security.SecurityUtils;
import br.com.elotech.tributos.service.ArquivoJasperService;
import br.com.elotech.tributos.util.JasperUtils;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;

@Service
public class ArrecadacaoPorDadosCadastraisService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ArrecadacaoPorDadosCadastraisService.class);
    private final ArrecadacaoPorDadosCadastraisRepository repository;
    private final String PDF = "PDF";
    private final String CSV = "CSV";
    private final ArquivoJasperService arquivoJasperService;
    private final ExtratoDebitoParamLoader extratoDebitoParamLoader;
    private final ReportFileResolverFactory reportFileResolverFactory;
    private final ObjectMapper objectMapper;

    public ArrecadacaoPorDadosCadastraisResumoDTO consultaByFiltro(ArrecadacaoPorDadosCadastraisFiltros filtros, Pageable pageable) {
        filtros.validaDatas();
        Page dadosPaginados = this.repository.findArrecadacaoPorDadosCadastrais(filtros, pageable);
        ArrecadacaoPorDadosCadastraisTotaisDTO totais = this.repository.findTotaisArrecadacaoPorDadosCadastrais(filtros);
        return new ArrecadacaoPorDadosCadastraisResumoDTO(dadosPaginados, totais);
    }

    public List<ArrecadacaoPorTributoValoresDTO> consultaTributosByCadastro(Long tipocadastro, Long cadastrogeral, ArrecadacaoPorDadosCadastraisFiltros filtros) {
        return this.repository.findTributosByCadastro(tipocadastro, cadastrogeral, filtros);
    }

    public byte[] imprimirResumoArrecadacaoPorDadosCadastrais(ArrecadacaoPorDadosCadastraisFiltros filtros, Pageable pageable, String reportType) throws IOException {
        switch (reportType) {
            case "PDF": {
                return this.gerarPdf(filtros, pageable);
            }
            case "CSV": {
                return this.gerarCsv(filtros, pageable);
            }
        }
        throw new RestException(HttpStatus.NOT_IMPLEMENTED, "N\u00e3o implementado tipo de impress\u00e3o " + reportType);
    }

    public byte[] gerarPdf(ArrecadacaoPorDadosCadastraisFiltros filtros, Pageable pageable) throws IOException {
        List dadosParaImprimir = this.repository.findArrecadacaoPorDadosCadastraisArquivo(filtros, pageable);
        ArquivoJasper arquivoJasper = this.arquivoJasperService.buscarArquivoJasperPorTipo(TipoArquivoJasper.ARRECADACAO_POR_DADOS_CADASTRAIS_PDF);
        String filePath = JasperUtils.geraCaminhoArquivoJasper((ArquivoJasper)arquivoJasper, (String)"arrecadacao-por-dados-cadastrais-pdf.jrxml");
        DatasetLoader mainDatasetLoader = DatasetLoaders.fromRecords((List)dadosParaImprimir, ArrecadacaoPorDadosCadastraisRowDTO.class);
        ReportDatasource datasource = ReportDatasource.builder().add("main", (ReportDataLoader)mainDatasetLoader).params((ParamLoader)this.extratoDebitoParamLoader).param(Param.of((String)"USUARIO", (Object)SecurityUtils.getUserAise())).build();
        if (Objects.nonNull(arquivoJasper)) {
            byte[] pdf = EloReportFactory.jasper().reportFile(new ReportFileResolverFactory("").fromFile("arrecadacao-por-dados-cadastrais-pdf.jrxml")).setReportDatasource(datasource).setObjectMapper(this.objectMapper).build().exportToPdf();
            Files.deleteIfExists(Paths.get(filePath, new String[0]));
            return pdf;
        }
        return EloReportFactory.jasper().reportFile(this.reportFileResolverFactory.fromFile("arrecadacao-por-dados-cadastrais-pdf.jrxml")).setReportDatasource(datasource).setObjectMapper(this.objectMapper).build().exportToPdf();
    }

    public byte[] gerarCsv(ArrecadacaoPorDadosCadastraisFiltros filtros, Pageable pageable) throws IOException {
        List dadosParaImprimir = this.repository.findArrecadacaoPorDadosCadastraisArquivo(filtros, pageable);
        ArquivoJasper arquivoJasper = this.arquivoJasperService.buscarArquivoJasperPorTipo(TipoArquivoJasper.ARRECADACAO_POR_DADOS_CADASTRAIS_CSV);
        String filePath = JasperUtils.geraCaminhoArquivoJasper((ArquivoJasper)arquivoJasper, (String)"arrecadacao-por-dados-cadastrais-csv.jrxml");
        DatasetLoader mainDatasetLoader = DatasetLoaders.fromRecords((List)dadosParaImprimir, ArrecadacaoPorDadosCadastraisRowDTO.class);
        ReportDatasource datasource = ReportDatasource.builder().add("main", (ReportDataLoader)mainDatasetLoader).params((ParamLoader)this.extratoDebitoParamLoader).param(Param.of((String)"USUARIO", (Object)SecurityUtils.getUserAise())).param(Param.of((String)"FILTRO", (Object)filtros.getWhereClausesWithValues())).build();
        if (Objects.nonNull(arquivoJasper)) {
            byte[] csv = EloReportFactory.jasper().reportFile(new ReportFileResolverFactory("").fromFile("arrecadacao-por-dados-cadastrais-csv.jrxml")).setReportDatasource(datasource).setObjectMapper(this.objectMapper).build().exportToCsv();
            Files.deleteIfExists(Paths.get(filePath, new String[0]));
            return csv;
        }
        return EloReportFactory.jasper().reportFile(this.reportFileResolverFactory.fromFile("arrecadacao-por-dados-cadastrais-csv.jrxml")).setReportDatasource(datasource).setObjectMapper(this.objectMapper).build().exportToCsv();
    }

    @Generated
    public ArrecadacaoPorDadosCadastraisService(ArrecadacaoPorDadosCadastraisRepository repository, ArquivoJasperService arquivoJasperService, ExtratoDebitoParamLoader extratoDebitoParamLoader, ReportFileResolverFactory reportFileResolverFactory, ObjectMapper objectMapper) {
        this.repository = repository;
        this.arquivoJasperService = arquivoJasperService;
        this.extratoDebitoParamLoader = extratoDebitoParamLoader;
        this.reportFileResolverFactory = reportFileResolverFactory;
        this.objectMapper = objectMapper;
    }
}

