/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.integracaoboleto;

import br.com.elotech.tributos.domain.Banco;
import br.com.elotech.tributos.domain.Bloqueto;
import br.com.elotech.tributos.domain.Convenio;
import br.com.elotech.tributos.domain.ModeloBoleto;
import br.com.elotech.tributos.domain.TipoCodigoBarras;
import br.com.elotech.tributos.domain.cnab240.ParametroCNAB240;
import br.com.elotech.tributos.dto.CodigoBarrasDTO;
import br.com.elotech.tributos.service.BloquetoService;
import br.com.elotech.tributos.service.integracaoboleto.IntegracaoBoletoRegistrado;
import com.google.common.base.Stopwatch;
import java.time.LocalDate;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class IntegracaoBoletoRegistradoReceiver {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IntegracaoBoletoRegistradoReceiver.class);
    private Map<TipoCodigoBarras, IntegracaoBoletoRegistrado> services;
    private final BloquetoService bloquetoService;

    public IntegracaoBoletoRegistradoReceiver(List<IntegracaoBoletoRegistrado> services, BloquetoService bloquetoService) {
        this.services = services.stream().collect(Collectors.toMap(IntegracaoBoletoRegistrado::getTipoCodigoBarras, Function.identity()));
        this.bloquetoService = bloquetoService;
    }

    public CodigoBarrasDTO receiveRequest(Bloqueto boleto) {
        if (!this.services.containsKey(boleto.getModeloBloqueto().getConvenio().getTipoCodigoBarras())) {
            throw new IllegalArgumentException("Unknown request type: " + boleto.getModeloBloqueto().getConvenio().getTipoCodigoBarras());
        }
        Stopwatch stopwatch = Stopwatch.createStarted();
        log.info(String.format("Iniciando a integra\u00e7\u00e3o de boleto/pix do banco %s para o boleto %d", Optional.ofNullable(boleto.getModeloBloqueto()).map(ModeloBoleto::getConvenio).map(Convenio::getBanco).map(Banco::getDescricao).orElse(""), boleto.getId()));
        IntegracaoBoletoRegistrado integracaoBoletoRegistrado = (IntegracaoBoletoRegistrado)this.services.get(boleto.getModeloBloqueto().getConvenio().getTipoCodigoBarras());
        integracaoBoletoRegistrado.beforeGenerateBoleto(boleto);
        ParametroCNAB240 parametroCNAB240 = integracaoBoletoRegistrado.getParametroCnab240ByBanco();
        CodigoBarrasDTO codigoBarrasDTO = integracaoBoletoRegistrado.generateBoleto(boleto, parametroCNAB240);
        integracaoBoletoRegistrado.afterGenerateBoleto(boleto, codigoBarrasDTO);
        stopwatch.stop();
        log.info(String.format("Integra\u00e7\u00e3o de boleto/pix para o boleto %d finalizada com dura\u00e7\u00e3o de %d m %d s %d ms", boleto.getId(), stopwatch.elapsed(TimeUnit.MINUTES), stopwatch.elapsed(TimeUnit.SECONDS), stopwatch.elapsed(TimeUnit.MILLISECONDS)));
        return codigoBarrasDTO;
    }

    public Bloqueto receiveCancelamento(Bloqueto boleto) {
        if (!this.services.containsKey(boleto.getModeloBloqueto().getConvenio().getTipoCodigoBarras())) {
            throw new IllegalArgumentException("Unknown request type: " + boleto.getModeloBloqueto().getConvenio().getTipoCodigoBarras());
        }
        Stopwatch stopwatch = Stopwatch.createStarted();
        log.info(String.format("Iniciando o cancelamento de boleto/pix do banco %s para o boleto %d", Optional.ofNullable(boleto.getModeloBloqueto()).map(ModeloBoleto::getConvenio).map(Convenio::getBanco).map(Banco::getDescricao).orElse(""), boleto.getId()));
        IntegracaoBoletoRegistrado integracaoBoletoRegistrado = (IntegracaoBoletoRegistrado)this.services.get(boleto.getModeloBloqueto().getConvenio().getTipoCodigoBarras());
        integracaoBoletoRegistrado.cancelarBoleto(boleto);
        boleto.setCancelado(Boolean.TRUE);
        Bloqueto boletoSalvo = this.bloquetoService.save(boleto);
        stopwatch.stop();
        log.info(String.format("Cancelamento de boleto/pix para o boleto %d finalizado com dura\u00e7\u00e3o de %d m %d s %d ms", boleto.getId(), stopwatch.elapsed(TimeUnit.MINUTES), stopwatch.elapsed(TimeUnit.SECONDS), stopwatch.elapsed(TimeUnit.MILLISECONDS)));
        return boletoSalvo;
    }

    public Bloqueto updateVencimentoBoleto(Bloqueto boleto, LocalDate vencimento) {
        if (!this.services.containsKey(boleto.getModeloBloqueto().getConvenio().getTipoCodigoBarras())) {
            throw new IllegalArgumentException("Unknown request type: " + boleto.getModeloBloqueto().getConvenio().getTipoCodigoBarras());
        }
        if (boleto.getDataVencimento().equals(vencimento)) {
            return boleto;
        }
        Stopwatch stopwatch = Stopwatch.createStarted();
        log.info(String.format("Alterando o vencimento de %s para %s para o boleto %d", boleto.getDataVencimento(), vencimento, boleto.getId()));
        IntegracaoBoletoRegistrado integracaoBoletoRegistrado = (IntegracaoBoletoRegistrado)this.services.get(boleto.getModeloBloqueto().getConvenio().getTipoCodigoBarras());
        integracaoBoletoRegistrado.updateVencimentoBoleto(boleto, vencimento);
        boleto.setDataVencimento(vencimento);
        Bloqueto boletoAlterado = this.bloquetoService.save(boleto);
        stopwatch.stop();
        log.info(String.format("Altera\u00e7\u00e3o de vencimento para o boleto %d finalizada com dura\u00e7\u00e3o de %d m %d s %d ms", boletoAlterado.getId(), stopwatch.elapsed(TimeUnit.MINUTES), stopwatch.elapsed(TimeUnit.SECONDS), stopwatch.elapsed(TimeUnit.MILLISECONDS)));
        return boletoAlterado;
    }
}

