/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.integracaoboleto;

import br.com.elotech.core.enumerable.common.ModuloEnum;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.exception.RestException;
import br.com.elotech.tributos.domain.ParametroGeralEnum;
import br.com.elotech.tributos.domain.integracaoboleto.IntegracaoBoletoPixLog;
import br.com.elotech.tributos.dto.integracaoboleto.DadosCertificadoDTO;
import br.com.elotech.tributos.dto.integracaoboleto.DadosIntegracaoOauth;
import br.com.elotech.tributos.enums.IntegracaoTokenOperation;
import br.com.elotech.tributos.repository.integracaoboleto.IntegracaoBoletoPixLogRepository;
import br.com.elotech.tributos.service.ParametroGeralService;
import br.com.elotech.tributos.service.impl.exception.ParametroNaoEncontradoException;
import br.com.elotech.tributos.service.integracaoboleto.IntegracaoTokenService;
import br.com.elotech.tributos.util.RestTemplateUtils;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.Base64;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public abstract class IntegracaoBoleto {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IntegracaoBoleto.class);
    private final List<IntegracaoTokenService> integracaoTokenServices;
    private final ParametroGeralService parametroGeralService;
    private final IntegracaoBoletoPixLogRepository integracaoBoletoPixLogRepository;
    private final PlatformTransactionManager transactionManager;
    private final TransactionDefinition transactionDefinition;

    protected abstract MultiValueMap<String, String> authBodyBuilder(DadosIntegracaoOauth var1);

    protected String getAccessToken(Long codigoBanco, IntegracaoTokenOperation integracaoTokenOperation, DadosIntegracaoOauth dadosIntegracaoOauth, DadosCertificadoDTO dadosCertificado, MultiValueMap<String, String> body, String tipoToken) {
        IntegracaoTokenService tokenService = this.getTokenService(tipoToken);
        Optional accessToken = tokenService.getAccessToken(codigoBanco, integracaoTokenOperation);
        if (accessToken.isPresent()) {
            return (String)accessToken.get();
        }
        JsonNode response = this.generateNewAccessToken(dadosIntegracaoOauth, dadosCertificado, body);
        return tokenService.saveIntegracaoToken(codigoBanco, integracaoTokenOperation, response);
    }

    protected void salvarIntegracaoBoletoPixLog(IntegracaoBoletoPixLog integracaoBoletoPixLog) {
        new TransactionTemplate(this.transactionManager, this.transactionDefinition).execute(status -> {
            try {
                return (IntegracaoBoletoPixLog)this.integracaoBoletoPixLogRepository.save((Object)integracaoBoletoPixLog);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                return null;
            }
        });
    }

    protected RestTemplate getHttpClientTemplate(DadosCertificadoDTO dadosCertificado) throws UnrecoverableKeyException, CertificateException, KeyStoreException, IOException, NoSuchAlgorithmException, KeyManagementException {
        return Optional.ofNullable(dadosCertificado).map(cert -> {
            try {
                if (Objects.isNull(cert.getCertificado()) || StringUtils.isEmpty((String)cert.getSenhaCertificado())) {
                    throw new EloValidationException("Dados do certificado n\u00e3o foram preenchidos para a integra\u00e7\u00e3o.");
                }
                return RestTemplateUtils.getRestTemplateComCertificado((byte[])cert.getCertificado(), (String)cert.getSenhaCertificado(), (String)cert.getNomeArquivo());
            }
            catch (Exception e) {
                throw new EloValidationException("Erro ao tentar gerar client http com certificado para integra\u00e7\u00e3o de boleto.");
            }
        }).orElse(RestTemplateUtils.getRestTemplateComCertificado(null, null, null));
    }

    protected IntegracaoTokenService getTokenService(String tipo) {
        return this.integracaoTokenServices.stream().filter(s -> s.accept(tipo)).findFirst().orElseThrow(() -> new EloValidationException("N\u00e3o encontrado service para lidar com o tipo de token DEFAULT"));
    }

    protected String getParametro(ParametroGeralEnum parametroGeralEnum) {
        try {
            String valor = this.parametroGeralService.getParamValueAsString(parametroGeralEnum, ModuloEnum.MODULO_TRIBUTARIO.getValue());
            if (StringUtils.isEmpty((String)valor)) {
                throw new RestException(HttpStatus.BAD_REQUEST, String.format("O par\u00e2metro %s n\u00e3o foi configurado.", parametroGeralEnum.name()));
            }
            return valor;
        }
        catch (ParametroNaoEncontradoException e) {
            throw new RestException(HttpStatus.NOT_FOUND, e.getMessage());
        }
    }

    protected int calculateCRC16CCITT(byte[] bytes) {
        int crc = 65535;
        int polynomial = 4129;
        for (byte b : bytes) {
            for (int i = 0; i < 8; ++i) {
                boolean bit = (b >> 7 - i & 1) == 1;
                boolean c15 = (crc >> 15 & 1) == 1;
                crc <<= 1;
                if (!(c15 ^ bit)) continue;
                crc ^= polynomial;
            }
        }
        return crc &= 0xFFFF;
    }

    private JsonNode generateNewAccessToken(DadosIntegracaoOauth dadosIntegracaoOauth, DadosCertificadoDTO dadosCertificado, MultiValueMap<String, String> body) {
        JsonNode response;
        String authorizationBase64 = Base64.getEncoder().encodeToString((dadosIntegracaoOauth.getClientId() + ":" + dadosIntegracaoOauth.getClientSecret()).getBytes());
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        headers.set("Authorization", String.format("Basic %s", authorizationBase64));
        HttpEntity httpEntity = new HttpEntity(body, (MultiValueMap)headers);
        try {
            RestTemplate httpClientTemplate = this.getHttpClientTemplate(dadosCertificado);
            response = (JsonNode)httpClientTemplate.exchange(dadosIntegracaoOauth.getOauthUrl(), HttpMethod.POST, httpEntity, JsonNode.class, new Object[0]).getBody();
            if (Objects.isNull(response) || !response.has("access_token")) {
                throw new RestException(HttpStatus.BAD_REQUEST, "N\u00e3o foi poss\u00edvel buscar o token.");
            }
        }
        catch (Exception ex) {
            throw new EloValidationException("Erro ao tentar executar a requisi\u00e7\u00e3o de gera\u00e7\u00e3o de token da integra\u00e7\u00e3o de boleto");
        }
        return response;
    }

    @Generated
    public IntegracaoBoleto(List<IntegracaoTokenService> integracaoTokenServices, ParametroGeralService parametroGeralService, IntegracaoBoletoPixLogRepository integracaoBoletoPixLogRepository, PlatformTransactionManager transactionManager, TransactionDefinition transactionDefinition) {
        this.integracaoTokenServices = integracaoTokenServices;
        this.parametroGeralService = parametroGeralService;
        this.integracaoBoletoPixLogRepository = integracaoBoletoPixLogRepository;
        this.transactionManager = transactionManager;
        this.transactionDefinition = transactionDefinition;
    }
}

