/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.cnab240;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.domain.Banco;
import br.com.elotech.tributos.domain.cnab240.CNAB240CodigoDesconto;
import br.com.elotech.tributos.domain.cnab240.CNAB240CodigoJuros;
import br.com.elotech.tributos.domain.cnab240.CNAB240CodigoMulta;
import br.com.elotech.tributos.domain.cnab240.CNAB240CodigoProtesto;
import br.com.elotech.tributos.domain.cnab240.ParametroCNAB240;
import br.com.elotech.tributos.enums.manutencaobancariacef.AcaoPosVencimento;
import br.com.elotech.tributos.enums.manutencaobancariacef.TipoJurosMora;
import br.com.elotech.tributos.enums.manutencaobancariacef.TipoMulta;
import br.com.elotech.tributos.repository.cnab240.ParametroCNAB240Repository;
import java.math.BigDecimal;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Service;

@Service
public class ParametroCNAB240Service
extends CrudService<ParametroCNAB240, Long> {
    private static final Long TIPO_PERCENTUAL_DESCONTO = 2L;
    private static final Long QUANTIDADE_MINIMA_DIAS_PROTESTO = 2L;
    private static final Long QUANTIDADE_MAXIMA_DIAS_PROTESTO = 90L;
    private static final String MENSAGEM_ERRO_PERCENTUAL = "O Percentual %s informado deve estar entre 0 e 100";
    private final ParametroCNAB240Repository parametroCNAB240Repository;

    protected void beforeSave(ParametroCNAB240 entity, Authentication authentication) {
        super.beforeSave((EloEntity)entity, authentication);
        Optional parametroCNAB240Banco = this.parametroCNAB240Repository.findByBancoAndIdNot(entity.getBanco(), Optional.ofNullable(entity.getId()).orElse(0L));
        if (parametroCNAB240Banco.isPresent()) {
            Banco banco = entity.getBanco();
            throw new EloValidationException(String.format("J\u00e1 existe uma parametriza\u00e7\u00e3o CNAB 240 para o banco %d - %s", banco.getId(), banco.getDescricao()));
        }
        if (Optional.ofNullable(entity.getCodigoProtesto()).map(CNAB240CodigoProtesto::getCodigo).orElse(0L).equals(AcaoPosVencimento.PROTESTAR.getCodigo()) && Optional.ofNullable(entity.getDiasProtesto()).filter(diasProtesto -> diasProtesto >= QUANTIDADE_MINIMA_DIAS_PROTESTO && diasProtesto <= QUANTIDADE_MAXIMA_DIAS_PROTESTO).isEmpty()) {
            throw new EloValidationException("O N\u00famero de dias para protesto deve estar entre 2 \u00e0 90");
        }
        if (Optional.ofNullable(entity.getCodigoJuros()).map(CNAB240CodigoJuros::getId).orElse(0L).equals(TipoJurosMora.TAXA_MENSAL.getCodigo()) && !this.isValidPercentual(entity.getValorJurosDiaTaxa())) {
            throw new EloValidationException(String.format(MENSAGEM_ERRO_PERCENTUAL, "de juros"));
        }
        if (Optional.ofNullable(entity.getCodigoMulta()).map(CNAB240CodigoMulta::getId).orElse(0L).equals(TipoMulta.PERCENTUAL.getCodigo()) && !this.isValidPercentual(entity.getValorPercentualMulta())) {
            throw new EloValidationException(String.format(MENSAGEM_ERRO_PERCENTUAL, "de multa"));
        }
        if (Optional.ofNullable(entity.getCodigoDesconto()).map(CNAB240CodigoDesconto::getCodigo).orElse(0L).equals(TIPO_PERCENTUAL_DESCONTO) && !this.isValidPercentual(entity.getValorPercentualDesconto())) {
            throw new EloValidationException(String.format(MENSAGEM_ERRO_PERCENTUAL, "de desconto"));
        }
        if (Optional.ofNullable(entity.getCodigoDesconto2()).map(CNAB240CodigoDesconto::getCodigo).orElse(0L).equals(TIPO_PERCENTUAL_DESCONTO) && !this.isValidPercentual(entity.getValorPercentualDesconto2())) {
            throw new EloValidationException(String.format(MENSAGEM_ERRO_PERCENTUAL, "de desconto 2"));
        }
        if (Optional.ofNullable(entity.getCodigoDesconto3()).map(CNAB240CodigoDesconto::getCodigo).orElse(0L).equals(TIPO_PERCENTUAL_DESCONTO) && !this.isValidPercentual(entity.getValorPercentualDesconto3())) {
            throw new EloValidationException(String.format(MENSAGEM_ERRO_PERCENTUAL, "de desconto 3"));
        }
    }

    private boolean isValidPercentual(BigDecimal percentual) {
        return Objects.nonNull(percentual) && percentual.compareTo(BigDecimal.ZERO) >= 0 && percentual.compareTo(BigDecimal.valueOf(100L)) <= 0;
    }

    @Generated
    public ParametroCNAB240Service(ParametroCNAB240Repository parametroCNAB240Repository) {
        this.parametroCNAB240Repository = parametroCNAB240Repository;
    }
}

