/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.domain.CadastroGeral;
import br.com.elotech.tributos.domain.Contencioso;
import br.com.elotech.tributos.domain.ContenciosoDebito;
import br.com.elotech.tributos.domain.ContenciosoDebitoID;
import br.com.elotech.tributos.domain.ContenciosoDebitoParcela;
import br.com.elotech.tributos.domain.ContenciosoSituacaoEnum;
import br.com.elotech.tributos.domain.DebitoParcela;
import br.com.elotech.tributos.domain.SituacaoContenciosoDebito;
import br.com.elotech.tributos.domain.SituacaoParcela;
import br.com.elotech.tributos.domain.TipoEventoSituacaoParcelaEnum;
import br.com.elotech.tributos.domain.TipoSituacaoParcela;
import br.com.elotech.tributos.dto.CancelamentoDebitoParcelaDTO;
import br.com.elotech.tributos.dto.cancelamento.CancelamentoParcelasFormDTO;
import br.com.elotech.tributos.dto.contencioso.ContenciosoDebitosResponseDTO;
import br.com.elotech.tributos.repository.ContenciosoRepository;
import br.com.elotech.tributos.service.CadastroGeralService;
import br.com.elotech.tributos.service.DebitoParcelaService;
import br.com.elotech.tributos.service.DebitoService;
import br.com.elotech.tributos.service.SituacaoParcelaService;
import br.com.elotech.tributos.service.cancelamento.CancelamentoDebitoService;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.stereotype.Service;

@Service
public class ContenciosoService
extends CrudService<Contencioso, Long> {
    private ContenciosoRepository contenciosoRepository;
    private SituacaoParcelaService situacaoParcelaService;
    private DebitoParcelaService debitoParcelaService;
    private DebitoService debitoService;
    private CadastroGeralService cadastroGeralService;
    private CancelamentoDebitoService cancelamentoDebitoService;

    public Contencioso exarar(ContenciosoDebitosResponseDTO dto, Long id) {
        Contencioso contencioso = Optional.ofNullable((Contencioso)this.findOne((Serializable)id)).orElseThrow(() -> new EloValidationException(String.format("N\u00e3o foi poss\u00edvel encontrar o contencioso com o id %d", id)));
        if (!ContenciosoSituacaoEnum.ABERTO.equals((Object)contencioso.getSituacao())) {
            throw new EloValidationException("Contencioso deve estar com a situa\u00e7\u00e3o ABERTO para poder ser exarado");
        }
        dto.getDebitos().forEach(debitosExarados -> {
            contencioso.getDebitos().forEach(debitosContencioso -> {
                if (debitosExarados.equals(debitosContencioso)) {
                    debitosContencioso.setSituacao(dto.getParecer());
                    CancelamentoParcelasFormDTO cancelamentoDebitosDTO = CancelamentoParcelasFormDTO.from((ContenciosoDebitosResponseDTO)dto);
                    debitosContencioso.getParcelas().forEach(parcela -> {
                        this.updateSituacaoparcelaAntiga(parcela);
                        CancelamentoDebitoParcelaDTO cancelamentoParcelaDTO = CancelamentoDebitoParcelaDTO.from((ContenciosoDebito)debitosContencioso, (ContenciosoDebitoParcela)parcela);
                        cancelamentoDebitosDTO.getParcelas().add(cancelamentoParcelaDTO);
                    });
                    if (SituacaoContenciosoDebito.DEFERIDO.equals((Object)dto.getParecer()) && Boolean.TRUE.equals(contencioso.getTipoContencioso().getCancelamentoAutomatico())) {
                        this.cancelamentoDebitoService.cancelamentoDebitoPorParcela(cancelamentoDebitosDTO);
                    }
                }
            });
            if (contencioso.getDebitos().stream().noneMatch(e -> SituacaoContenciosoDebito.AGUARDANDOPARECER.equals((Object)e.getSituacao()))) {
                contencioso.setSituacao(ContenciosoSituacaoEnum.ENCERRADO);
            }
        });
        return (Contencioso)this.contenciosoRepository.save((Object)contencioso);
    }

    public Contencioso create(ContenciosoDebitosResponseDTO dto) {
        return (Contencioso)this.contenciosoRepository.save((Object)this.createContencioso(dto));
    }

    private Contencioso createContencioso(ContenciosoDebitosResponseDTO dto) {
        Optional cadastroGeral;
        Contencioso contencioso;
        Contencioso contencioso2 = contencioso = Objects.isNull(dto.getId()) ? new Contencioso() : (Contencioso)this.findOne((Serializable)dto.getId());
        if (dto.getDebitos().isEmpty()) {
            throw new EloValidationException("Contencioso deve possuir pelo menos um d\u00e9bito");
        }
        if (this.validateCadastrosIguais(this.getListCadastrosDebitos(dto)) && (cadastroGeral = this.cadastroGeralService.findByTipoCadastroAndCadastroGeral(((ContenciosoDebito)dto.getDebitos().get(0)).getId().getTipoCadastro(), ((ContenciosoDebito)dto.getDebitos().get(0)).getId().getCadastroGeral())).isPresent()) {
            dto.setCadastroGeral((CadastroGeral)cadastroGeral.get());
        }
        Contencioso.from((ContenciosoDebitosResponseDTO)dto, (Contencioso)contencioso);
        Contencioso entidadeSalva = (Contencioso)this.contenciosoRepository.save((Object)contencioso);
        this.updateIdContenciosoDebitos(dto, contencioso, entidadeSalva);
        this.updateSituacaoAntigaDebito(dto, contencioso);
        this.updateSituacaoparcela(contencioso);
        return contencioso;
    }

    private void updateSituacaoAntigaDebito(ContenciosoDebitosResponseDTO dto, Contencioso contencioso) {
        for (ContenciosoDebito contenciosoDebito : contencioso.getDebitos()) {
            if (dto.getDebitos().contains(contenciosoDebito)) continue;
            contenciosoDebito.getParcelas().forEach(parcelas -> this.updateSituacaoparcelaAntiga(parcelas));
            contencioso.getDebitos().remove(contenciosoDebito);
        }
    }

    private Contencioso updateIdContenciosoDebitos(ContenciosoDebitosResponseDTO dto, Contencioso contencioso, Contencioso entidadeSalva) {
        dto.getDebitos().forEach(e -> {
            if (!contencioso.getDebitos().contains(e)) {
                this.vinculandoConteciosoComDebito(contencioso, e);
                e.getId().setIdContencioso(entidadeSalva.getId());
                e.getParcelas().forEach(contenciosoDebitoParcela -> {
                    contenciosoDebitoParcela.getId().setId(entidadeSalva.getId());
                    if (contenciosoDebitoParcela.getSituacaoDebito().getTipoSituacaoParcela().equals((Object)TipoSituacaoParcela.ABERTO)) {
                        SituacaoParcela novaSituacao = this.generateSituacaoParcelaRA(contenciosoDebitoParcela);
                        contenciosoDebitoParcela.setSituacaoAtual(novaSituacao);
                    } else {
                        contenciosoDebitoParcela.setSituacaoAtual(contenciosoDebitoParcela.getSituacaoDebito());
                    }
                });
            }
        });
        return contencioso;
    }

    private void vinculandoConteciosoComDebito(Contencioso contencioso, ContenciosoDebito debito) {
        contencioso.getDebitos().add(debito);
        this.debitoService.findByCompositeKey(debito.getId().getEntidade(), debito.getId().getExercicio(), debito.getId().getTipoCadastro().getValue(), debito.getId().getCadastroGeral(), debito.getId().getDivida(), debito.getId().getSubDivida()).ifPresent(arg_0 -> ((ContenciosoDebito)debito).setDebito(arg_0));
        debito.getDebito().setContencioso(contencioso);
    }

    private SituacaoParcela generateSituacaoParcelaRA(ContenciosoDebitoParcela contenciosoDebitoParcela) {
        return this.situacaoParcelaService.getNovaSituacaoParcela(TipoEventoSituacaoParcelaEnum.RECURSO_ADMINISTRATIVO, contenciosoDebitoParcela.getSituacaoDebito());
    }

    private SituacaoParcela generateSituacaoAntiga(ContenciosoDebitoParcela contenciosoDebitoParcela) {
        TipoEventoSituacaoParcelaEnum situacao = TipoEventoSituacaoParcelaEnum.fromValue((Long)contenciosoDebitoParcela.getSituacaoDebito().getId());
        return this.situacaoParcelaService.getNovaSituacaoParcela(situacao, contenciosoDebitoParcela.getSituacaoAtual());
    }

    private boolean validateCadastrosIguais(List<Long> list) {
        return list.stream().allMatch(list.get(0)::equals);
    }

    private void updateSituacaoparcela(Contencioso contencioso) {
        contencioso.getDebitos().forEach(debito -> debito.getParcelas().forEach(parcela -> {
            Optional debitoParcela = this.debitoParcelaService.findByDebitoParcela(debito.getId().getEntidade(), debito.getId().getExercicio(), debito.getId().getTipoCadastro().getValue(), debito.getId().getCadastroGeral(), debito.getId().getDivida(), debito.getId().getSubDivida(), parcela.getId().getParcela());
            debitoParcela.ifPresent(e -> {
                if (e.getSituacaoDebito().getTipoSituacaoParcela() == TipoSituacaoParcela.ABERTO) {
                    SituacaoParcela novaSituacao = this.generateSituacaoParcelaRA(parcela);
                    e.setSituacaoDebito(novaSituacao);
                    e.setDataSituacao(LocalDate.now());
                    this.debitoParcelaService.save((EloEntity)e, null);
                }
            });
        }));
    }

    private void updateSituacaoparcelaAntiga(ContenciosoDebitoParcela parcela) {
        Optional debitoParcela = this.debitoParcelaService.findByDebitoParcela(parcela.getId().getEntidade(), parcela.getId().getExercicio(), parcela.getId().getTipoCadastro().getValue(), parcela.getId().getCadastroGeral(), parcela.getId().getDivida(), parcela.getId().getSubDivida(), parcela.getId().getParcela());
        debitoParcela.ifPresent(e -> {
            if (parcela.getSituacaoAtual().getTipoSituacaoParcela() == TipoSituacaoParcela.RECURSO_ADMINISTRATIVO) {
                SituacaoParcela novaSituacao = this.generateSituacaoAntiga(parcela);
                e.setSituacaoDebito(novaSituacao);
                e.setDataSituacao(LocalDate.now());
                this.debitoParcelaService.save((EloEntity)((DebitoParcela)debitoParcela.get()), null);
            }
        });
    }

    private List<Long> getListCadastrosDebitos(ContenciosoDebitosResponseDTO contencioso) {
        List<Long> cadastroGeralList = contencioso.getDebitos().stream().map(ContenciosoDebito::getId).map(ContenciosoDebitoID::getCadastroGeral).collect(Collectors.toList());
        return cadastroGeralList;
    }

    @Generated
    public ContenciosoService(ContenciosoRepository contenciosoRepository, SituacaoParcelaService situacaoParcelaService, DebitoParcelaService debitoParcelaService, DebitoService debitoService, CadastroGeralService cadastroGeralService, CancelamentoDebitoService cancelamentoDebitoService) {
        this.contenciosoRepository = contenciosoRepository;
        this.situacaoParcelaService = situacaoParcelaService;
        this.debitoParcelaService = debitoParcelaService;
        this.debitoService = debitoService;
        this.cadastroGeralService = cadastroGeralService;
        this.cancelamentoDebitoService = cancelamentoDebitoService;
    }
}

