/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource.supersimples;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.exception.RestException;
import br.com.elotech.tributos.domain.supersimples.SuperSimplesSolicitacao;
import br.com.elotech.tributos.domain.supersimples.SuperSimplesSolicitacaoCnpj;
import br.com.elotech.tributos.domain.supersimples.SuperSimplesSolicitacaoVarredura;
import br.com.elotech.tributos.dto.supersimples.SuperSimplesSolicitacaoCnaeDTO;
import br.com.elotech.tributos.dto.supersimples.SuperSimplesSolicitacaoCnpjDTO;
import br.com.elotech.tributos.dto.supersimples.SuperSimplesSolicitacaoDTO;
import br.com.elotech.tributos.dto.supersimples.SuperSimplesSolicitacaoVarreduraDTO;
import br.com.elotech.tributos.enums.supersimples.TipoOperacaoSuperSimplesSolicitacao;
import br.com.elotech.tributos.security.SecurityUtils;
import br.com.elotech.tributos.service.supersimples.ImportacaoSuperSimplesJobStarter;
import br.com.elotech.tributos.service.supersimples.ProcessamentoSuperSimplesJobStarter;
import br.com.elotech.tributos.service.supersimples.SuperSimplesSolicitacaoService;
import br.com.elotech.tributos.service.supersimples.SuperSimplesSolicitacaoVarreduraService;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.codec.digest.DigestUtils;
import org.springframework.batch.core.JobParametersInvalidException;
import org.springframework.batch.core.repository.JobExecutionAlreadyRunningException;
import org.springframework.batch.core.repository.JobInstanceAlreadyCompleteException;
import org.springframework.batch.core.repository.JobRestartException;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/api/super-simples"})
public class SuperSimplesSolicitacaoResource {
    private final SuperSimplesSolicitacaoService superSimplesSolicitacaoService;
    private final SuperSimplesSolicitacaoVarreduraService superSimplesSolicitacaoVarreduraService;
    private final ImportacaoSuperSimplesJobStarter importacaoSuperSimplesJobStarter;
    private final ProcessamentoSuperSimplesJobStarter processamentoSuperSimplesJobStarter;

    @PostMapping(value={"/importar"})
    public ResponseEntity<SuperSimplesSolicitacaoDTO> importarSolicitacao(@RequestParam MultipartFile file) throws IOException, JobInstanceAlreadyCompleteException, JobExecutionAlreadyRunningException, JobParametersInvalidException, JobRestartException {
        String fileContent = new String(file.getBytes(), StandardCharsets.UTF_8);
        String hash = DigestUtils.sha256Hex((String)fileContent);
        this.superSimplesSolicitacaoService.findByHash(hash).ifPresent(solicitacaoExistente -> {
            throw new EloValidationException(String.format("Esse arquivo j\u00e1 foi importado na solicita\u00e7\u00e3o %d.", solicitacaoExistente.getId()));
        });
        SuperSimplesSolicitacao superSimplesSolicitacao = this.superSimplesSolicitacaoService.createSolicitacao(file.getOriginalFilename(), SecurityUtils.getUserAise());
        this.superSimplesSolicitacaoService.uploadArquivo(superSimplesSolicitacao, file, hash);
        this.importacaoSuperSimplesJobStarter.startJob(superSimplesSolicitacao);
        return ResponseEntity.ok((Object)SuperSimplesSolicitacaoDTO.from((SuperSimplesSolicitacao)superSimplesSolicitacao));
    }

    @GetMapping
    public ResponseEntity<Page<SuperSimplesSolicitacaoDTO>> search(@RequestParam(value="search", required=false) String search, Pageable pageable) {
        Page result = this.superSimplesSolicitacaoService.findByRsql(search, pageable).map(SuperSimplesSolicitacaoDTO::from);
        return ResponseEntity.ok((Object)result);
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<SuperSimplesSolicitacaoDTO> findOne(@PathVariable(value="id") Long id) {
        return this.superSimplesSolicitacaoService.findById((Serializable)id).map(SuperSimplesSolicitacaoDTO::from).map(ResponseEntity::ok).orElseThrow(RestException::notFound);
    }

    @GetMapping(value={"/{id}/{sequencia}/cnpj"})
    public ResponseEntity<SuperSimplesSolicitacaoCnpjDTO> findOneCnpj(@PathVariable(value="id") Long id, @PathVariable Long sequencia) {
        SuperSimplesSolicitacaoCnpj superSimplesSolicitacaoCnpj = this.superSimplesSolicitacaoService.findCnpjByIdSolicitacaoAndSequencia(id, sequencia);
        return ResponseEntity.ok((Object)SuperSimplesSolicitacaoCnpjDTO.from((SuperSimplesSolicitacaoCnpj)superSimplesSolicitacaoCnpj));
    }

    @GetMapping(value={"/{id}/varreduras"})
    public ResponseEntity<List<SuperSimplesSolicitacaoVarreduraDTO>> findVarreduras(@PathVariable Long id, Sort sort) {
        List superSimplesSolicitacaoVarreduras = this.superSimplesSolicitacaoVarreduraService.findByIdSolicitacao(id, sort);
        return ResponseEntity.ok(superSimplesSolicitacaoVarreduras.stream().map(SuperSimplesSolicitacaoVarreduraDTO::from).collect(Collectors.toList()));
    }

    @GetMapping(value={"/{id}/dados-importados"})
    public ResponseEntity<Page<SuperSimplesSolicitacaoCnpjDTO>> searchDadosImportados(@PathVariable(value="id") Long id, @RequestParam(value="search", required=false) String search, Pageable pageable) {
        Page result = this.superSimplesSolicitacaoService.searchDadosImportados(id, search, pageable);
        return ResponseEntity.ok((Object)result);
    }

    @GetMapping(value={"/{id}/{sequencia}/cnaes"})
    public ResponseEntity<List<SuperSimplesSolicitacaoCnaeDTO>> findCnaes(@PathVariable Long id, @PathVariable Long sequencia, Sort sort) {
        List superSimplesSolicitacaoCnaes = this.superSimplesSolicitacaoService.findCnaesByIdSolicitacaoAndSequencia(id, sequencia, sort);
        return ResponseEntity.ok(superSimplesSolicitacaoCnaes.stream().map(SuperSimplesSolicitacaoCnaeDTO::from).collect(Collectors.toList()));
    }

    @GetMapping(value={"/url-arquivo-super-simples/{uuid}"})
    public ResponseEntity<String> getUrlArquivoVarredura(@PathVariable UUID uuid) {
        return ResponseEntity.ok((Object)this.superSimplesSolicitacaoVarreduraService.getUrlArquivoVarredura(uuid));
    }

    @PostMapping(value={"/{idSolicitacao}/gerar-complementar"})
    public ResponseEntity<SuperSimplesSolicitacaoVarreduraDTO> gerarArquivoComplementar(@PathVariable(value="idSolicitacao") Long idSolicitacao) throws JobInstanceAlreadyCompleteException, JobExecutionAlreadyRunningException, JobParametersInvalidException, JobRestartException {
        SuperSimplesSolicitacaoVarredura superSimplesSolicitacaoVarredura = this.superSimplesSolicitacaoVarreduraService.createVarredura(idSolicitacao, SecurityUtils.getUserAise(), TipoOperacaoSuperSimplesSolicitacao.COMPLEMENTAR);
        this.processamentoSuperSimplesJobStarter.startJob(superSimplesSolicitacaoVarredura);
        return ResponseEntity.ok((Object)SuperSimplesSolicitacaoVarreduraDTO.from((SuperSimplesSolicitacaoVarredura)superSimplesSolicitacaoVarredura));
    }

    @PostMapping(value={"/{idSolicitacao}/gerar-exclusao"})
    public ResponseEntity<SuperSimplesSolicitacaoVarreduraDTO> gerarArquivoExclusao(@PathVariable(value="idSolicitacao") Long idSolicitacao) throws JobInstanceAlreadyCompleteException, JobExecutionAlreadyRunningException, JobParametersInvalidException, JobRestartException {
        SuperSimplesSolicitacaoVarredura superSimplesSolicitacaoVarredura = this.superSimplesSolicitacaoVarreduraService.createVarredura(idSolicitacao, SecurityUtils.getUserAise(), TipoOperacaoSuperSimplesSolicitacao.EXCLUSAO);
        this.processamentoSuperSimplesJobStarter.startJob(superSimplesSolicitacaoVarredura);
        return ResponseEntity.ok((Object)SuperSimplesSolicitacaoVarreduraDTO.from((SuperSimplesSolicitacaoVarredura)superSimplesSolicitacaoVarredura));
    }

    @Generated
    public SuperSimplesSolicitacaoResource(SuperSimplesSolicitacaoService superSimplesSolicitacaoService, SuperSimplesSolicitacaoVarreduraService superSimplesSolicitacaoVarreduraService, ImportacaoSuperSimplesJobStarter importacaoSuperSimplesJobStarter, ProcessamentoSuperSimplesJobStarter processamentoSuperSimplesJobStarter) {
        this.superSimplesSolicitacaoService = superSimplesSolicitacaoService;
        this.superSimplesSolicitacaoVarreduraService = superSimplesSolicitacaoVarreduraService;
        this.importacaoSuperSimplesJobStarter = importacaoSuperSimplesJobStarter;
        this.processamentoSuperSimplesJobStarter = processamentoSuperSimplesJobStarter;
    }
}

