/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource.simam;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.utils.DateUtils;
import br.com.elotech.tributos.dto.simam.manutencaoarquivo.BaseArquivoSimAmDTO;
import br.com.elotech.tributos.enums.TipoRegistroSimAm;
import br.com.elotech.tributos.service.batch.simam.AtribuirNrCreditoNrDividaJobStarter;
import br.com.elotech.tributos.service.simam.conferencia.manutencaoarquivo.AtribuirNrCreditoService;
import br.com.elotech.tributos.service.simam.conferencia.manutencaoarquivo.AtribuirNrDividaService;
import br.com.elotech.tributos.service.simam.conferencia.manutencaoarquivo.ManutencaoArquivoSimAmFactory;
import br.com.elotech.tributos.service.simam.conferencia.manutencaoarquivo.ManutencaoArquivoSimAmService;
import java.time.LocalDate;
import java.time.temporal.TemporalAdjusters;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/manutencao-arquivo-sim-am"})
public class ManutencaoArquivoSimAmResource {
    @Autowired
    private ManutencaoArquivoSimAmFactory manutencaoArquivoSimAmFactory;
    @Autowired
    private AtribuirNrCreditoService atribuirNrCreditoService;
    @Autowired
    private AtribuirNrDividaService atribuirNrDividaService;
    @Autowired
    private AtribuirNrCreditoNrDividaJobStarter jobStarter;

    @GetMapping
    public ResponseEntity<Page<BaseArquivoSimAmDTO>> findArquivos(@RequestParam(value="exercicio") Long exercicio, @RequestParam(value="competencia") Long competencia, @RequestParam(value="tipo-registro") Long tipoRegistroSimAm, @RequestParam(value="search", defaultValue="", required=false) String search, Pageable pageable) {
        ManutencaoArquivoSimAmService service = this.manutencaoArquivoSimAmFactory.getService(TipoRegistroSimAm.getByCodigo((Long)tipoRegistroSimAm));
        LocalDate dataInicial = LocalDate.of(exercicio.intValue(), competencia.intValue(), DateUtils.firstDayOfMonth((int)competencia.intValue(), (int)exercicio.intValue()).getDayOfMonth());
        LocalDate dataFinal = LocalDate.of(exercicio.intValue(), competencia.intValue(), DateUtils.lastDayOfMonth((int)competencia.intValue(), (int)exercicio.intValue()).getDayOfMonth());
        return ResponseEntity.ok((Object)service.find(search, dataInicial, dataFinal, pageable));
    }

    @PutMapping
    public ResponseEntity<List<BaseArquivoSimAmDTO>> updateArquivos(@RequestBody List<BaseArquivoSimAmDTO> arquivos) {
        ManutencaoArquivoSimAmService service = this.manutencaoArquivoSimAmFactory.getService(((BaseArquivoSimAmDTO)arquivos.stream().findFirst().orElseThrow(() -> new EloValidationException("A lista de arquivos a serem alterados n\u00e3o pode estar vazia."))).getTipoRegistroSimAm());
        List baseArquivoSimAmDTOS = service.updateAll(arquivos);
        if (baseArquivoSimAmDTOS.stream().anyMatch(BaseArquivoSimAmDTO::hasError)) {
            return ResponseEntity.badRequest().body((Object)baseArquivoSimAmDTOS);
        }
        return ResponseEntity.ok((Object)baseArquivoSimAmDTOS);
    }

    @PutMapping(value={"/update-nrcredito"})
    public ResponseEntity<Void> update(@RequestBody BaseArquivoSimAmDTO arquivo) {
        this.atribuirNrCreditoService.atribuirNrCredito(arquivo);
        return ResponseEntity.ok().build();
    }

    @PutMapping(value={"/update-nrdivida"})
    public ResponseEntity<Void> findAndSetNrDivida(@RequestBody BaseArquivoSimAmDTO registro) {
        this.atribuirNrDividaService.atribuirNrDivida(registro);
        return ResponseEntity.ok().build();
    }

    @PutMapping(value={"/job/atribuir-nrcredito-nrdivida/start"})
    public ResponseEntity<Void> findAndSetNrDividaBatch(@RequestParam(value="exercicio") Long exercicio, @RequestParam(value="competencia") Long competencia, @RequestParam(value="tipo-registro", required=false) Long tipoRegistroSimAmCode) {
        LocalDate dataInicial = LocalDate.of(exercicio.intValue(), competencia.intValue(), 1);
        LocalDate dataFinal = dataInicial.with(TemporalAdjusters.lastDayOfMonth());
        TipoRegistroSimAm tipoRegistroSimAm = TipoRegistroSimAm.getByCodigo((Long)tipoRegistroSimAmCode);
        this.jobStarter.start(dataInicial, dataFinal, tipoRegistroSimAm);
        return ResponseEntity.ok().build();
    }
}

