/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource.projeto;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.resource.support.CrudResource;
import br.com.elotech.tributos.domain.projeto.Projeto;
import br.com.elotech.tributos.domain.projeto.ProjetoPK;
import br.com.elotech.tributos.dto.DebitoIdDTO;
import br.com.elotech.tributos.dto.DebitoManualParcelaDTO;
import br.com.elotech.tributos.dto.DebitoProjetoManualDTO;
import br.com.elotech.tributos.dto.ImpressaoDTO;
import br.com.elotech.tributos.dto.IntegracaoProjetoIssResponse;
import br.com.elotech.tributos.dto.projeto.ProjetoDTO;
import br.com.elotech.tributos.dto.projeto.ProjetoRowDTO;
import br.com.elotech.tributos.enums.TipoAcaoAtendimento;
import br.com.elotech.tributos.service.HistoricoAtendimentoService;
import br.com.elotech.tributos.service.projeto.ProjetoService;
import java.io.Serializable;
import java.util.List;
import javax.validation.Valid;
import lombok.Generated;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/projeto"})
public class ProjetoResource
extends CrudResource<Projeto, ProjetoPK> {
    private final ProjetoService projetoService;
    private final HistoricoAtendimentoService historicoAtendimentoService;

    @PostMapping
    public ResponseEntity<Projeto> save(@RequestBody @Valid Projeto projeto, Authentication authentication) {
        Projeto projetoSaved = (Projeto)this.projetoService.save((EloEntity)projeto, authentication);
        this.historicoAtendimentoService.createHistoricoAtendimento(String.format("Projeto criado %s/%s", projetoSaved.getId().getProjeto(), projetoSaved.getId().getExercicio()), TipoAcaoAtendimento.GERACAO_PROJETO);
        return ResponseEntity.ok((Object)projetoSaved);
    }

    @GetMapping(value={"/row-dto"})
    public ResponseEntity<Page<ProjetoRowDTO>> findAllProjetoRowDTOS(@RequestParam(value="search", required=false) String search, Pageable pageable) {
        return ResponseEntity.ok((Object)this.projetoService.findByRsqlProjetoRowDTOS(search, pageable));
    }

    @GetMapping(value={"/dto/{entidade}/{exercicio}/{projeto}"})
    public ResponseEntity<ProjetoDTO> findOneProjetoDTO(@PathVariable Long entidade, @PathVariable Long exercicio, @PathVariable Long projeto) {
        ProjetoPK id = ProjetoPK.from((Long)entidade, (Long)exercicio, (Long)projeto);
        return ResponseEntity.ok((Object)this.projetoService.findOneProjetoDTO(id));
    }

    @GetMapping(value={"/id/{entidade}/{exercicio}/{projeto}"})
    public ResponseEntity<Projeto> findOne(@PathVariable Long entidade, @PathVariable Long exercicio, @PathVariable Long projeto) {
        ProjetoPK id = ProjetoPK.from((Long)entidade, (Long)exercicio, (Long)projeto);
        return ResponseEntity.ok((Object)((Projeto)this.projetoService.findOne((Serializable)id)));
    }

    @PutMapping(value={"/id/{entidade}/{exercicio}/{projeto}"})
    public ResponseEntity<Projeto> update(@RequestBody @Valid Projeto projetoObj, @PathVariable(value="entidade") Long entidade, @PathVariable(value="exercicio") Long exercicio, @PathVariable(value="projeto") Long projeto, Authentication authentication) {
        ProjetoPK id = ProjetoPK.from((Long)entidade, (Long)exercicio, (Long)projeto);
        return this.update((EloEntity)projetoObj, (Serializable)id, authentication);
    }

    @GetMapping(value={"/by-protocolo"})
    public ResponseEntity<List<IntegracaoProjetoIssResponse>> findProjetoByProcessoAndExercicio(@RequestParam Long idProcesso, @RequestParam Long exercicio) {
        List projeto = this.projetoService.findProjetoIntegracao(idProcesso, exercicio);
        return ResponseEntity.ok((Object)projeto);
    }

    @PostMapping(value={"/debito-manual"})
    public ResponseEntity<DebitoIdDTO> generateDebitoManual(@RequestBody @Valid DebitoProjetoManualDTO debitoProjetoManualDTO) {
        return ResponseEntity.ok((Object)this.projetoService.generateDebitoManual(debitoProjetoManualDTO));
    }

    @PostMapping(value={"/simulate-debito-manual"})
    public ResponseEntity<List<DebitoManualParcelaDTO>> simulateDebitoManual(@RequestBody @Valid DebitoProjetoManualDTO debitoProjetoManualDTO) {
        return ResponseEntity.ok((Object)this.projetoService.simulateDebitoManual(debitoProjetoManualDTO));
    }

    @PostMapping(value={"/gera-carne-debito-projeto"})
    public ImpressaoDTO geraCarneDebitoProjeto(@RequestBody @Valid DebitoIdDTO debitoIdDTO) {
        return this.projetoService.geraCarneDebitoProjeto(debitoIdDTO);
    }

    @Generated
    public ProjetoResource(ProjetoService projetoService, HistoricoAtendimentoService historicoAtendimentoService) {
        this.projetoService = projetoService;
        this.historicoAtendimentoService = historicoAtendimentoService;
    }
}

