/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource.integracaoelogeo;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.dto.integracaoelogeo.TipoSegmentoElogeoDTO;
import br.com.elotech.tributos.service.TipoSegmentoService;
import io.swagger.v3.oas.annotations.Operation;
import java.io.Serializable;
import org.springdoc.api.annotations.ParameterObject;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/elogeo/tipo-segmento"})
public class TipoSegmentoElogeoResource {
    private final TipoSegmentoService tipoSegmentoService;

    public TipoSegmentoElogeoResource(TipoSegmentoService tipoSegmentoService) {
        this.tipoSegmentoService = tipoSegmentoService;
    }

    @Operation(summary="Retorna uma lista de tipos de segmento")
    @GetMapping
    public ResponseEntity<Page<TipoSegmentoElogeoDTO>> findAll(@ParameterObject Pageable page) {
        Page segmentos = this.tipoSegmentoService.findAll(page).map(TipoSegmentoElogeoDTO::from);
        return ResponseEntity.ok((Object)segmentos);
    }

    @Operation(summary="Retorna um tipo de segmento em espec\u00edfico")
    @GetMapping(value={"/{id}"})
    public ResponseEntity<TipoSegmentoElogeoDTO> findById(@PathVariable Long id) {
        TipoSegmentoElogeoDTO tipoSegmentoElogeoDTO = this.tipoSegmentoService.findById((Serializable)id).map(TipoSegmentoElogeoDTO::from).orElseThrow(() -> new EloValidationException(String.format("N\u00e3o foi poss\u00edvel encontrar o Tipo Segmento com o id '%d'.", id)));
        return ResponseEntity.ok((Object)tipoSegmentoElogeoDTO);
    }
}

