/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource.integracaoelogeo;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.dto.integracaoelogeo.SituacaoSegmentoImobElogeoDTO;
import br.com.elotech.tributos.service.SituacaoSegmentoImobService;
import io.swagger.v3.oas.annotations.Operation;
import java.io.Serializable;
import org.springdoc.api.annotations.ParameterObject;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/elogeo/situacao-segmento"})
public class SituacaoSegmentoImobElogeoResource {
    private final SituacaoSegmentoImobService situacaoSegmentoImobService;

    public SituacaoSegmentoImobElogeoResource(SituacaoSegmentoImobService situacaoSegmentoImobService) {
        this.situacaoSegmentoImobService = situacaoSegmentoImobService;
    }

    @Operation(summary="Retorna a lista das situa\u00e7\u00f5es de segmentos do cadastro imobili\u00e1rio")
    @GetMapping
    public ResponseEntity<Page<SituacaoSegmentoImobElogeoDTO>> findAll(@ParameterObject Pageable page) {
        Page segmentos = this.situacaoSegmentoImobService.findAll(page).map(SituacaoSegmentoImobElogeoDTO::from);
        return ResponseEntity.ok((Object)segmentos);
    }

    @Operation(summary="Retorna um situa\u00e7\u00e3o de segmento em espec\u00edfico")
    @GetMapping(value={"/{id}"})
    public ResponseEntity<SituacaoSegmentoImobElogeoDTO> findById(@PathVariable Long id) {
        SituacaoSegmentoImobElogeoDTO situacaoSegmentoImobElogeoDTO = this.situacaoSegmentoImobService.findById((Serializable)id).map(SituacaoSegmentoImobElogeoDTO::from).orElseThrow(() -> new EloValidationException(String.format("N\u00e3o foi poss\u00edvel encontrar a Situa\u00e7\u00e3o do Segmento com o id '%d'.", id)));
        return ResponseEntity.ok((Object)situacaoSegmentoImobElogeoDTO);
    }
}

