/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource.integracaoelogeo;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.dto.integracaoelogeo.SituacaoMobiliarioElogeoDTO;
import br.com.elotech.tributos.service.SituacaoMobiliarioService;
import io.swagger.v3.oas.annotations.Operation;
import java.io.Serializable;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/elogeo/situacao-mobiliario"})
public class SituacaoMobiliarioElogeoResource {
    private final SituacaoMobiliarioService situacaoMobiliarioService;

    public SituacaoMobiliarioElogeoResource(SituacaoMobiliarioService situacaoMobiliarioService) {
        this.situacaoMobiliarioService = situacaoMobiliarioService;
    }

    @Operation(summary="Retorna uma lista de situa\u00e7\u00f5es do cadastro mobili\u00e1rio")
    @GetMapping
    public ResponseEntity<Page<SituacaoMobiliarioElogeoDTO>> findAll(Pageable page) {
        Page situacoes = this.situacaoMobiliarioService.findAll(page).map(SituacaoMobiliarioElogeoDTO::from);
        return ResponseEntity.ok((Object)situacoes);
    }

    @Operation(summary="Retorna uma situa\u00e7\u00e3o dos cadastros imobili\u00e1rios em espec\u00edfico")
    @GetMapping(value={"/{id}"})
    public ResponseEntity<SituacaoMobiliarioElogeoDTO> findById(@PathVariable Long id) {
        SituacaoMobiliarioElogeoDTO situacaoMobiliarioElogeoDTO = this.situacaoMobiliarioService.findById((Serializable)id).map(SituacaoMobiliarioElogeoDTO::from).orElseThrow(() -> new EloValidationException(String.format("N\u00e3o foi poss\u00edvel encontrar a situa\u00e7\u00e3o do mobili\u00e1rio com o id '%d'.", id)));
        return ResponseEntity.ok((Object)situacaoMobiliarioElogeoDTO);
    }
}

