/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource.integracaoelogeo;

import br.com.elotech.tributos.dto.integracaoelogeo.CadastroRuralElogeoDTO;
import br.com.elotech.tributos.dto.integracaoelogeo.CadastroRuralExistsElogeoDTO;
import br.com.elotech.tributos.dto.integracaoelogeo.CadastroRuralPostElogeoDTO;
import br.com.elotech.tributos.service.integracaoelogeo.CadastroRuralElogeo;
import io.swagger.v3.oas.annotations.Operation;
import java.net.URI;
import javax.validation.Valid;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/elogeo/cadastro/rural"})
public class CadastroRuralElogeoResource {
    private final CadastroRuralElogeo CadastroRuralElogeo;

    public CadastroRuralElogeoResource(CadastroRuralElogeo cadastroRuralElogeo) {
        this.CadastroRuralElogeo = cadastroRuralElogeo;
    }

    @Operation(summary="Retorna uma lista de todos os cadastros rurais")
    @GetMapping
    public ResponseEntity<Page<CadastroRuralElogeoDTO>> findAllDTO(Pageable page, @RequestParam(value="search", defaultValue="", required=false) String search) {
        return ResponseEntity.ok((Object)this.CadastroRuralElogeo.findAllElogeoDTO(page, search));
    }

    @Operation(summary="Retorna um cadastro Rural em espec\u00edfico")
    @GetMapping(value={"/{cadastroGeral}"})
    public ResponseEntity<CadastroRuralElogeoDTO> findByCadastroGeralElogeoDTO(@PathVariable Long cadastroGeral) {
        return ResponseEntity.ok((Object)this.CadastroRuralElogeo.findByCadastroGeralElogeoDTO(cadastroGeral));
    }

    @Operation(summary="Retorna se um cadastro rural em espec\u00edfico existe")
    @GetMapping(value={"/{cadastroGeral}/exists"})
    public ResponseEntity<CadastroRuralExistsElogeoDTO> exists(@PathVariable Long cadastroGeral) {
        return ResponseEntity.ok((Object)this.CadastroRuralElogeo.exists(cadastroGeral));
    }

    @Operation(summary="Altera um cadastro rural existente")
    @PutMapping(value={"/{cadastroGeral}"})
    public ResponseEntity<CadastroRuralElogeoDTO> update(@PathVariable Long cadastroGeral, @RequestBody @Valid CadastroRuralPostElogeoDTO cadastroRuralPostEloGeoDTO) {
        return ResponseEntity.ok((Object)this.CadastroRuralElogeo.saveElogeoDTO(cadastroRuralPostEloGeoDTO, Boolean.FALSE, cadastroGeral));
    }

    @Operation(summary="Grava um novo cadastro rural")
    @PostMapping
    public ResponseEntity<CadastroRuralElogeoDTO> save(@RequestBody @Valid CadastroRuralPostElogeoDTO cadastroRuralPostEloGeoDTO) {
        return ResponseEntity.created((URI)URI.create("")).body((Object)this.CadastroRuralElogeo.saveElogeoDTO(cadastroRuralPostEloGeoDTO, Boolean.TRUE, null));
    }
}

