/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource.contribuicaomelhoria;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.resource.support.CrudResource;
import br.com.elotech.tributos.domain.contribuicaomelhoria.MelhoriaEdital;
import br.com.elotech.tributos.domain.contribuicaomelhoria.id.MelhoriaEditalId;
import br.com.elotech.tributos.dto.contribuicaomelhoria.MelhoriaCadastroDTO;
import br.com.elotech.tributos.dto.contribuicaomelhoria.MelhoriaCadastroRequest;
import br.com.elotech.tributos.dto.contribuicaomelhoria.MelhoriaEditalDTO;
import br.com.elotech.tributos.service.contribuicaomelhoria.MelhoriaEditalService;
import java.io.Serializable;
import java.util.Objects;
import javax.validation.Valid;
import lombok.Generated;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/contribuicao-melhoria"})
public class MelhoriaEditalResource
extends CrudResource<MelhoriaEdital, MelhoriaEditalId> {
    private final MelhoriaEditalService melhoriaEditalService;

    @GetMapping(value={"/dto"})
    public ResponseEntity<Page<MelhoriaEditalDTO>> findAllMelhoriaEditalDTO(@RequestParam(value="search", required=false) String search, Pageable pageable) {
        Page page = Objects.requireNonNull((Page)this.findAll(search, pageable).getBody());
        return ResponseEntity.ok((Object)page.map(MelhoriaEditalDTO::fromWithoutLists));
    }

    @GetMapping(value={"/dto/{entidade}/{exercicio}/{numeroEdital}"})
    public ResponseEntity<MelhoriaEditalDTO> findOneMelhoriaEditalDTO(@PathVariable(value="entidade") Long entidade, @PathVariable(value="exercicio") Long exercicio, @PathVariable(value="numeroEdital") Long numeroEdital) {
        MelhoriaEditalId id = MelhoriaEditalId.from((Long)entidade, (Long)exercicio, (Long)numeroEdital);
        MelhoriaEdital found = Objects.requireNonNull((MelhoriaEdital)this.findOne((Serializable)id).getBody());
        return ResponseEntity.ok((Object)MelhoriaEditalDTO.from((MelhoriaEdital)found));
    }

    @PostMapping(value={"/dto"})
    public ResponseEntity<MelhoriaEditalDTO> save(@RequestBody @Valid MelhoriaEditalDTO dto, Authentication authentication) {
        MelhoriaEdital saved = Objects.requireNonNull((MelhoriaEdital)this.save((EloEntity)dto.toEntity(), authentication).getBody());
        return ResponseEntity.ok((Object)MelhoriaEditalDTO.from((MelhoriaEdital)saved));
    }

    @PutMapping(value={"/dto/{entidade}/{exercicio}/{numeroEdital}"})
    public ResponseEntity<MelhoriaEditalDTO> update(@RequestBody @Valid MelhoriaEditalDTO dto, @PathVariable(value="entidade") Long entidade, @PathVariable(value="exercicio") Long exercicio, @PathVariable(value="numeroEdital") Long numeroEdital, Authentication authentication) {
        MelhoriaEditalId id = MelhoriaEditalId.from((Long)entidade, (Long)exercicio, (Long)numeroEdital);
        MelhoriaEdital saved = Objects.requireNonNull((MelhoriaEdital)this.update((EloEntity)dto.toEntity(), (Serializable)id, authentication).getBody());
        return ResponseEntity.ok((Object)MelhoriaEditalDTO.from((MelhoriaEdital)saved));
    }

    @PostMapping(value={"/find-cadastros"})
    public ResponseEntity<Page<MelhoriaCadastroDTO>> findCadastros(@RequestBody @Valid MelhoriaCadastroRequest request, Pageable pageable) {
        return ResponseEntity.ok((Object)this.melhoriaEditalService.findCadastros(request, pageable));
    }

    @PostMapping(value={"/save-cadastros"})
    public ResponseEntity<Void> saveCadastros(@RequestBody @Valid MelhoriaCadastroRequest request) {
        this.melhoriaEditalService.saveCadastros(request);
        return ResponseEntity.ok().build();
    }

    @Generated
    public MelhoriaEditalResource(MelhoriaEditalService melhoriaEditalService) {
        this.melhoriaEditalService = melhoriaEditalService;
    }
}

