/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource;

import br.com.elotech.core.resource.support.CrudResource;
import br.com.elotech.tributos.domain.Entidade;
import br.com.elotech.tributos.dto.EntidadeDTO;
import br.com.elotech.tributos.service.impl.EntidadeServiceImpl;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Optional;
import javax.imageio.ImageIO;
import org.apache.tomcat.util.http.fileupload.ByteArrayOutputStream;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/entidades"})
public class EntidadeResource
extends CrudResource<Entidade, Long> {
    private final EntidadeServiceImpl entidadeService;

    public EntidadeResource(EntidadeServiceImpl entidadeService) {
        this.entidadeService = entidadeService;
    }

    @GetMapping(value={"/principal/brasao"}, produces={"image/jpeg"})
    public ResponseEntity<byte[]> getBrasaoPrincipal() throws IOException {
        Optional entidadePrincipal = this.entidadeService.getEntidadePrincipal();
        if (entidadePrincipal.isPresent()) {
            if (((Entidade)entidadePrincipal.get()).getBrasao() == null) {
                return ResponseEntity.notFound().build();
            }
            BufferedImage bufferedImage = ImageIO.read(new ByteArrayInputStream(((Entidade)entidadePrincipal.get()).getBrasao()));
            ByteArrayOutputStream outputJpg = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)bufferedImage, "jpg", (OutputStream)outputJpg);
            return ResponseEntity.ok((Object)outputJpg.toByteArray());
        }
        return ResponseEntity.notFound().build();
    }

    @GetMapping(value={"/principal/entidade"})
    public ResponseEntity<Entidade> getEntidadePrincipal() {
        Optional entidadePrincipal = this.entidadeService.getEntidadePrincipal();
        return entidadePrincipal.map(ResponseEntity::ok).orElseGet(() -> ResponseEntity.notFound().build());
    }

    @GetMapping(value={"/principal/entidade/info"})
    public ResponseEntity<EntidadeDTO> getInfoEntidadePrincipal() {
        Optional entidadeInfo = this.entidadeService.getInfoEntidadePrincipal();
        return entidadeInfo.map(ResponseEntity::ok).orElseGet(() -> ResponseEntity.notFound().build());
    }
}

