/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto.transferenciadebito;

import br.com.elotech.tributos.dto.SituacaoLegal;
import br.com.elotech.tributos.util.MultiValueFilter;
import java.time.LocalDate;
import java.util.Objects;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;

public class FiltroTDDebitoParcelaDTO {
    @NotNull(message="Deve ser informado o tipo de cadastro")
    private @NotNull(message="Deve ser informado o tipo de cadastro") Long tipoCadastro;
    @NotNull(message="Deve ser informado o c\u00f3digo do cadastro")
    private @NotNull(message="Deve ser informado o c\u00f3digo do cadastro") Long cadastroGeral;
    private String exercicio;
    private String divida;
    private String subDivida;
    private String parcela;
    private SituacaoLegal situacaoLegal;
    private LocalDate dataLancamentoInicial;
    private LocalDate dataLancamentoFinal;
    private LocalDate dataVencimentoInicial;
    private LocalDate dataVencimentoFinal;
    private Boolean permiteTransferirDebitosReparcelado = Boolean.FALSE;
    private static final String AND = " and ";
    private static final String TIPO_CADASTRO = "tipoCadastro";
    private static final String CADASTRO_GERAL = "cadastroGeral";
    private static final String SITUACAO_LEGAL = "situacaoLegal";
    private static final String DATA_LANCAMENTO_INICIAL = "dataLancamentoInicial";
    private static final String DATA_LANCAMENTO_FINAL = "dataLancamentoFinal";
    private static final String DATA_VENCIMENTO_INICIAL = "dataVencimentoInicial";
    private static final String DATA_VENCIMENTO_FINAL = "dataVencimentoFinal";

    public String buildWhere() {
        StringBuilder where = new StringBuilder();
        this.appendNotParceladoAndNotReparcelado(where);
        this.appendTipoCadastro(where);
        this.appendCadastroGeral(where);
        this.appendExercicio(where);
        this.appendDivida(where);
        this.appendSubDivida(where);
        this.appendParcela(where);
        this.appendSituacaoLegal(where);
        this.appendDataLancamentoInicial(where);
        this.appendDataLancamentoFinal(where);
        this.appendDataVencimentoInicial(where);
        this.appendDataVencimentoFinal(where);
        return where.toString();
    }

    public MapSqlParameterSource buildParams() {
        MapSqlParameterSource params = new MapSqlParameterSource();
        this.addValueTipoCadastro(params);
        this.addValueCadastroGeral(params);
        this.addValueSituacaoLegal(params);
        this.addValueDataLancamentoInicial(params);
        this.addValueDataLancamentoFinal(params);
        this.addValueDataVencimentoInicial(params);
        this.addValueDataVencimentoFinal(params);
        return params;
    }

    private String addAnd(String clause) {
        return AND + clause;
    }

    private void appendNotParceladoAndNotReparcelado(StringBuilder where) {
        if (Boolean.TRUE.equals(this.permiteTransferirDebitosReparcelado)) {
            return;
        }
        where.append(this.addAnd("((tribdebito.parcelado is null or tribdebito.parcelado <> 'S') and (tribdebito.reparcelado is null or tribdebito.reparcelado <> 'S'))"));
    }

    private void appendTipoCadastro(StringBuilder where) {
        where.append(this.addAnd(String.format("tribdebitoparcela.tipocadastro = :%s", TIPO_CADASTRO)));
    }

    private void appendCadastroGeral(StringBuilder where) {
        where.append(this.addAnd(String.format("tribdebitoparcela.cadastroGeral = :%s", CADASTRO_GERAL)));
    }

    private void appendExercicio(StringBuilder where) {
        if (StringUtils.isBlank((CharSequence)this.exercicio)) {
            return;
        }
        where.append(this.addAnd(MultiValueFilter.generateFilters((String)this.exercicio, (String)"tribdebitoparcela.exercicio")));
    }

    private void appendDivida(StringBuilder where) {
        if (StringUtils.isBlank((CharSequence)this.divida)) {
            return;
        }
        where.append(this.addAnd(MultiValueFilter.generateFilters((String)this.divida, (String)"tribdebitoparcela.guiarecolhimento")));
    }

    private void appendSubDivida(StringBuilder where) {
        if (StringUtils.isBlank((CharSequence)this.subDivida)) {
            return;
        }
        where.append(this.addAnd(MultiValueFilter.generateFilters((String)this.subDivida, (String)"tribdebitoparcela.subdivida")));
    }

    private void appendParcela(StringBuilder where) {
        if (StringUtils.isBlank((CharSequence)this.parcela)) {
            return;
        }
        where.append(this.addAnd(MultiValueFilter.generateFilters((String)this.parcela, (String)"tribdebitoparcela.parcela")));
    }

    private void appendSituacaoLegal(StringBuilder where) {
        if (Objects.isNull(this.situacaoLegal)) {
            return;
        }
        where.append(this.addAnd(String.format("tribdebitoparcela.situacaolegal = :%s", SITUACAO_LEGAL)));
    }

    private void appendDataLancamentoInicial(StringBuilder where) {
        if (Objects.isNull(this.dataLancamentoInicial)) {
            return;
        }
        where.append(this.addAnd(String.format("tribdebitoparcela.datalancamento >= :%s", DATA_LANCAMENTO_INICIAL)));
    }

    private void appendDataLancamentoFinal(StringBuilder where) {
        if (Objects.isNull(this.dataLancamentoFinal)) {
            return;
        }
        where.append(this.addAnd(String.format("tribdebitoparcela.datalancamento <= :%s", DATA_LANCAMENTO_FINAL)));
    }

    private void appendDataVencimentoInicial(StringBuilder where) {
        if (Objects.isNull(this.dataVencimentoInicial)) {
            return;
        }
        where.append(this.addAnd(String.format("tribdebitoparcela.datavencimento >= :%s", DATA_VENCIMENTO_INICIAL)));
    }

    private void appendDataVencimentoFinal(StringBuilder where) {
        if (Objects.isNull(this.dataVencimentoFinal)) {
            return;
        }
        where.append(this.addAnd(String.format("tribdebitoparcela.datavencimento <= :%s", DATA_VENCIMENTO_FINAL)));
    }

    private void addValueTipoCadastro(MapSqlParameterSource params) {
        params.addValue(TIPO_CADASTRO, (Object)this.tipoCadastro);
    }

    private void addValueCadastroGeral(MapSqlParameterSource params) {
        params.addValue(CADASTRO_GERAL, (Object)this.cadastroGeral);
    }

    private void addValueSituacaoLegal(MapSqlParameterSource params) {
        if (Objects.isNull(this.situacaoLegal)) {
            return;
        }
        params.addValue(SITUACAO_LEGAL, (Object)this.situacaoLegal.getCodigo());
    }

    private void addValueDataLancamentoInicial(MapSqlParameterSource params) {
        if (Objects.isNull(this.dataLancamentoInicial)) {
            return;
        }
        params.addValue(DATA_LANCAMENTO_INICIAL, (Object)this.dataLancamentoInicial);
    }

    private void addValueDataLancamentoFinal(MapSqlParameterSource params) {
        if (Objects.isNull(this.dataLancamentoFinal)) {
            return;
        }
        params.addValue(DATA_LANCAMENTO_FINAL, (Object)this.dataLancamentoFinal);
    }

    private void addValueDataVencimentoInicial(MapSqlParameterSource params) {
        if (Objects.isNull(this.dataVencimentoInicial)) {
            return;
        }
        params.addValue(DATA_VENCIMENTO_INICIAL, (Object)this.dataVencimentoInicial);
    }

    private void addValueDataVencimentoFinal(MapSqlParameterSource params) {
        if (Objects.isNull(this.dataVencimentoFinal)) {
            return;
        }
        params.addValue(DATA_VENCIMENTO_FINAL, (Object)this.dataVencimentoFinal);
    }

    @Generated
    public FiltroTDDebitoParcelaDTO() {
    }

    @Generated
    public Long getTipoCadastro() {
        return this.tipoCadastro;
    }

    @Generated
    public Long getCadastroGeral() {
        return this.cadastroGeral;
    }

    @Generated
    public String getExercicio() {
        return this.exercicio;
    }

    @Generated
    public String getDivida() {
        return this.divida;
    }

    @Generated
    public String getSubDivida() {
        return this.subDivida;
    }

    @Generated
    public String getParcela() {
        return this.parcela;
    }

    @Generated
    public SituacaoLegal getSituacaoLegal() {
        return this.situacaoLegal;
    }

    @Generated
    public LocalDate getDataLancamentoInicial() {
        return this.dataLancamentoInicial;
    }

    @Generated
    public LocalDate getDataLancamentoFinal() {
        return this.dataLancamentoFinal;
    }

    @Generated
    public LocalDate getDataVencimentoInicial() {
        return this.dataVencimentoInicial;
    }

    @Generated
    public LocalDate getDataVencimentoFinal() {
        return this.dataVencimentoFinal;
    }

    @Generated
    public Boolean getPermiteTransferirDebitosReparcelado() {
        return this.permiteTransferirDebitosReparcelado;
    }

    @Generated
    public void setTipoCadastro(Long tipoCadastro) {
        this.tipoCadastro = tipoCadastro;
    }

    @Generated
    public void setCadastroGeral(Long cadastroGeral) {
        this.cadastroGeral = cadastroGeral;
    }

    @Generated
    public void setExercicio(String exercicio) {
        this.exercicio = exercicio;
    }

    @Generated
    public void setDivida(String divida) {
        this.divida = divida;
    }

    @Generated
    public void setSubDivida(String subDivida) {
        this.subDivida = subDivida;
    }

    @Generated
    public void setParcela(String parcela) {
        this.parcela = parcela;
    }

    @Generated
    public void setSituacaoLegal(SituacaoLegal situacaoLegal) {
        this.situacaoLegal = situacaoLegal;
    }

    @Generated
    public void setDataLancamentoInicial(LocalDate dataLancamentoInicial) {
        this.dataLancamentoInicial = dataLancamentoInicial;
    }

    @Generated
    public void setDataLancamentoFinal(LocalDate dataLancamentoFinal) {
        this.dataLancamentoFinal = dataLancamentoFinal;
    }

    @Generated
    public void setDataVencimentoInicial(LocalDate dataVencimentoInicial) {
        this.dataVencimentoInicial = dataVencimentoInicial;
    }

    @Generated
    public void setDataVencimentoFinal(LocalDate dataVencimentoFinal) {
        this.dataVencimentoFinal = dataVencimentoFinal;
    }

    @Generated
    public void setPermiteTransferirDebitosReparcelado(Boolean permiteTransferirDebitosReparcelado) {
        this.permiteTransferirDebitosReparcelado = permiteTransferirDebitosReparcelado;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FiltroTDDebitoParcelaDTO)) {
            return false;
        }
        FiltroTDDebitoParcelaDTO other = (FiltroTDDebitoParcelaDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$tipoCadastro = this.getTipoCadastro();
        Long other$tipoCadastro = other.getTipoCadastro();
        if (this$tipoCadastro == null ? other$tipoCadastro != null : !((Object)this$tipoCadastro).equals(other$tipoCadastro)) {
            return false;
        }
        Long this$cadastroGeral = this.getCadastroGeral();
        Long other$cadastroGeral = other.getCadastroGeral();
        if (this$cadastroGeral == null ? other$cadastroGeral != null : !((Object)this$cadastroGeral).equals(other$cadastroGeral)) {
            return false;
        }
        Boolean this$permiteTransferirDebitosReparcelado = this.getPermiteTransferirDebitosReparcelado();
        Boolean other$permiteTransferirDebitosReparcelado = other.getPermiteTransferirDebitosReparcelado();
        if (this$permiteTransferirDebitosReparcelado == null ? other$permiteTransferirDebitosReparcelado != null : !((Object)this$permiteTransferirDebitosReparcelado).equals(other$permiteTransferirDebitosReparcelado)) {
            return false;
        }
        String this$exercicio = this.getExercicio();
        String other$exercicio = other.getExercicio();
        if (this$exercicio == null ? other$exercicio != null : !this$exercicio.equals(other$exercicio)) {
            return false;
        }
        String this$divida = this.getDivida();
        String other$divida = other.getDivida();
        if (this$divida == null ? other$divida != null : !this$divida.equals(other$divida)) {
            return false;
        }
        String this$subDivida = this.getSubDivida();
        String other$subDivida = other.getSubDivida();
        if (this$subDivida == null ? other$subDivida != null : !this$subDivida.equals(other$subDivida)) {
            return false;
        }
        String this$parcela = this.getParcela();
        String other$parcela = other.getParcela();
        if (this$parcela == null ? other$parcela != null : !this$parcela.equals(other$parcela)) {
            return false;
        }
        SituacaoLegal this$situacaoLegal = this.getSituacaoLegal();
        SituacaoLegal other$situacaoLegal = other.getSituacaoLegal();
        if (this$situacaoLegal == null ? other$situacaoLegal != null : !this$situacaoLegal.equals(other$situacaoLegal)) {
            return false;
        }
        LocalDate this$dataLancamentoInicial = this.getDataLancamentoInicial();
        LocalDate other$dataLancamentoInicial = other.getDataLancamentoInicial();
        if (this$dataLancamentoInicial == null ? other$dataLancamentoInicial != null : !((Object)this$dataLancamentoInicial).equals(other$dataLancamentoInicial)) {
            return false;
        }
        LocalDate this$dataLancamentoFinal = this.getDataLancamentoFinal();
        LocalDate other$dataLancamentoFinal = other.getDataLancamentoFinal();
        if (this$dataLancamentoFinal == null ? other$dataLancamentoFinal != null : !((Object)this$dataLancamentoFinal).equals(other$dataLancamentoFinal)) {
            return false;
        }
        LocalDate this$dataVencimentoInicial = this.getDataVencimentoInicial();
        LocalDate other$dataVencimentoInicial = other.getDataVencimentoInicial();
        if (this$dataVencimentoInicial == null ? other$dataVencimentoInicial != null : !((Object)this$dataVencimentoInicial).equals(other$dataVencimentoInicial)) {
            return false;
        }
        LocalDate this$dataVencimentoFinal = this.getDataVencimentoFinal();
        LocalDate other$dataVencimentoFinal = other.getDataVencimentoFinal();
        return !(this$dataVencimentoFinal == null ? other$dataVencimentoFinal != null : !((Object)this$dataVencimentoFinal).equals(other$dataVencimentoFinal));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof FiltroTDDebitoParcelaDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $tipoCadastro = this.getTipoCadastro();
        result = result * 59 + ($tipoCadastro == null ? 43 : ((Object)$tipoCadastro).hashCode());
        Long $cadastroGeral = this.getCadastroGeral();
        result = result * 59 + ($cadastroGeral == null ? 43 : ((Object)$cadastroGeral).hashCode());
        Boolean $permiteTransferirDebitosReparcelado = this.getPermiteTransferirDebitosReparcelado();
        result = result * 59 + ($permiteTransferirDebitosReparcelado == null ? 43 : ((Object)$permiteTransferirDebitosReparcelado).hashCode());
        String $exercicio = this.getExercicio();
        result = result * 59 + ($exercicio == null ? 43 : $exercicio.hashCode());
        String $divida = this.getDivida();
        result = result * 59 + ($divida == null ? 43 : $divida.hashCode());
        String $subDivida = this.getSubDivida();
        result = result * 59 + ($subDivida == null ? 43 : $subDivida.hashCode());
        String $parcela = this.getParcela();
        result = result * 59 + ($parcela == null ? 43 : $parcela.hashCode());
        SituacaoLegal $situacaoLegal = this.getSituacaoLegal();
        result = result * 59 + ($situacaoLegal == null ? 43 : $situacaoLegal.hashCode());
        LocalDate $dataLancamentoInicial = this.getDataLancamentoInicial();
        result = result * 59 + ($dataLancamentoInicial == null ? 43 : ((Object)$dataLancamentoInicial).hashCode());
        LocalDate $dataLancamentoFinal = this.getDataLancamentoFinal();
        result = result * 59 + ($dataLancamentoFinal == null ? 43 : ((Object)$dataLancamentoFinal).hashCode());
        LocalDate $dataVencimentoInicial = this.getDataVencimentoInicial();
        result = result * 59 + ($dataVencimentoInicial == null ? 43 : ((Object)$dataVencimentoInicial).hashCode());
        LocalDate $dataVencimentoFinal = this.getDataVencimentoFinal();
        result = result * 59 + ($dataVencimentoFinal == null ? 43 : ((Object)$dataVencimentoFinal).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "FiltroTDDebitoParcelaDTO(tipoCadastro=" + this.getTipoCadastro() + ", cadastroGeral=" + this.getCadastroGeral() + ", exercicio=" + this.getExercicio() + ", divida=" + this.getDivida() + ", subDivida=" + this.getSubDivida() + ", parcela=" + this.getParcela() + ", situacaoLegal=" + this.getSituacaoLegal() + ", dataLancamentoInicial=" + this.getDataLancamentoInicial() + ", dataLancamentoFinal=" + this.getDataLancamentoFinal() + ", dataVencimentoInicial=" + this.getDataVencimentoInicial() + ", dataVencimentoFinal=" + this.getDataVencimentoFinal() + ", permiteTransferirDebitosReparcelado=" + this.getPermiteTransferirDebitosReparcelado() + ")";
    }
}

