/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto.integracaocontabil;

import br.com.elotech.core.metamodel.annotation.Caption;
import br.com.elotech.tributos.domain.Pessoa;
import br.com.elotech.tributos.domain.TipoTributo;
import br.com.elotech.tributos.dto.integracaocontabil.SituacaoIntegracaoContabil;
import br.com.elotech.tributos.dto.integracaocontabil.TipoMovimento;
import br.com.elotech.tributos.util.MultiValueFilter;
import java.sql.Date;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;

public class FiltroDiarioArrecadacaoDTO {
    @NotNull
    @Caption(value="Data de Arrecada\u00e7\u00e3o")
    private LocalDate dataArrecadacao;
    private LocalDate dataArrecadacaoInicial;
    private LocalDate dataArrecadacaoFinal;
    private Pessoa pessoa;
    private TipoTributo tipoTributo;
    private List<TipoMovimento> tiposMovimento = new ArrayList();
    private Long tipoCadastro;
    private String cadastroGeral;
    private String exercicioDebito;
    private String divida;
    private String subdivida;
    private SituacaoIntegracaoContabil situacaoIntegracaoContabil;

    private String addAndClause(String clause) {
        return " AND " + clause;
    }

    public String buildWhereClause() {
        StringBuilder where = new StringBuilder();
        if (Objects.nonNull(this.dataArrecadacao)) {
            where.append(this.addAndClause("lotecontabil.datalote = :dataArrecadacao"));
        }
        if (Objects.nonNull(this.dataArrecadacaoInicial)) {
            where.append(this.addAndClause("lotecontabil.datalote >= :dataArrecadacaoInicial"));
        }
        if (Objects.nonNull(this.dataArrecadacaoFinal)) {
            where.append(this.addAndClause("lotecontabil.datalote <= :dataArrecadacaoFinal"));
        }
        if (Objects.nonNull(this.pessoa)) {
            where.append(this.addAndClause("pessoa.pessoa = :idPessoa"));
        }
        if (Objects.nonNull(this.tipoTributo)) {
            where.append(this.addAndClause("receita.tiporeceita = :idTipoTributo"));
        }
        if (!this.tiposMovimento.isEmpty()) {
            where.append(this.addAndClause("lotecontabil.tipolote in (:tipoLote)"));
        }
        if (Objects.nonNull(this.tipoCadastro)) {
            where.append(this.addAndClause("debito.tipocadastro = :tipoCadastro"));
        }
        if (Objects.nonNull(this.situacaoIntegracaoContabil)) {
            where.append(this.addAndClause("lotecontabil.situacaoIntegracaoContabil = :situacaoIntegracaoContabil"));
        }
        if (StringUtils.isNotBlank((CharSequence)this.cadastroGeral)) {
            where.append(this.addAndClause(MultiValueFilter.generateFilters((String)this.cadastroGeral, (String)"debito.cadastrogeral")));
        }
        if (StringUtils.isNotBlank((CharSequence)this.exercicioDebito)) {
            where.append(this.addAndClause(MultiValueFilter.generateFilters((String)this.exercicioDebito, (String)"debito.exercicio")));
        }
        if (StringUtils.isNotBlank((CharSequence)this.divida)) {
            where.append(this.addAndClause(MultiValueFilter.generateFilters((String)this.divida, (String)"debito.guiarecolhimento")));
        }
        if (StringUtils.isNotBlank((CharSequence)this.subdivida)) {
            where.append(this.addAndClause(MultiValueFilter.generateFilters((String)this.subdivida, (String)"debito.subdivida")));
        }
        return where.toString();
    }

    public MapSqlParameterSource buildMapSqlParameter() {
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        if (Objects.nonNull(this.dataArrecadacao)) {
            parameters.addValue("dataArrecadacao", (Object)Date.valueOf(this.dataArrecadacao));
        }
        if (Objects.nonNull(this.dataArrecadacaoInicial)) {
            parameters.addValue("dataArrecadacaoInicial", (Object)Date.valueOf(this.dataArrecadacaoInicial));
        }
        if (Objects.nonNull(this.dataArrecadacaoFinal)) {
            parameters.addValue("dataArrecadacaoFinal", (Object)Date.valueOf(this.dataArrecadacaoFinal));
        }
        if (Objects.nonNull(this.pessoa)) {
            parameters.addValue("idPessoa", (Object)this.pessoa.getId());
        }
        if (Objects.nonNull(this.tipoTributo)) {
            parameters.addValue("idTipoTributo", (Object)this.tipoTributo.getId());
        }
        if (!this.tiposMovimento.isEmpty()) {
            parameters.addValue("tipoLote", this.tiposMovimento.stream().map(Enum::name).collect(Collectors.toList()));
        }
        if (Objects.nonNull(this.tipoCadastro)) {
            parameters.addValue("tipoCadastro", (Object)this.tipoCadastro);
        }
        if (Objects.nonNull(this.situacaoIntegracaoContabil)) {
            parameters.addValue("situacaoIntegracaoContabil", (Object)this.situacaoIntegracaoContabil, 12);
        }
        return parameters;
    }

    public void setTipoMovimento(TipoMovimento tipoMovimento) {
        this.tiposMovimento.add(tipoMovimento);
    }

    @Generated
    public FiltroDiarioArrecadacaoDTO() {
    }

    @Generated
    public LocalDate getDataArrecadacao() {
        return this.dataArrecadacao;
    }

    @Generated
    public LocalDate getDataArrecadacaoInicial() {
        return this.dataArrecadacaoInicial;
    }

    @Generated
    public LocalDate getDataArrecadacaoFinal() {
        return this.dataArrecadacaoFinal;
    }

    @Generated
    public Pessoa getPessoa() {
        return this.pessoa;
    }

    @Generated
    public TipoTributo getTipoTributo() {
        return this.tipoTributo;
    }

    @Generated
    public List<TipoMovimento> getTiposMovimento() {
        return this.tiposMovimento;
    }

    @Generated
    public Long getTipoCadastro() {
        return this.tipoCadastro;
    }

    @Generated
    public String getCadastroGeral() {
        return this.cadastroGeral;
    }

    @Generated
    public String getExercicioDebito() {
        return this.exercicioDebito;
    }

    @Generated
    public String getDivida() {
        return this.divida;
    }

    @Generated
    public String getSubdivida() {
        return this.subdivida;
    }

    @Generated
    public SituacaoIntegracaoContabil getSituacaoIntegracaoContabil() {
        return this.situacaoIntegracaoContabil;
    }

    @Generated
    public void setDataArrecadacao(LocalDate dataArrecadacao) {
        this.dataArrecadacao = dataArrecadacao;
    }

    @Generated
    public void setDataArrecadacaoInicial(LocalDate dataArrecadacaoInicial) {
        this.dataArrecadacaoInicial = dataArrecadacaoInicial;
    }

    @Generated
    public void setDataArrecadacaoFinal(LocalDate dataArrecadacaoFinal) {
        this.dataArrecadacaoFinal = dataArrecadacaoFinal;
    }

    @Generated
    public void setPessoa(Pessoa pessoa) {
        this.pessoa = pessoa;
    }

    @Generated
    public void setTipoTributo(TipoTributo tipoTributo) {
        this.tipoTributo = tipoTributo;
    }

    @Generated
    public void setTiposMovimento(List<TipoMovimento> tiposMovimento) {
        this.tiposMovimento = tiposMovimento;
    }

    @Generated
    public void setTipoCadastro(Long tipoCadastro) {
        this.tipoCadastro = tipoCadastro;
    }

    @Generated
    public void setCadastroGeral(String cadastroGeral) {
        this.cadastroGeral = cadastroGeral;
    }

    @Generated
    public void setExercicioDebito(String exercicioDebito) {
        this.exercicioDebito = exercicioDebito;
    }

    @Generated
    public void setDivida(String divida) {
        this.divida = divida;
    }

    @Generated
    public void setSubdivida(String subdivida) {
        this.subdivida = subdivida;
    }

    @Generated
    public void setSituacaoIntegracaoContabil(SituacaoIntegracaoContabil situacaoIntegracaoContabil) {
        this.situacaoIntegracaoContabil = situacaoIntegracaoContabil;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FiltroDiarioArrecadacaoDTO)) {
            return false;
        }
        FiltroDiarioArrecadacaoDTO other = (FiltroDiarioArrecadacaoDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$tipoCadastro = this.getTipoCadastro();
        Long other$tipoCadastro = other.getTipoCadastro();
        if (this$tipoCadastro == null ? other$tipoCadastro != null : !((Object)this$tipoCadastro).equals(other$tipoCadastro)) {
            return false;
        }
        LocalDate this$dataArrecadacao = this.getDataArrecadacao();
        LocalDate other$dataArrecadacao = other.getDataArrecadacao();
        if (this$dataArrecadacao == null ? other$dataArrecadacao != null : !((Object)this$dataArrecadacao).equals(other$dataArrecadacao)) {
            return false;
        }
        LocalDate this$dataArrecadacaoInicial = this.getDataArrecadacaoInicial();
        LocalDate other$dataArrecadacaoInicial = other.getDataArrecadacaoInicial();
        if (this$dataArrecadacaoInicial == null ? other$dataArrecadacaoInicial != null : !((Object)this$dataArrecadacaoInicial).equals(other$dataArrecadacaoInicial)) {
            return false;
        }
        LocalDate this$dataArrecadacaoFinal = this.getDataArrecadacaoFinal();
        LocalDate other$dataArrecadacaoFinal = other.getDataArrecadacaoFinal();
        if (this$dataArrecadacaoFinal == null ? other$dataArrecadacaoFinal != null : !((Object)this$dataArrecadacaoFinal).equals(other$dataArrecadacaoFinal)) {
            return false;
        }
        Pessoa this$pessoa = this.getPessoa();
        Pessoa other$pessoa = other.getPessoa();
        if (this$pessoa == null ? other$pessoa != null : !this$pessoa.equals(other$pessoa)) {
            return false;
        }
        TipoTributo this$tipoTributo = this.getTipoTributo();
        TipoTributo other$tipoTributo = other.getTipoTributo();
        if (this$tipoTributo == null ? other$tipoTributo != null : !this$tipoTributo.equals(other$tipoTributo)) {
            return false;
        }
        List this$tiposMovimento = this.getTiposMovimento();
        List other$tiposMovimento = other.getTiposMovimento();
        if (this$tiposMovimento == null ? other$tiposMovimento != null : !((Object)this$tiposMovimento).equals(other$tiposMovimento)) {
            return false;
        }
        String this$cadastroGeral = this.getCadastroGeral();
        String other$cadastroGeral = other.getCadastroGeral();
        if (this$cadastroGeral == null ? other$cadastroGeral != null : !this$cadastroGeral.equals(other$cadastroGeral)) {
            return false;
        }
        String this$exercicioDebito = this.getExercicioDebito();
        String other$exercicioDebito = other.getExercicioDebito();
        if (this$exercicioDebito == null ? other$exercicioDebito != null : !this$exercicioDebito.equals(other$exercicioDebito)) {
            return false;
        }
        String this$divida = this.getDivida();
        String other$divida = other.getDivida();
        if (this$divida == null ? other$divida != null : !this$divida.equals(other$divida)) {
            return false;
        }
        String this$subdivida = this.getSubdivida();
        String other$subdivida = other.getSubdivida();
        if (this$subdivida == null ? other$subdivida != null : !this$subdivida.equals(other$subdivida)) {
            return false;
        }
        SituacaoIntegracaoContabil this$situacaoIntegracaoContabil = this.getSituacaoIntegracaoContabil();
        SituacaoIntegracaoContabil other$situacaoIntegracaoContabil = other.getSituacaoIntegracaoContabil();
        return !(this$situacaoIntegracaoContabil == null ? other$situacaoIntegracaoContabil != null : !this$situacaoIntegracaoContabil.equals(other$situacaoIntegracaoContabil));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof FiltroDiarioArrecadacaoDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $tipoCadastro = this.getTipoCadastro();
        result = result * 59 + ($tipoCadastro == null ? 43 : ((Object)$tipoCadastro).hashCode());
        LocalDate $dataArrecadacao = this.getDataArrecadacao();
        result = result * 59 + ($dataArrecadacao == null ? 43 : ((Object)$dataArrecadacao).hashCode());
        LocalDate $dataArrecadacaoInicial = this.getDataArrecadacaoInicial();
        result = result * 59 + ($dataArrecadacaoInicial == null ? 43 : ((Object)$dataArrecadacaoInicial).hashCode());
        LocalDate $dataArrecadacaoFinal = this.getDataArrecadacaoFinal();
        result = result * 59 + ($dataArrecadacaoFinal == null ? 43 : ((Object)$dataArrecadacaoFinal).hashCode());
        Pessoa $pessoa = this.getPessoa();
        result = result * 59 + ($pessoa == null ? 43 : $pessoa.hashCode());
        TipoTributo $tipoTributo = this.getTipoTributo();
        result = result * 59 + ($tipoTributo == null ? 43 : $tipoTributo.hashCode());
        List $tiposMovimento = this.getTiposMovimento();
        result = result * 59 + ($tiposMovimento == null ? 43 : ((Object)$tiposMovimento).hashCode());
        String $cadastroGeral = this.getCadastroGeral();
        result = result * 59 + ($cadastroGeral == null ? 43 : $cadastroGeral.hashCode());
        String $exercicioDebito = this.getExercicioDebito();
        result = result * 59 + ($exercicioDebito == null ? 43 : $exercicioDebito.hashCode());
        String $divida = this.getDivida();
        result = result * 59 + ($divida == null ? 43 : $divida.hashCode());
        String $subdivida = this.getSubdivida();
        result = result * 59 + ($subdivida == null ? 43 : $subdivida.hashCode());
        SituacaoIntegracaoContabil $situacaoIntegracaoContabil = this.getSituacaoIntegracaoContabil();
        result = result * 59 + ($situacaoIntegracaoContabil == null ? 43 : $situacaoIntegracaoContabil.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "FiltroDiarioArrecadacaoDTO(dataArrecadacao=" + this.getDataArrecadacao() + ", dataArrecadacaoInicial=" + this.getDataArrecadacaoInicial() + ", dataArrecadacaoFinal=" + this.getDataArrecadacaoFinal() + ", pessoa=" + this.getPessoa() + ", tipoTributo=" + this.getTipoTributo() + ", tiposMovimento=" + this.getTiposMovimento() + ", tipoCadastro=" + this.getTipoCadastro() + ", cadastroGeral=" + this.getCadastroGeral() + ", exercicioDebito=" + this.getExercicioDebito() + ", divida=" + this.getDivida() + ", subdivida=" + this.getSubdivida() + ", situacaoIntegracaoContabil=" + this.getSituacaoIntegracaoContabil() + ")";
    }
}

