/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto.cadastroimobiliario;

import br.com.elotech.tributos.domain.Distrito;
import br.com.elotech.tributos.domain.Logradouro;
import br.com.elotech.tributos.domain.LogradouroTestada;
import br.com.elotech.tributos.domain.LogradouroTestadaExercicio;
import br.com.elotech.tributos.domain.Setor;
import br.com.elotech.tributos.domain.SetorQuadra;
import br.com.elotech.tributos.dto.LogradouroDTO;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Optional;
import lombok.Generated;

public class LogradouroTestadaResumoDTO {
    private Long id;
    private LogradouroDTO logradouro;
    private String distrito;
    private String setor;
    private String quadra;
    private Long idSetorQuadra;
    private BigDecimal valorTerreno = BigDecimal.ZERO;

    public static LogradouroTestadaResumoDTO from(LogradouroTestada entity) {
        LogradouroTestadaResumoDTO dto = new LogradouroTestadaResumoDTO();
        dto.setId(entity.getId());
        dto.setLogradouro(LogradouroDTO.from((Logradouro)entity.getLogradouro()));
        dto.setDistrito((String)Optional.ofNullable(entity.getSetorQuadra()).map(SetorQuadra::getSetor).map(Setor::getDistrito).map(Distrito::getDistrito).orElse(null));
        dto.setSetor((String)Optional.ofNullable(entity.getSetorQuadra()).map(SetorQuadra::getSetor).map(Setor::getSetor).orElse(null));
        dto.setQuadra((String)Optional.ofNullable(entity.getSetorQuadra()).map(SetorQuadra::getQuadra).orElse(null));
        dto.setIdSetorQuadra((Long)Optional.ofNullable(entity.getSetorQuadra()).map(SetorQuadra::getId).orElse(null));
        entity.getLogradouroTestadaExercicios().stream().filter(e -> e.getExercicio().equals(LocalDate.now().getYear())).filter(LogradouroTestadaExercicio::getPrincipal).findFirst().ifPresent(item -> dto.setValorTerreno(item.getValorTerreno()));
        return dto;
    }

    public LogradouroTestada toEntity() {
        SetorQuadra setorQuadra = new SetorQuadra();
        setorQuadra.setId(this.idSetorQuadra);
        LogradouroTestada entity = new LogradouroTestada();
        entity.setId(this.getId());
        entity.setLogradouro(this.getLogradouro().toEntity());
        entity.setSetorQuadra(setorQuadra);
        return entity;
    }

    @Generated
    public LogradouroTestadaResumoDTO() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public LogradouroDTO getLogradouro() {
        return this.logradouro;
    }

    @Generated
    public String getDistrito() {
        return this.distrito;
    }

    @Generated
    public String getSetor() {
        return this.setor;
    }

    @Generated
    public String getQuadra() {
        return this.quadra;
    }

    @Generated
    public Long getIdSetorQuadra() {
        return this.idSetorQuadra;
    }

    @Generated
    public BigDecimal getValorTerreno() {
        return this.valorTerreno;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setLogradouro(LogradouroDTO logradouro) {
        this.logradouro = logradouro;
    }

    @Generated
    public void setDistrito(String distrito) {
        this.distrito = distrito;
    }

    @Generated
    public void setSetor(String setor) {
        this.setor = setor;
    }

    @Generated
    public void setQuadra(String quadra) {
        this.quadra = quadra;
    }

    @Generated
    public void setIdSetorQuadra(Long idSetorQuadra) {
        this.idSetorQuadra = idSetorQuadra;
    }

    @Generated
    public void setValorTerreno(BigDecimal valorTerreno) {
        this.valorTerreno = valorTerreno;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LogradouroTestadaResumoDTO)) {
            return false;
        }
        LogradouroTestadaResumoDTO other = (LogradouroTestadaResumoDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Long this$idSetorQuadra = this.getIdSetorQuadra();
        Long other$idSetorQuadra = other.getIdSetorQuadra();
        if (this$idSetorQuadra == null ? other$idSetorQuadra != null : !((Object)this$idSetorQuadra).equals(other$idSetorQuadra)) {
            return false;
        }
        LogradouroDTO this$logradouro = this.getLogradouro();
        LogradouroDTO other$logradouro = other.getLogradouro();
        if (this$logradouro == null ? other$logradouro != null : !this$logradouro.equals(other$logradouro)) {
            return false;
        }
        String this$distrito = this.getDistrito();
        String other$distrito = other.getDistrito();
        if (this$distrito == null ? other$distrito != null : !this$distrito.equals(other$distrito)) {
            return false;
        }
        String this$setor = this.getSetor();
        String other$setor = other.getSetor();
        if (this$setor == null ? other$setor != null : !this$setor.equals(other$setor)) {
            return false;
        }
        String this$quadra = this.getQuadra();
        String other$quadra = other.getQuadra();
        if (this$quadra == null ? other$quadra != null : !this$quadra.equals(other$quadra)) {
            return false;
        }
        BigDecimal this$valorTerreno = this.getValorTerreno();
        BigDecimal other$valorTerreno = other.getValorTerreno();
        return !(this$valorTerreno == null ? other$valorTerreno != null : !((Object)this$valorTerreno).equals(other$valorTerreno));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof LogradouroTestadaResumoDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Long $idSetorQuadra = this.getIdSetorQuadra();
        result = result * 59 + ($idSetorQuadra == null ? 43 : ((Object)$idSetorQuadra).hashCode());
        LogradouroDTO $logradouro = this.getLogradouro();
        result = result * 59 + ($logradouro == null ? 43 : $logradouro.hashCode());
        String $distrito = this.getDistrito();
        result = result * 59 + ($distrito == null ? 43 : $distrito.hashCode());
        String $setor = this.getSetor();
        result = result * 59 + ($setor == null ? 43 : $setor.hashCode());
        String $quadra = this.getQuadra();
        result = result * 59 + ($quadra == null ? 43 : $quadra.hashCode());
        BigDecimal $valorTerreno = this.getValorTerreno();
        result = result * 59 + ($valorTerreno == null ? 43 : ((Object)$valorTerreno).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "LogradouroTestadaResumoDTO(id=" + this.getId() + ", logradouro=" + this.getLogradouro() + ", distrito=" + this.getDistrito() + ", setor=" + this.getSetor() + ", quadra=" + this.getQuadra() + ", idSetorQuadra=" + this.getIdSetorQuadra() + ", valorTerreno=" + this.getValorTerreno() + ")";
    }
}

