/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.calculo.service;

import br.com.elotech.tributos.calculo.dto.CadastroCalculoRoot;
import br.com.elotech.tributos.calculo.dto.ParametroTesteScriptDTO;
import br.com.elotech.tributos.calculo.exception.CalculoException;
import br.com.elotech.tributos.calculo.repository.CadastroGeralCalculoRepository;
import br.com.elotech.tributos.calculo.repository.CadastroImobiliarioCalculoRepository;
import br.com.elotech.tributos.calculo.repository.CadastroMobiliarioCalculoRepository;
import br.com.elotech.tributos.calculo.repository.CadastroRuralCalculoRepository;
import br.com.elotech.tributos.calculo.service.CalculoBuild;
import br.com.elotech.tributos.calculo.service.CalculoExecucaoBaseService;
import br.com.elotech.tributos.calculo.service.CalculoParser;
import br.com.elotech.tributos.calculo.service.CalculoTabelaValores;
import br.com.elotech.tributos.calculo.service.TabelaValorService;
import br.com.elotech.tributos.domain.TipoCadastro;
import br.com.elotech.tributos.domain.TipoDivida;
import br.com.elotech.tributos.domain.calculo.CalculoTributo;
import java.time.LocalDate;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.springframework.core.convert.ConversionService;
import org.springframework.stereotype.Service;

@Service
public class CalculoTributoExecucaoService
extends CalculoExecucaoBaseService<CalculoTributo> {
    private final CadastroGeralCalculoRepository cadastroGeralCalculoRepository;

    public CalculoTributoExecucaoService(CadastroImobiliarioCalculoRepository cadastroImobiliarioCalculoRepository, TabelaValorService tabelaValorService, ConversionService conversionService, CadastroMobiliarioCalculoRepository cadastroMobiliarioCalculoRepository, CadastroGeralCalculoRepository cadastroGeralCalculoRepository, CadastroRuralCalculoRepository cadastroRuralCalculoRepository) {
        super(cadastroImobiliarioCalculoRepository, conversionService, tabelaValorService, cadastroMobiliarioCalculoRepository, cadastroRuralCalculoRepository);
        this.cadastroGeralCalculoRepository = cadastroGeralCalculoRepository;
    }

    public List<CadastroCalculoRoot> calcularSemCompilarFormulas(List<CalculoTributo> tributos, Long exercicio, String filtro, LocalDate dataReferencia, CalculoTabelaValores calculoTabelaValores) {
        Set camposDinamicos = CalculoParser.extractCamposDinamicos(tributos);
        List cadastrosRoots = this.loadCadastros(tributos, filtro, null, exercicio, camposDinamicos, dataReferencia);
        if (cadastrosRoots.isEmpty()) {
            throw new CalculoException(String.format("N\u00e3o foram encontrados cadastros para o filtro informado: %s.", filtro));
        }
        for (CalculoTributo tributo : tributos) {
            tributo.getCalculoBuildDTO().getContext().setCalculoTabelaValores(calculoTabelaValores);
        }
        cadastrosRoots.forEach(cadastro -> this.executeCalculo(tributos, cadastro));
        return cadastrosRoots;
    }

    public void verifyFiltroTemUmCadastroGeralPeloMenos(String filtro) {
        if (!this.cadastroGeralCalculoRepository.temUmCadastroGeralPeloMenos(filtro).booleanValue()) {
            throw new CalculoException("N\u00e3o foram encontrados cadastros para o filtro informado.");
        }
    }

    public List<CadastroCalculoRoot> testarScript(ParametroTesteScriptDTO parametroTestScriptDTO) {
        parametroTestScriptDTO.getCalculoTributo().setIdentificadorResultado(parametroTestScriptDTO.getIdentificador());
        parametroTestScriptDTO.getCalculoTributo().setIdentificadorBaseCalculo(null);
        CalculoBuild.buildCalculoDebugMode((List)parametroTestScriptDTO.getCalculoTributo().getScript(), CalculoParser::parseLinhaDebugMode, (TipoDivida)parametroTestScriptDTO.getCalculoTributo().getDivida().getTipoDivida(), (TipoCadastro)parametroTestScriptDTO.getCalculoTributo().getDivida().getTipoCadastro());
        return this.calcular(Collections.singletonList(parametroTestScriptDTO.getCalculoTributo()), parametroTestScriptDTO.getCalculoTributo().getExercicio(), parametroTestScriptDTO.buildFiltro(), parametroTestScriptDTO.getSegmento(), Boolean.TRUE, LocalDate.now());
    }
}

