/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.calculo.domain;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.metamodel.annotation.MetaModelIgnore;
import br.com.elotech.tributos.calculo.domain.Calculo;
import br.com.elotech.tributos.calculo.domain.CalculoInconsistencia;
import br.com.elotech.tributos.calculo.domain.CalculoLinha;
import br.com.elotech.tributos.calculo.domain.CalculoResultado;
import br.com.elotech.tributos.calculo.domain.CalculoResultadoDeducao;
import br.com.elotech.tributos.calculo.dto.CadastroCalculoDTO;
import br.com.elotech.tributos.calculo.dto.CadastroCalculoRoot;
import br.com.elotech.tributos.calculo.dto.CadastroImobiliarioCalculoDTO;
import br.com.elotech.tributos.calculo.dto.CadastroIsencaoDTO;
import br.com.elotech.tributos.calculo.dto.CalculoResultadoDTO;
import br.com.elotech.tributos.calculo.dto.InconsistenciaCalculoDTO;
import br.com.elotech.tributos.domain.CadastroGeral;
import br.com.elotech.tributos.domain.Debito;
import br.com.elotech.tributos.domain.Divida;
import br.com.elotech.tributos.domain.ParametroEntidadeExercicioEnum;
import br.com.elotech.tributos.domain.TipoCadastro;
import br.com.elotech.tributos.domain.Tributo;
import br.com.elotech.tributos.domain.calculo.CalculoConfigBase;
import br.com.elotech.tributos.domain.calculo.CalculoScriptBase;
import br.com.elotech.tributos.domain.calculo.CalculoTributo;
import br.com.elotech.tributos.domain.camposdinamicos.Campo;
import br.com.elotech.tributos.dto.CarneDTO;
import br.com.elotech.tributos.dto.ClassificacaoTipoTributo;
import br.com.elotech.tributos.enums.SituacaoGeracaoCarne;
import br.com.elotech.tributos.util.CalculoUtils;
import br.com.elotech.tributos.util.CalculoValoresConstants;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@Table(name="calculocadastro")
@Entity
public class CalculoCadastro
implements EloEntity<Long> {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="seq_calculocadastro")
    @SequenceGenerator(name="seq_calculocadastro", sequenceName="seq_calculocadastro")
    private Long id;
    @ManyToOne
    @JoinColumn(name="calculo")
    @JsonIgnoreProperties(value={"cadastros", "divida"})
    private Calculo calculo;
    @ManyToOne(fetch=FetchType.LAZY)
    @JsonIgnoreProperties(value={"avaliacoes"})
    private CadastroGeral cadastro;
    @ManyToOne
    @JoinColumn(name="iddivida")
    private Divida divida;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="calculoCadastro")
    private List<CalculoResultado> resultados = new ArrayList();
    @OneToMany(mappedBy="calculoCadastro", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<CalculoInconsistencia> inconsistencias = new ArrayList();
    private BigDecimal aliquota = BigDecimal.ZERO;
    @JsonIgnore
    @MetaModelIgnore
    @OneToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="idDebito", referencedColumnName="idDebito")
    private Debito debito;
    @Column(name="entidade")
    private Long entidadeCarne;
    @Column(name="exercicio")
    private Long exercicioCarne;
    @Column(name="carne")
    private Long numeroCarne;
    @Column(name="erroemissaoboleto")
    private String erroEmissaoBoleto;
    @Column(name="situacaocarne")
    @Enumerated(value=EnumType.STRING)
    private SituacaoGeracaoCarne situacaoCarne = SituacaoGeracaoCarne.PENDENTE;

    public BigDecimal getValorCalculado() {
        return Optional.ofNullable(this.resultados).map(resultado -> resultado.stream().map(CalculoResultado::getValor).reduce(BigDecimal.ZERO, BigDecimal::add)).orElse(BigDecimal.ZERO);
    }

    public BigDecimal getValorDeducoes() {
        return Optional.ofNullable(this.resultados).map(resultado -> resultado.stream().map(CalculoResultado::getValorDeducoes).reduce(BigDecimal.ZERO, BigDecimal::add)).orElse(BigDecimal.ZERO);
    }

    public BigDecimal getValorTotal() {
        return this.getValorCalculado().subtract(this.getValorDeducoes());
    }

    public boolean isValorCalculadoZerado() {
        return BigDecimal.ZERO.compareTo(this.getValorCalculado()) == 0;
    }

    public void removeResultadoComValorZerado() {
        this.resultados.removeIf(cr -> BigDecimal.ZERO.compareTo(cr.getValor()) == 0);
    }

    private static Boolean considerarResultado(CalculoTributo calculoTributo, Divida divida, CalculoResultadoDTO resultadoCalculo) {
        return calculoTributo.getDivida().getId().equals(divida.getId()) && Boolean.FALSE.equals(resultadoCalculo.ignoradoPorCondicaoCalculo());
    }

    public static CalculoCadastro from(CadastroCalculoRoot root, Divida divida) {
        CalculoCadastro calculoCadastro = new CalculoCadastro();
        CadastroGeral cadastro = new CadastroGeral();
        cadastro.setId(root.getId());
        cadastro.setTipoCadastro(TipoCadastro.fromValue((Long)root.getTipoCadastro()));
        cadastro.setCadastroGeral(root.getCadastroGeral());
        calculoCadastro.setCadastro(cadastro);
        calculoCadastro.setInconsistencias(root.getInconsistencias().stream().filter(inconsistenciaCalculoDTO -> divida.getId().equals(inconsistenciaCalculoDTO.getIdDivida())).map(dto -> CalculoInconsistencia.from((CalculoCadastro)calculoCadastro, (InconsistenciaCalculoDTO)dto)).collect(Collectors.toList()));
        root.getResultado().forEach((tributo, resultado) -> {
            if (Boolean.TRUE.equals(CalculoCadastro.considerarResultado((CalculoTributo)tributo, (Divida)divida, (CalculoResultadoDTO)resultado))) {
                CalculoResultado calculoResultado = CalculoResultado.from((CalculoCadastro)calculoCadastro, (CalculoTributo)tributo, (CalculoResultadoDTO)resultado);
                CalculoCadastro.adicionaScriptLinha(null, (CalculoConfigBase)tributo, (CalculoResultadoDTO)resultado, (CalculoResultado)calculoResultado);
                calculoCadastro.resultados.add(calculoResultado);
            }
        });
        Map tributosPorSegmento = CalculoCadastro.mergeTributosSegmentos((CadastroCalculoRoot)root, (CalculoCadastro)calculoCadastro, (Divida)divida);
        calculoCadastro.getResultados().addAll(tributosPorSegmento.values());
        calculoCadastro.getResultados().forEach(calculoResultado -> calculoResultado.setCalculoCadastro(calculoCadastro));
        CalculoCadastro.validaAliquota((CalculoCadastro)calculoCadastro);
        CalculoCadastro.calculaIsencoes((CadastroCalculoRoot)root, (CalculoCadastro)calculoCadastro);
        calculoCadastro.setDivida(divida);
        return calculoCadastro;
    }

    private static void validaAliquota(CalculoCadastro calculoCadastro) {
        List resultadosComAliquota = calculoCadastro.getResultados().stream().filter(resultado -> resultado.getCalculoTributo().getSalvaAliquotaCalculo() != false && resultado.getAliquota().compareTo(BigDecimal.ZERO) > 0).collect(Collectors.toList());
        if (resultadosComAliquota.size() > 1) {
            String tributosComAliquota = resultadosComAliquota.stream().map(resultado -> resultado.getCalculoTributo().getTributo().getTributo()).collect(Collectors.joining(", "));
            CalculoInconsistencia inconsistencia = new CalculoInconsistencia();
            inconsistencia.setDescricao(String.format("Sistema encontrou %d al\u00edquotas para o calculo. Por favor, corrija a formula/condi\u00e7\u00e3o de c\u00e1lculo e recalcule novamente!. Tributos com al\u00edquota marcada: [%s]", resultadosComAliquota.size(), tributosComAliquota));
            calculoCadastro.addInconsistencia(inconsistencia);
            return;
        }
        if (resultadosComAliquota.size() == 1) {
            calculoCadastro.setAliquota(((CalculoResultado)resultadosComAliquota.get(0)).getAliquota());
        }
    }

    public static CalculoCadastro from(CadastroCalculoRoot root) {
        CalculoCadastro calculoCadastro = new CalculoCadastro();
        CadastroGeral cadastro = new CadastroGeral();
        cadastro.setId(root.getId());
        cadastro.setTipoCadastro(TipoCadastro.fromValue((Long)root.getTipoCadastro()));
        cadastro.setCadastroGeral(root.getCadastroGeral());
        calculoCadastro.setCadastro(cadastro);
        calculoCadastro.setInconsistencias(root.getInconsistencias().stream().map(dto -> CalculoInconsistencia.from((CalculoCadastro)calculoCadastro, (InconsistenciaCalculoDTO)dto)).collect(Collectors.toList()));
        root.getResultado().forEach((tributo, resultado) -> {
            CalculoResultado calculoResultado = CalculoResultado.from((CalculoCadastro)calculoCadastro, (CalculoTributo)tributo, (CalculoResultadoDTO)resultado);
            CalculoCadastro.adicionaScriptLinha(null, (CalculoConfigBase)tributo, (CalculoResultadoDTO)resultado, (CalculoResultado)calculoResultado);
            calculoCadastro.resultados.add(calculoResultado);
        });
        Map tributosPorSegmento = CalculoCadastro.mergeTributosSegmentos((CadastroCalculoRoot)root, (CalculoCadastro)calculoCadastro, CadastroCalculoDTO::getResultado);
        calculoCadastro.getResultados().addAll(tributosPorSegmento.values());
        calculoCadastro.getResultados().forEach(calculoResultado -> calculoResultado.setCalculoCadastro(calculoCadastro));
        CalculoCadastro.calculaIsencoes((CadastroCalculoRoot)root, (CalculoCadastro)calculoCadastro);
        if (calculoCadastro.getResultados().size() > 0) {
            calculoCadastro.setDivida(((CalculoResultado)calculoCadastro.getResultados().get(0)).getCalculoTributo().getDivida());
        }
        return calculoCadastro;
    }

    public static CalculoCadastro fromAvaliacao(CadastroCalculoRoot root) {
        CalculoCadastro calculoCadastro = new CalculoCadastro();
        CadastroGeral cadastro = new CadastroGeral();
        cadastro.setId(root.getId());
        cadastro.setCadastroGeral(root.getCadastroGeral());
        cadastro.setTipoCadastro(TipoCadastro.fromValue((Long)root.getTipoCadastro()));
        calculoCadastro.setCadastro(cadastro);
        calculoCadastro.setInconsistencias(root.getInconsistencias().stream().map(dto -> CalculoInconsistencia.from((CalculoCadastro)calculoCadastro, (InconsistenciaCalculoDTO)dto)).collect(Collectors.toList()));
        root.getResultadoAvaliacao().forEach((avaliacao, resultado) -> {
            CalculoResultado calculoResultado = CalculoResultado.from((CalculoCadastro)calculoCadastro, (CalculoResultadoDTO)resultado);
            CalculoCadastro.adicionaScriptLinha(null, (CalculoConfigBase)avaliacao, (CalculoResultadoDTO)resultado, (CalculoResultado)calculoResultado);
            calculoCadastro.resultados.add(calculoResultado);
        });
        Map resultadoPorSegmento = CalculoCadastro.mergeTributosSegmentos((CadastroCalculoRoot)root, (CalculoCadastro)calculoCadastro, CadastroCalculoDTO::getResultadoAvaliacao);
        calculoCadastro.getResultados().addAll(resultadoPorSegmento.values());
        return calculoCadastro;
    }

    public void recalcularResultado(CadastroCalculoRoot root) {
        this.clearOldResultados();
        this.getInconsistencias().addAll(root.getInconsistencias().stream().map(dto -> CalculoInconsistencia.from((CalculoCadastro)this, (InconsistenciaCalculoDTO)dto)).collect(Collectors.toList()));
        root.getResultado().forEach((tributo, resultado) -> {
            CalculoResultado calculoResultado = CalculoResultado.from((CalculoCadastro)this, (CalculoTributo)tributo, (CalculoResultadoDTO)resultado);
            CalculoCadastro.adicionaScriptLinha(null, (CalculoConfigBase)tributo, (CalculoResultadoDTO)resultado, (CalculoResultado)calculoResultado);
            this.getResultados().add(calculoResultado);
        });
        Map tributosPorSegmento = CalculoCadastro.mergeTributosSegmentos((CadastroCalculoRoot)root, (CalculoCadastro)this, (Divida)this.divida);
        this.getResultados().addAll(tributosPorSegmento.values());
        CalculoCadastro.calculaIsencoes((CadastroCalculoRoot)root, (CalculoCadastro)this);
    }

    private void clearOldResultados() {
        this.getInconsistencias().forEach(inconsistencia -> inconsistencia.setCalculoCadastro(null));
        this.getInconsistencias().clear();
        this.getResultados().clear();
    }

    protected static void calculaIsencoes(CadastroCalculoRoot root, CalculoCadastro calculoCadastro) {
        root.getIsencoes().forEach(isencao -> calculoCadastro.getResultados().forEach(calculoResultado -> {
            BigDecimal valorReducao;
            Tributo tributo = calculoResultado.getCalculoTributo().getTributo();
            if (CalculoCadastro.aplicaIsencao((CadastroIsencaoDTO)isencao, (Tributo)tributo)) {
                calculoResultado.setValor(BigDecimal.ZERO);
                calculoResultado.setValorBaseCalculo(BigDecimal.ZERO);
                calculoResultado.setAliquota(BigDecimal.ZERO);
                calculoResultado.setValorVenalPredial(BigDecimal.ZERO);
                calculoResultado.setValorVenalTerritorial(BigDecimal.ZERO);
            }
            if (CalculoCadastro.aplicaIsencaoContabiliza((CadastroIsencaoDTO)isencao, (Tributo)tributo)) {
                CalculoResultadoDeducao deducaoIsencao = CalculoResultadoDeducao.from((CalculoResultado)calculoResultado, (CadastroIsencaoDTO)isencao, (BigDecimal)calculoResultado.getValor());
                calculoResultado.getDeducoes().add(deducaoIsencao);
            }
            if (CalculoCadastro.aplicaReducao((CadastroIsencaoDTO)isencao, (Tributo)tributo) && BigDecimal.ZERO.compareTo(valorReducao = calculoResultado.getValor().multiply(CalculoCadastro.percentualReducao((CadastroIsencaoDTO)isencao, (Tributo)tributo)).divide(BigDecimal.valueOf(100L), RoundingMode.HALF_DOWN)) != 0) {
                CalculoResultadoDeducao deducaoReducao = CalculoResultadoDeducao.from((CalculoResultado)calculoResultado, (CadastroIsencaoDTO)isencao, (BigDecimal)valorReducao);
                calculoResultado.getDeducoes().add(deducaoReducao);
            }
        }));
    }

    protected static boolean aplicaIsencao(CadastroIsencaoDTO isencao, Tributo tributo) {
        ClassificacaoTipoTributo classificacao = tributo.getTipoTributo().getClassificacaoTipoTributo();
        if (Boolean.TRUE.equals(isencao.aplicaIsencaoImposto(classificacao))) {
            return Boolean.TRUE;
        }
        if (Boolean.TRUE.equals(isencao.aplicaIsencaoTaxa(classificacao))) {
            return Boolean.TRUE;
        }
        if (Boolean.TRUE.equals(isencao.aplicaIsencaoContribuicao(classificacao))) {
            return Boolean.TRUE;
        }
        if (Boolean.TRUE.equals(isencao.aplicaIsencaoReceitasNaoTributaveis(classificacao))) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    protected static boolean aplicaIsencaoContabiliza(CadastroIsencaoDTO isencao, Tributo tributo) {
        ClassificacaoTipoTributo classificacao = tributo.getTipoTributo().getClassificacaoTipoTributo();
        if (Boolean.TRUE.equals(isencao.aplicaIsencaoContabilizaImposto(classificacao))) {
            return Boolean.TRUE;
        }
        if (Boolean.TRUE.equals(isencao.aplicaIsencaoContabilizaTaxa(classificacao))) {
            return Boolean.TRUE;
        }
        if (Boolean.TRUE.equals(isencao.aplicaIsencaoContabilizaContribuicao(classificacao))) {
            return Boolean.TRUE;
        }
        if (Boolean.TRUE.equals(isencao.aplicaIsencaoContabilizaReceitasNaoTributaveis(classificacao))) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private static boolean aplicaReducao(CadastroIsencaoDTO isencao, Tributo tributo) {
        ClassificacaoTipoTributo classificacao = tributo.getTipoTributo().getClassificacaoTipoTributo();
        if (Boolean.TRUE.equals(isencao.getReducaoImposto()) && Boolean.TRUE.equals(classificacao.isImposto())) {
            return Boolean.TRUE;
        }
        if (Boolean.TRUE.equals(isencao.getReducaoTaxa()) && Boolean.TRUE.equals(classificacao.isTaxa())) {
            return Boolean.TRUE;
        }
        if (Boolean.TRUE.equals(isencao.getReducaoContribuicao()) && Boolean.TRUE.equals(classificacao.isContribuicao())) {
            return Boolean.TRUE;
        }
        if (Boolean.TRUE.equals(isencao.getReducaoReceitasNaoTributaveis()) && Boolean.TRUE.equals(classificacao.isReceitaNaoTributavel())) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private static BigDecimal percentualReducao(CadastroIsencaoDTO isencao, Tributo tributo) {
        ClassificacaoTipoTributo classificacao = tributo.getTipoTributo().getClassificacaoTipoTributo();
        if (isencao.getReducaoImposto().booleanValue() && classificacao.isImposto().booleanValue()) {
            return isencao.getValorReducaoImposto();
        }
        if (isencao.getReducaoTaxa().booleanValue() && classificacao.isTaxa().booleanValue()) {
            return isencao.getValorReducaoTaxa();
        }
        if (isencao.getReducaoContribuicao().booleanValue() && classificacao.isContribuicao().booleanValue()) {
            return isencao.getValorReducaoContribuicao();
        }
        if (isencao.getReducaoReceitasNaoTributaveis().booleanValue() && classificacao.isReceitaNaoTributavel().booleanValue()) {
            return isencao.getValorReducaoReceitasNaoTrib();
        }
        return BigDecimal.ZERO;
    }

    private static void adicionaScriptLinha(Long idSegmento, CalculoConfigBase tributo, CalculoResultadoDTO calculoResultadoDTO, CalculoResultado resultado) {
        calculoResultadoDTO.getCache().forEach((identificador, valor) -> {
            Campo campoDinamico = tributo.getScript().stream().filter(calculoTributoScript -> calculoTributoScript.getIdentificador().compareTo((String)identificador) == 0).findFirst().map(CalculoScriptBase::getCampoDinamico).orElse(null);
            List traces = Optional.ofNullable(calculoResultadoDTO.getTrace()).map(trace -> (List)trace.get(identificador)).orElse(new ArrayList());
            resultado.getLinhas().add(CalculoLinha.from((Long)idSegmento, (CalculoResultado)resultado, (String)identificador, (Double)valor, (Campo)campoDinamico, (List)traces));
        });
    }

    private static CalculoResultado createOrAccumulateResultado(CalculoCadastro calculoCadastro, CalculoTributo tributo, CalculoResultadoDTO segmentoCalculoResultado, CalculoResultado resultado) {
        return Optional.ofNullable(resultado).map(calculoResultado -> {
            calculoResultado.setValor(calculoResultado.getValor().add(BigDecimal.valueOf(segmentoCalculoResultado.getValor())));
            Optional.ofNullable(segmentoCalculoResultado.getValorBase()).map(BigDecimal::valueOf).map(valorBase -> valorBase.add(calculoResultado.getValorBaseCalculo())).ifPresent(arg_0 -> ((CalculoResultado)calculoResultado).setValorBaseCalculo(arg_0));
            Optional.ofNullable(segmentoCalculoResultado.getValorVenalTerritorial()).map(BigDecimal::valueOf).map(valorVenalTerritorial -> valorVenalTerritorial.add(calculoResultado.getValorVenalTerritorial())).ifPresent(arg_0 -> ((CalculoResultado)calculoResultado).setValorVenalTerritorial(arg_0));
            Optional.ofNullable(segmentoCalculoResultado.getValorVenalPredial()).map(BigDecimal::valueOf).map(valorVenalPredial -> valorVenalPredial.add(calculoResultado.getValorVenalPredial())).ifPresent(arg_0 -> ((CalculoResultado)calculoResultado).setValorVenalPredial(arg_0));
            return calculoResultado;
        }).orElseGet(() -> CalculoResultado.from((CalculoCadastro)calculoCadastro, (CalculoTributo)tributo, (CalculoResultadoDTO)segmentoCalculoResultado));
    }

    private static Map<CalculoConfigBase, CalculoResultado> mergeTributosSegmentos(CadastroCalculoRoot root, CalculoCadastro calculoCadastro, Function<CadastroCalculoDTO, Map<? extends CalculoConfigBase, CalculoResultadoDTO>> resultadoGetter) {
        HashMap<CalculoConfigBase, CalculoResultado> tributosPorSegmento = new HashMap<CalculoConfigBase, CalculoResultado>();
        root.getChildren().forEach(segmento -> ((Map)resultadoGetter.apply((CadastroCalculoDTO)segmento)).forEach((tributo, segmentoCalculoResultado) -> tributosPorSegmento.compute((CalculoConfigBase)tributo, (t, resultado) -> {
            CalculoTributo chaveAgrupamento = tributo instanceof CalculoTributo ? (CalculoTributo)tributo : null;
            CalculoResultado retorno = CalculoCadastro.createOrAccumulateResultado((CalculoCadastro)calculoCadastro, (CalculoTributo)chaveAgrupamento, (CalculoResultadoDTO)segmentoCalculoResultado, (CalculoResultado)resultado);
            Long idSegmento = ((CadastroImobiliarioCalculoDTO)segmento).getSegmento().getIdsegmento();
            CalculoCadastro.adicionaScriptLinha((Long)idSegmento, (CalculoConfigBase)tributo, (CalculoResultadoDTO)segmentoCalculoResultado, (CalculoResultado)retorno);
            return retorno;
        })));
        return tributosPorSegmento;
    }

    private static Map<CalculoTributo, CalculoResultado> mergeTributosSegmentos(CadastroCalculoRoot root, CalculoCadastro calculoCadastro, Divida divida) {
        HashMap<CalculoTributo, CalculoResultado> tributosPorSegmento = new HashMap<CalculoTributo, CalculoResultado>();
        root.getChildren().forEach(segmento -> segmento.getResultado().forEach((tributo, segmentoCalculoResultado) -> {
            if (Objects.isNull(divida) || Boolean.TRUE.equals(CalculoCadastro.considerarResultado((CalculoTributo)tributo, (Divida)divida, (CalculoResultadoDTO)segmentoCalculoResultado))) {
                tributosPorSegmento.compute((CalculoTributo)tributo, (t, resultado) -> {
                    CalculoResultado retorno = CalculoCadastro.createOrAccumulateResultado((CalculoCadastro)calculoCadastro, (CalculoTributo)tributo, (CalculoResultadoDTO)segmentoCalculoResultado, (CalculoResultado)resultado);
                    Long idSegmento = ((CadastroImobiliarioCalculoDTO)segmento).getSegmento().getIdsegmento();
                    CalculoCadastro.adicionaScriptLinha((Long)idSegmento, (CalculoConfigBase)tributo, (CalculoResultadoDTO)segmentoCalculoResultado, (CalculoResultado)retorno);
                    return retorno;
                });
            }
        }));
        return tributosPorSegmento;
    }

    public Boolean hasInconsistencia() {
        return this.getInconsistencias().size() > 0;
    }

    public void validateValorMinimoDebitoAndParcela(String parametroIsencaoValorMinimo) {
        BigDecimal valorTotalDebito = this.resultados.stream().map(CalculoResultado::getValorTotal).reduce(BigDecimal.ZERO, BigDecimal::add);
        if (valorTotalDebito.compareTo(BigDecimal.ZERO) == 0) {
            return;
        }
        if (valorTotalDebito.compareTo(BigDecimal.ZERO) < 0) {
            CalculoInconsistencia inconsistencia = new CalculoInconsistencia();
            inconsistencia.setDescricao(String.format("D\u00e9bito com valor negativo %.2f, verifique a configura\u00e7\u00e3o de isen\u00e7\u00e3o do cadastro.", valorTotalDebito));
            this.addInconsistencia(inconsistencia);
            return;
        }
        if (this.divida.getValorMinimoDebito().compareTo(valorTotalDebito) > 0) {
            if (StringUtils.isBlank((CharSequence)parametroIsencaoValorMinimo)) {
                CalculoInconsistencia inconsistencia = new CalculoInconsistencia();
                inconsistencia.setDescricao(String.format("N\u00e3o h\u00e1 configura\u00e7\u00e3o de isen\u00e7\u00e3o para o valor m\u00ednimo do d\u00e9bito. Par\u00e2metro %s n\u00e3o encontrado para o exerc\u00edcio %d.", ParametroEntidadeExercicioEnum.ISENCAO_VALORMINIMO_DEBITO.getValue(), this.divida.getExercicio()));
                this.addInconsistencia(inconsistencia);
            }
            return;
        }
        if (this.divida.getValorMinimoParcela().compareTo(valorTotalDebito) > 0) {
            CalculoInconsistencia inconsistencia = new CalculoInconsistencia();
            inconsistencia.setDescricao(String.format("Valor calculado %.2f para a d\u00edvida %d - %s \u00e9 menor que o valor m\u00ednimo da parcela %.2f.", valorTotalDebito, this.divida.getDivida(), this.divida.getDescricao(), this.divida.getValorMinimoParcela()));
            this.addInconsistencia(inconsistencia);
            return;
        }
        if (this.divida.getNumeroMinimoParcela() > 0L) {
            BigDecimal valorParcelaConsiderandoQuantidadeMinima = CalculoUtils.divideETruncaValor((BigDecimal)valorTotalDebito, (Integer)this.divida.getNumeroMinimoParcela().intValue(), (Integer)CalculoValoresConstants.QUANTIDADE_CASAS_DECIMAIS);
            if (this.divida.getValorMinimoParcela().compareTo(valorParcelaConsiderandoQuantidadeMinima) > 0) {
                CalculoInconsistencia inconsistencia = new CalculoInconsistencia();
                inconsistencia.setDescricao(String.format("Valor calculado %.2f para a d\u00edvida %d - %s n\u00e3o atende a restri\u00e7\u00e3o de quantidade m\u00ednima %d e valor m\u00ednimo %.2f de parcela.", valorTotalDebito, this.divida.getDivida(), this.divida.getDescricao(), this.divida.getNumeroMinimoParcela(), this.divida.getValorMinimoParcela()));
                this.addInconsistencia(inconsistencia);
            }
        }
    }

    public void validateIdentificadorGrupoVencimento(Long grupoVencimento) {
        if (this.divida.getGruposVencimento().isEmpty() || this.divida.getGruposVencimento().stream().noneMatch(gv -> Objects.equals(gv.getGrupoVencimento(), grupoVencimento))) {
            CalculoInconsistencia inconsistencia = new CalculoInconsistencia();
            inconsistencia.setDescricao(String.format("N\u00e3o foi encontrado Grupo de Vencimento %d vinculado a Divida %d para o Ano de %d. Favor conferir o par\u00e2metro utilizado e o cadastro do Grupo de Vencimento da Divida %d.", grupoVencimento, this.divida.getDivida(), this.calculo.getExercicio(), this.divida.getDivida()));
            this.addInconsistencia(inconsistencia);
        }
    }

    public Boolean calculou() {
        return this.inconsistencias.size() > 0 || this.resultados.size() > 0;
    }

    public void vincularCarne(CarneDTO carneDTO) {
        if (Objects.nonNull(this.getNumeroCarne())) {
            throw new EloValidationException(String.format("Carn\u00ea %d/%d j\u00e1 gerado para este item.", this.getNumeroCarne(), this.getExercicioCarne()));
        }
        if (Objects.isNull(carneDTO)) {
            return;
        }
        this.setEntidadeCarne(carneDTO.getEntidade());
        this.setExercicioCarne(carneDTO.getExercicio());
        this.setNumeroCarne(carneDTO.getNumeroCarne());
    }

    public void limparCarne() {
        if (Objects.isNull(this.getNumeroCarne())) {
            throw new EloValidationException("Este item n\u00e3o possui carn\u00ea gerado para que possa ser exclu\u00eddo.");
        }
        this.setEntidadeCarne(null);
        this.setExercicioCarne(null);
        this.setNumeroCarne(null);
    }

    private void addInconsistencia(CalculoInconsistencia inconsistencia) {
        this.getInconsistencias().add(inconsistencia);
        inconsistencia.setCalculoCadastro(this);
    }

    @Generated
    public CalculoCadastro() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public Calculo getCalculo() {
        return this.calculo;
    }

    @Generated
    public CadastroGeral getCadastro() {
        return this.cadastro;
    }

    @Generated
    public Divida getDivida() {
        return this.divida;
    }

    @Generated
    public List<CalculoResultado> getResultados() {
        return this.resultados;
    }

    @Generated
    public List<CalculoInconsistencia> getInconsistencias() {
        return this.inconsistencias;
    }

    @Generated
    public BigDecimal getAliquota() {
        return this.aliquota;
    }

    @Generated
    public Debito getDebito() {
        return this.debito;
    }

    @Generated
    public Long getEntidadeCarne() {
        return this.entidadeCarne;
    }

    @Generated
    public Long getExercicioCarne() {
        return this.exercicioCarne;
    }

    @Generated
    public Long getNumeroCarne() {
        return this.numeroCarne;
    }

    @Generated
    public String getErroEmissaoBoleto() {
        return this.erroEmissaoBoleto;
    }

    @Generated
    public SituacaoGeracaoCarne getSituacaoCarne() {
        return this.situacaoCarne;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @JsonIgnoreProperties(value={"cadastros", "divida"})
    @Generated
    public void setCalculo(Calculo calculo) {
        this.calculo = calculo;
    }

    @JsonIgnoreProperties(value={"avaliacoes"})
    @Generated
    public void setCadastro(CadastroGeral cadastro) {
        this.cadastro = cadastro;
    }

    @Generated
    public void setDivida(Divida divida) {
        this.divida = divida;
    }

    @Generated
    public void setResultados(List<CalculoResultado> resultados) {
        this.resultados = resultados;
    }

    @Generated
    public void setInconsistencias(List<CalculoInconsistencia> inconsistencias) {
        this.inconsistencias = inconsistencias;
    }

    @Generated
    public void setAliquota(BigDecimal aliquota) {
        this.aliquota = aliquota;
    }

    @JsonIgnore
    @Generated
    public void setDebito(Debito debito) {
        this.debito = debito;
    }

    @Generated
    public void setEntidadeCarne(Long entidadeCarne) {
        this.entidadeCarne = entidadeCarne;
    }

    @Generated
    public void setExercicioCarne(Long exercicioCarne) {
        this.exercicioCarne = exercicioCarne;
    }

    @Generated
    public void setNumeroCarne(Long numeroCarne) {
        this.numeroCarne = numeroCarne;
    }

    @Generated
    public void setErroEmissaoBoleto(String erroEmissaoBoleto) {
        this.erroEmissaoBoleto = erroEmissaoBoleto;
    }

    @Generated
    public void setSituacaoCarne(SituacaoGeracaoCarne situacaoCarne) {
        this.situacaoCarne = situacaoCarne;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CalculoCadastro)) {
            return false;
        }
        CalculoCadastro other = (CalculoCadastro)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CalculoCadastro;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "CalculoCadastro(id=" + this.getId() + ")";
    }
}

