/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.supersimples.processamento;

import br.com.elotech.arquivos.domain.Arquivo;
import br.com.elotech.tributos.domain.supersimples.SuperSimplesSolicitacao;
import br.com.elotech.tributos.domain.supersimples.SuperSimplesSolicitacaoVarredura;
import br.com.elotech.tributos.domain.supersimples.SuperSimplesSolicitacaoVarreduraId;
import br.com.elotech.tributos.dto.supersimples.SuperSimplesSolicitacaoCnpjDTO;
import br.com.elotech.tributos.repository.supersimples.SuperSimplesSolicitacaoVarreduraRepository;
import br.com.elotech.tributos.service.supersimples.ProcessamentoSuperSimplesService;
import com.google.common.collect.Lists;
import java.util.List;
import javax.persistence.EntityManager;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.annotation.AfterStep;
import org.springframework.batch.core.annotation.BeforeStep;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.item.ItemWriter;
import org.springframework.stereotype.Component;

@StepScope
@Component
public class ProcessamentoArquivoVedadosSuperSimplesWriter
implements ItemWriter<SuperSimplesSolicitacaoCnpjDTO> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProcessamentoArquivoVedadosSuperSimplesWriter.class);
    private final ProcessamentoSuperSimplesService processamentoSuperSimplesService;
    private final SuperSimplesSolicitacaoVarreduraRepository superSimplesSolicitacaoVarreduraRepository;
    private final EntityManager entityManager;
    private StepExecution stepExecution;
    private List<SuperSimplesSolicitacaoCnpjDTO> solicitacaoCnpjDTOS = Lists.newArrayList();

    @BeforeStep
    public void beforeStep(StepExecution stepExecution) {
        this.stepExecution = stepExecution;
    }

    public void write(List<? extends SuperSimplesSolicitacaoCnpjDTO> items) throws Exception {
        this.solicitacaoCnpjDTOS.addAll(items);
    }

    @AfterStep
    public ExitStatus afterStep(StepExecution stepExecution) {
        try {
            Long idSolicitacao = stepExecution.getJobExecution().getJobParameters().getLong("idSolicitacao");
            Long sequenciaVarredura = stepExecution.getJobExecution().getJobParameters().getLong("sequenciaVarredura");
            String tipoOperacao = stepExecution.getJobExecution().getJobParameters().getString("tipoOperacao");
            SuperSimplesSolicitacao solicitacao = (SuperSimplesSolicitacao)this.entityManager.getReference(SuperSimplesSolicitacao.class, (Object)idSolicitacao);
            SuperSimplesSolicitacaoVarreduraId superSimplesSolicitacaoVarreduraId = new SuperSimplesSolicitacaoVarreduraId();
            superSimplesSolicitacaoVarreduraId.setSolicitacao(solicitacao);
            superSimplesSolicitacaoVarreduraId.setSequenciaVarredura(sequenciaVarredura);
            SuperSimplesSolicitacaoVarredura superSimplesSolicitacaoVarredura = (SuperSimplesSolicitacaoVarredura)this.superSimplesSolicitacaoVarreduraRepository.findOne((Object)superSimplesSolicitacaoVarreduraId);
            Arquivo arquivo = this.processamentoSuperSimplesService.uploadArquivoCnpjVedados(tipoOperacao, this.solicitacaoCnpjDTOS);
            superSimplesSolicitacaoVarredura.setIdArquivo(arquivo.getId());
            this.superSimplesSolicitacaoVarreduraRepository.save((Object)superSimplesSolicitacaoVarredura);
            return ExitStatus.COMPLETED;
        }
        catch (Exception e) {
            stepExecution.setStatus(BatchStatus.FAILED);
            stepExecution.setExitStatus(ExitStatus.FAILED.addExitDescription((Throwable)e));
            return stepExecution.getExitStatus();
        }
    }

    @Generated
    public ProcessamentoArquivoVedadosSuperSimplesWriter(ProcessamentoSuperSimplesService processamentoSuperSimplesService, SuperSimplesSolicitacaoVarreduraRepository superSimplesSolicitacaoVarreduraRepository, EntityManager entityManager) {
        this.processamentoSuperSimplesService = processamentoSuperSimplesService;
        this.superSimplesSolicitacaoVarreduraRepository = superSimplesSolicitacaoVarreduraRepository;
        this.entityManager = entityManager;
    }
}

