/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.simam.estornoinscricaodividaativa;

import br.com.elotech.tributos.domain.DebitoParcelaTributo;
import br.com.elotech.tributos.domain.simam.EstornoDebitoInscricaoDividaAtiva;
import br.com.elotech.tributos.domain.simam.EstornoDebitoInscricaoDividaAtivaID;
import br.com.elotech.tributos.domain.simam.EstornoInscricaoCreditoDividaAtiva;
import br.com.elotech.tributos.dto.simam.EstornoDividaAtivaConsultaDTO;
import br.com.elotech.tributos.repository.SequenceGeneratorRepository;
import br.com.elotech.tributos.repository.simam.EstornoInscricaoDividaAtivaRepository;
import br.com.elotech.tributos.util.DateUtils;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.LocalDate;
import java.util.Date;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import javax.persistence.EntityManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.annotation.BeforeStep;
import org.springframework.batch.core.annotation.OnProcessError;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.stereotype.Component;

@Component
@StepScope
public class EstornoInscricaoDividaAtivaBatchProcessor
implements ItemProcessor<EstornoDividaAtivaConsultaDTO, EstornoInscricaoCreditoDividaAtiva> {
    private static final Logger LOGGER = LoggerFactory.getLogger(EstornoInscricaoDividaAtivaBatchProcessor.class);
    private StepExecution stepExecution;
    private final ObjectMapper objectMapper;
    private final SequenceGeneratorRepository sequenceGeneratorRepository;
    private final EstornoInscricaoDividaAtivaRepository estornoInscricaoDividaAtivaRepository;
    private final EntityManager entityManager;
    private final AtomicLong ultimoNrEstorno = new AtomicLong(0L);
    private Long nrAnoEstorno;

    public EstornoInscricaoDividaAtivaBatchProcessor(ObjectMapper objectMapper, SequenceGeneratorRepository sequenceGeneratorRepository, EstornoInscricaoDividaAtivaRepository estornoInscricaoDividaAtivaRepository, EntityManager entityManager) {
        this.objectMapper = objectMapper;
        this.sequenceGeneratorRepository = sequenceGeneratorRepository;
        this.estornoInscricaoDividaAtivaRepository = estornoInscricaoDividaAtivaRepository;
        this.entityManager = entityManager;
    }

    @BeforeStep
    public void beforeStep(StepExecution stepExecution) {
        this.stepExecution = stepExecution;
        LocalDate dataInicial = DateUtils.dateToLocalDate((Date)Objects.requireNonNull(this.stepExecution.getJobExecution().getJobParameters().getDate("dataInicial")));
        LocalDate dataFinal = DateUtils.dateToLocalDate((Date)Objects.requireNonNull(this.stepExecution.getJobExecution().getJobParameters().getDate("dataFinal")));
        LOGGER.info("SIM-AM - Estorno Inscri\u00e7\u00e3o D\u00edvida Ativa - Iniciando gera\u00e7\u00e3o de dados - idControle: {}, exercicio: {} ", (Object)dataInicial, (Object)dataFinal);
        this.ultimoNrEstorno.set(this.estornoInscricaoDividaAtivaRepository.findNextNrEstornoByExercicio(Long.valueOf(dataInicial.getYear())));
        this.nrAnoEstorno = dataInicial.getYear();
    }

    public EstornoInscricaoCreditoDividaAtiva process(EstornoDividaAtivaConsultaDTO dto) {
        Long nextVal = this.sequenceGeneratorRepository.getNextVal("s05idtceinsccreditodaest");
        EstornoInscricaoCreditoDividaAtiva estornoInscricaoCreditoDividaAtiva = new EstornoInscricaoCreditoDividaAtiva();
        estornoInscricaoCreditoDividaAtiva.setId(nextVal);
        estornoInscricaoCreditoDividaAtiva.setNrEstorno(Long.valueOf(this.ultimoNrEstorno.getAndIncrement()));
        estornoInscricaoCreditoDividaAtiva.setNrAnoEstorno(this.nrAnoEstorno);
        estornoInscricaoCreditoDividaAtiva.setNrDivida(dto.getNrDivida());
        estornoInscricaoCreditoDividaAtiva.setNrAnoDivida(dto.getNrAnoDivida());
        estornoInscricaoCreditoDividaAtiva.setCdControleLeiAto(dto.getIdAto());
        estornoInscricaoCreditoDividaAtiva.setDtEstorno(dto.getDtEstorno());
        estornoInscricaoCreditoDividaAtiva.setVlEstorno(dto.getVlEstorno());
        estornoInscricaoCreditoDividaAtiva.setDsMotivo(dto.getDsMotivo());
        this.estornoInscricaoDividaAtivaRepository.saveAndFlush((Object)estornoInscricaoCreditoDividaAtiva);
        EstornoDebitoInscricaoDividaAtivaID id = new EstornoDebitoInscricaoDividaAtivaID();
        id.setIdTceInscCreditoDAEst((EstornoInscricaoCreditoDividaAtiva)this.entityManager.getReference(EstornoInscricaoCreditoDividaAtiva.class, (Object)nextVal));
        id.setIdDebitoParcelaReceita((DebitoParcelaTributo)this.entityManager.getReference(DebitoParcelaTributo.class, (Object)dto.getIdDebitoParcelaReceita()));
        EstornoDebitoInscricaoDividaAtiva estornoDebitoInscricaoDividaAtiva = new EstornoDebitoInscricaoDividaAtiva();
        estornoDebitoInscricaoDividaAtiva.setId(id);
        estornoDebitoInscricaoDividaAtiva.setValor(dto.getVlEstorno());
        return estornoInscricaoCreditoDividaAtiva;
    }

    @OnProcessError
    public void onProcessError(EstornoDividaAtivaConsultaDTO item, Exception e) throws JsonProcessingException {
        LOGGER.error("SIM-AM - Estorno Inscri\u00e7\u00e3o D\u00edvida Ativa - erro: {}\n{})", (Object)e.getMessage(), (Object)this.objectMapper.writeValueAsString((Object)item));
    }
}

