/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.geracaodebitocalculo;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.lib.painel.dto.NotificationStatus;
import br.com.elotech.tributos.calculo.domain.Calculo;
import br.com.elotech.tributos.calculo.domain.SituacaoCalculo;
import br.com.elotech.tributos.calculo.service.CalculoService;
import br.com.elotech.tributos.domain.batch.BatchJobExecution;
import br.com.elotech.tributos.service.NotificacaoService;
import br.com.elotech.tributos.service.ValidaDataMovimentacaoService;
import java.io.Serializable;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.listener.JobExecutionListenerSupport;
import org.springframework.stereotype.Component;

@Component
public class GeracaoDebitoCalculoJobListener
extends JobExecutionListenerSupport {
    private static final String ID_CALCULO = "idCalculo";
    private static final String ENTIDADE = "entidade";
    private static final String ID_NOTIFICACAO = "idNotificacao";
    private final NotificacaoService notificacaoService;
    private final CalculoService calculoService;
    private final ValidaDataMovimentacaoService validaDataMovimentacaoService;

    public void beforeJob(JobExecution jobExecution) {
        super.beforeJob(jobExecution);
        Long idCalculo = jobExecution.getJobParameters().getLong(ID_CALCULO);
        Long entidade = jobExecution.getJobParameters().getLong(ENTIDADE);
        Calculo calculo = (Calculo)this.calculoService.findOne((Serializable)idCalculo);
        if (!SituacaoCalculo.GERANDO_DEBITO.equals((Object)calculo.getSituacao()) && !SituacaoCalculo.ERRO_GERACAO_DEBITO.equals((Object)calculo.getSituacao())) {
            throw new EloValidationException(String.format("N\u00e3o \u00e9 poss\u00edvel processar a gera\u00e7\u00e3o de d\u00e9bitos para c\u00e1lculo com a situa\u00e7\u00e3o \"%s\".", calculo.getSituacao().getDescricao()));
        }
        Optional notificacaoId = this.notificacaoService.send(String.format("Iniciada a gera\u00e7\u00e3o de d\u00e9bitos do c\u00e1lculo %d.", idCalculo), null, jobExecution, Optional.empty(), NotificationStatus.STARTED);
        jobExecution.getExecutionContext().put(ID_NOTIFICACAO, notificacaoId.map(UUID::toString).orElse(null));
        this.validaDataMovimentacaoService.validaMesEDia(entidade, calculo.getDataLancamento());
        calculo.setSituacao(SituacaoCalculo.GERANDO_DEBITO);
        calculo.setBatchJobExecutionDebito(BatchJobExecution.of((JobExecution)jobExecution));
        this.calculoService.save((EloEntity)calculo, null);
    }

    public void afterJob(JobExecution jobExecution) {
        super.afterJob(jobExecution);
        Long idCalculo = jobExecution.getJobParameters().getLong(ID_CALCULO);
        UUID notificacaoId = Optional.ofNullable(jobExecution.getExecutionContext().get(ID_NOTIFICACAO)).map(Object::toString).map(UUID::fromString).orElse(null);
        if (BatchStatus.COMPLETED.equals((Object)jobExecution.getStatus())) {
            this.calculoService.updateSituacaoDebitoGeradoSeTodosCadastrosConsistentesComDebito(idCalculo);
            this.notificacaoService.send(String.format("Finalizada a gera\u00e7\u00e3o de d\u00e9bitos do c\u00e1lculo %d com sucesso.", idCalculo), null, jobExecution, Optional.ofNullable(notificacaoId), NotificationStatus.COMPLETED);
        }
        if (BatchStatus.FAILED.equals((Object)jobExecution.getStatus())) {
            this.calculoService.updateSituacaoCalculo(idCalculo, SituacaoCalculo.ERRO_GERACAO_DEBITO);
            this.notificacaoService.send(String.format("Ocorreu um erro na gera\u00e7\u00e3o de d\u00e9bitos do c\u00e1lculo %d.", idCalculo), null, jobExecution, Optional.ofNullable(notificacaoId), NotificationStatus.FAILED);
        }
    }

    @Generated
    public GeracaoDebitoCalculoJobListener(NotificacaoService notificacaoService, CalculoService calculoService, ValidaDataMovimentacaoService validaDataMovimentacaoService) {
        this.notificacaoService = notificacaoService;
        this.calculoService = calculoService;
        this.validaDataMovimentacaoService = validaDataMovimentacaoService;
    }
}

